/**
 * AdHub Bundle - legacy_adhubmedia (WITHOUT CMP)
 *
 * Questo file contiene tutto il necessario per integrare
 * AdHub con Prebid.js nel tuo sito.
 *
 * Include:
 * - Core AdHub libraries
 * - Configurazione SSP globale
 * - Configurazione sito-specifica
 *
 * Versione: 2.0.0 (NO CMP)
 * Build date: 2025-11-17 12:38:31
 *
 * NON MODIFICARE QUESTO FILE - È GENERATO AUTOMATICAMENTE
 * Per personalizzazioni, modifica i file in /sites/legacy_adhubmedia/
 */


// ============================================================================
// AUTOMATIC SCRIPT LOADER
// ============================================================================
(function() {
  'use strict';

  /**
   * Carica automaticamente script esterni
   * In questo modo il publisher deve includere SOLO questo bundle!
   */

  // Lista script da caricare
  const EXTERNAL_SCRIPTS = [
    {
      id: 'prebid-js',
      src: 'https://lib.adhubmedia.com/core/prebid/prebid-custom.js',
      async: true,
      required: true
    },
    {
      id: 'google-gpt',
      src: 'https://securepubads.g.doubleclick.net/tag/js/gpt.js',
      async: true,
      required: true
    }
  ];

  /**
   * Carica uno script in modo asincrono
   */
  function loadScript(config) {
    return new Promise(function(resolve, reject) {
      // Verifica se già caricato
      if (document.getElementById(config.id)) {
        console.log('[AdHub Loader] Script già presente:', config.id);
        resolve();
        return;
      }

      var script = document.createElement('script');
      script.id = config.id;
      script.src = config.src;

      if (config.async) {
        script.async = true;
      }

      script.onload = function() {
        console.log('[AdHub Loader] ✅ Caricato:', config.id);
        resolve();
      };

      script.onerror = function() {
        console.error('[AdHub Loader] ❌ Errore caricamento:', config.id);
        if (config.required) {
          reject(new Error('Failed to load required script: ' + config.id));
        } else {
          resolve(); // Non-required script, continue anyway
        }
      };

      // Inserisci nello <head> o <body>
      (document.head || document.body).appendChild(script);
    });
  }

  /**
   * Carica tutti gli script esterni
   */
  function loadExternalScripts() {
    console.log('[AdHub Loader] 🚀 Caricamento script esterni...');

    EXTERNAL_SCRIPTS.forEach(function(scriptConfig) {
      loadScript(scriptConfig);
    });
  }

  // Avvia caricamento quando DOM è pronto
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', loadExternalScripts);
  } else {
    loadExternalScripts();
  }

  console.log('[AdHub Loader] ✅ Script loader inizializzato');
})();


// ============================================================================
// PREBID.JS INITIALIZATION
// ============================================================================
var pbjs = pbjs || {};
pbjs.que = pbjs.que || [];
window.googletag = window.googletag || {};
window.googletag.cmd = window.googletag.cmd || [];


// ============================================================================
// ADHUB CORE LIBRARIES (WITHOUT CMP)
// ============================================================================

// From: adhub-prebid.js (Prebid.js Integration)
/**
 * AdHub Prebid.js Integration Module
 * Gestisce Header Bidding con multiple SSP
 *
 * @version 1.0.1
 * @requires Prebid.js 8.x+
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__adHubPrebidLoaded) {
    console.warn('[AdHubPrebid] Modulo già caricato - Skip duplicato');
    return;
  }
  window.__adHubPrebidLoaded = true;

  window.pbjs = window.pbjs || {};
  window.pbjs.que = window.pbjs.que || [];

  const AdHubPrebid = {
    config: {
      // Configurazione base
      timeout: 2000, // 2 secondi per auction
      priceGranularity: 'medium',
      currency: {
        adServerCurrency: 'EUR',
        granularityMultiplier: 1,
      },
      enableSendAllBids: false,
      bidderTimeout: 1500,

      // Configurazioni per SSP
      bidders: {},

      // Ad units Prebid
      adUnits: [],

      // Analytics
      analytics: {
        enabled: true,
        providers: []
      },

      // GDPR/TCF
      consentManagement: {
        gdpr: {
          cmpApi: 'iab',
          timeout: 3000,
          defaultGdprScope: true
        }
      },

      // User ID modules
      userSync: {
        userIds: [],
        syncDelay: 3000,
        auctionDelay: 0
      },

      // S2S (Server-to-Server) - opzionale
      s2sConfig: null
    },

    // Stato interno
    state: {
      initialized: false,
      auctionInProgress: false,
      bidsReceived: {},
      targeting: {},
      errors: []
    },

    /**
     * Inizializza Prebid con configurazione custom
     */
    init: function(customConfig = {}) {
      if (this.state.initialized) {
        console.warn('[AdHubPrebid] Already initialized');
        return;
      }

      // Merge configuration
      this.config = this._deepMerge(this.config, customConfig);

      // Load Prebid.js library
      this.loadPrebidScript(() => {
        console.log('[AdHubPrebid] Prebid.js loaded');
        this._setupPrebid();
        this.state.initialized = true;
      });

      return this;
    },

    /**
     * Carica script Prebid.js con fallback CDN
     */
    loadPrebidScript: function(callback) {
      if (window.pbjs && window.pbjs.version) {
        console.log('[AdHubPrebid] Prebid already loaded:', window.pbjs.version);
        return callback();
      }

      // Lista CDN in ordine di preferenza
      const cdnUrls = [
        '/lib/prebid-custom.js',  // Primo: build locale (se esiste)
        'https://cdn.jsdelivr.net/npm/prebid.js@8/dist/prebid.js',  // Latest 8.x
        'https://unpkg.com/prebid.js@8/dist/prebid.js',
        'https://cdnjs.cloudflare.com/ajax/libs/prebid.js/8.55.0/prebid.js'
      ];

      let currentIndex = 0;

      const tryLoadScript = () => {
        if (currentIndex >= cdnUrls.length) {
          console.error('[AdHubPrebid] All CDN sources failed');
          this.state.errors.push('prebid_load_failed_all_cdn');
          // Continua senza Prebid (fallback a solo GAM)
          return callback();
        }

        const script = document.createElement('script');
        script.async = true;
        script.type = 'text/javascript';
        script.src = cdnUrls[currentIndex];

        console.log(`[AdHubPrebid] Trying to load from: ${cdnUrls[currentIndex]}`);

        script.onload = () => {
          console.log(`[AdHubPrebid] Loaded successfully from: ${cdnUrls[currentIndex]}`);
          if (window.pbjs && window.pbjs.version) {
            console.log(`[AdHubPrebid] Prebid.js version: ${window.pbjs.version}`);
          }
          callback();
        };

        script.onerror = () => {
          console.warn(`[AdHubPrebid] Failed to load from: ${cdnUrls[currentIndex]}`);
          document.head.removeChild(script);
          currentIndex++;
          tryLoadScript();  // Prova prossimo CDN
        };

        document.head.appendChild(script);
      };

      tryLoadScript();
    },

    /**
     * Setup configurazione Prebid
     */
    _setupPrebid: function() {
      const self = this;

      pbjs.que.push(function() {
        // Set price granularity
        pbjs.setConfig({
          priceGranularity: self.config.priceGranularity,
          currency: self.config.currency,
          enableSendAllBids: self.config.enableSendAllBids,
          bidderTimeout: self.config.bidderTimeout,

          // GDPR consent management
          consentManagement: self.config.consentManagement,

          // User ID
          userSync: self.config.userSync,

          // Debug
          debug: self.config.debug || false,

          // Targeting
          targetingControls: {
            auctionKeyMaxChars: 5000,
            allowTargetingKeys: ['BIDDER', 'AD_ID', 'PRICE_BUCKET', 'SIZE', 'DEAL'],
            alwaysIncludeDeals: true
          }
        });

        // Setup S2S se configurato
        if (self.config.s2sConfig) {
          pbjs.setConfig({ s2sConfig: self.config.s2sConfig });
        }

        // Setup analytics
        if (self.config.analytics.enabled) {
          self._setupAnalytics();
        }

        console.log('[AdHubPrebid] Configuration set');
      });
    },

    /**
     * Registra ad units per Prebid
     */
    registerAdUnits: function(adUnits) {
      this.config.adUnits = adUnits;

      pbjs.que.push(function() {
        pbjs.addAdUnits(adUnits);
        console.log('[AdHubPrebid] Ad units registered:', adUnits.length);
      });

      return this;
    },

    /**
     * Rileva e crea ad units per placeholder legacy
     * Questa funzione cerca i placeholder generati dall'SDK Legacy
     * e crea automaticamente gli ad units Prebid corrispondenti
     */
    detectAndCreateLegacyAdUnits: function() {
      console.log('[AdHubPrebid] 🔍 Ricerca placeholder legacy per Prebid...');

      const legacyPlaceholders = document.querySelectorAll('[data-adhub-legacy="true"]');

      if (legacyPlaceholders.length === 0) {
        console.log('[AdHubPrebid] Nessun placeholder legacy trovato');
        return this;
      }

      console.log('[AdHubPrebid] 📦 Trovati ' + legacyPlaceholders.length + ' placeholder legacy');

      const self = this;
      const legacyAdUnits = [];
      const siteName = 'legacy_adhubmedia'; // Site name per SSP config

      legacyPlaceholders.forEach(function(div, index) {
        const placeholderId = div.id;
        const legacyDimensions = div.getAttribute('data-legacy-dimensions');
        const legacyType = div.getAttribute('data-legacy-type');

        if (!placeholderId || !legacyDimensions) {
          console.warn('[AdHubPrebid] ⚠️ Placeholder senza ID o dimensioni:', div);
          return;
        }

        console.log('[AdHubPrebid] 📋 Creazione ad unit legacy:', placeholderId, legacyDimensions);

        // Parse dimensions e crea sizes array
        const sizes = self._parseLegacyDimensionsForPrebid(legacyDimensions);

        if (sizes.length === 0) {
          console.warn('[AdHubPrebid] ⚠️ Dimensioni non valide per:', placeholderId);
          return;
        }

        // Crea ad unit Prebid
        const adUnit = {
          code: placeholderId,
          mediaTypes: {},
          bids: []
        };

        // Configura mediaTypes in base al tipo
        if (legacyType === 'native') {
          adUnit.mediaTypes.native = {
            title: { required: true, len: 80 },
            body: { required: true },
            image: { required: true, sizes: sizes },
            sponsoredBy: { required: false },
            icon: { required: false, sizes: [50, 50] }
          };
        } else if (legacyType === 'video') {
          adUnit.mediaTypes.video = {
            context: 'instream',
            playerSize: sizes,
            mimes: ['video/mp4', 'video/webm'],
            protocols: [2, 3, 5, 6],
            playbackmethod: [1, 2]
          };
        } else {
          // Display (default)
          adUnit.mediaTypes.banner = {
            sizes: sizes
          };
        }

        // Genera bidder params usando SSP config se disponibile
        if (window.AdHubSSPConfig && window.AdHubSSPConfig.generateBidderParams) {
          try {
            adUnit.bids = window.AdHubSSPConfig.generateBidderParams(
              siteName,
              'legacy-' + legacyDimensions.replace(/x/g, '-'),
              sizes
            );
          } catch (e) {
            console.warn('[AdHubPrebid] ⚠️ Errore generazione bidder params:', e);
            adUnit.bids = [];
          }
        }

        // Aggiungi targeting legacy come context data
        const legacyTargeting = self._extractLegacyTargetingForPrebid(div);
        if (Object.keys(legacyTargeting).length > 0) {
          adUnit.ortb2Imp = {
            ext: {
              data: legacyTargeting
            }
          };
        }

        legacyAdUnits.push(adUnit);
      });

      // Registra gli ad units legacy
      if (legacyAdUnits.length > 0) {
        pbjs.que.push(function() {
          pbjs.addAdUnits(legacyAdUnits);
          console.log('[AdHubPrebid] ✅ Registrati ' + legacyAdUnits.length + ' ad units legacy');
        });

        // Aggiungi anche alla config interna
        this.config.adUnits = this.config.adUnits.concat(legacyAdUnits);
      }

      return this;
    },

    /**
     * Parse dimensioni legacy per Prebid
     * @private
     */
    _parseLegacyDimensionsForPrebid: function(dimensions) {
      const match = dimensions.match(/(\d+)x(\d+)/i);
      if (!match) return [];

      const width = parseInt(match[1], 10);
      const height = parseInt(match[2], 10);

      if (isNaN(width) || isNaN(height)) return [];

      // Dimensioni base
      const sizes = [[width, height]];

      // Aggiungi alternative responsive per formati comuni
      if (width === 728 && height === 90) {
        sizes.push([320, 50], [320, 100]);
      } else if (width === 970 && height === 250) {
        sizes.push([728, 90], [320, 100]);
      } else if (width === 300 && height === 250) {
        sizes.push([336, 280]);
      } else if (width === 160 && height === 600) {
        sizes.push([120, 600]);
      }

      return sizes;
    },

    /**
     * Estrae targeting legacy per Prebid
     * @private
     */
    _extractLegacyTargetingForPrebid: function(div) {
      const targeting = {};

      Array.from(div.attributes).forEach(function(attr) {
        if (attr.name.startsWith('data-targeting-')) {
          const key = attr.name.replace('data-targeting-', '');
          targeting[key] = attr.value;
        }
      });

      targeting.legacy_sdk = 'true';
      targeting.legacy_cid = div.getAttribute('data-legacy-cid') || '';

      return targeting;
    },

    /**
     * Avvia auction Prebid
     */
    requestBids: function(adUnitCodes, callback) {
      const self = this;

      if (this.state.auctionInProgress) {
        console.warn('[AdHubPrebid] Auction already in progress');
        return;
      }

      this.state.auctionInProgress = true;
      const startTime = Date.now();

      pbjs.que.push(function() {
        pbjs.requestBids({
          adUnitCodes: adUnitCodes,
          timeout: self.config.timeout,
          bidsBackHandler: function(bids) {
            const duration = Date.now() - startTime;
            console.log('[AdHubPrebid] Bids received in ' + duration + 'ms:', bids);

            self.state.auctionInProgress = false;
            self.state.bidsReceived = bids;

            // Get targeting
            self.state.targeting = pbjs.getAdserverTargeting();

            // Log bid analytics
            self._logBidResults(bids, duration);

            if (callback) callback(bids);
          }
        });
      });

      return this;
    },

    /**
     * Imposta targeting su GAM
     */
    setTargetingForGAM: function() {
      const self = this;

      pbjs.que.push(function() {
        pbjs.setTargetingForGPTAsync();
        console.log('[AdHubPrebid] Targeting set for GAM');
      });

      return this;
    },

    /**
     * Rendering workflow completo: Prebid -> GAM
     */
    renderAds: function(adUnitCodes, onComplete) {
      const self = this;

      console.log('[AdHubPrebid] Starting render workflow for:', adUnitCodes);

      // 1. Request bids da SSP
      this.requestBids(adUnitCodes, function(bids) {

        // 2. Set targeting su GAM
        self.setTargetingForGAM();

        // 3. Refresh GAM slots
        googletag.cmd.push(function() {
          const slots = googletag.pubads().getSlots().filter(slot => {
            return adUnitCodes.includes(slot.getSlotElementId());
          });

          if (slots.length > 0) {
            googletag.pubads().refresh(slots);
            console.log('[AdHubPrebid] GAM slots refreshed:', slots.length);
          }
        });

        if (onComplete) onComplete(bids);
      });

      return this;
    },

    /**
     * Setup analytics providers
     */
    _setupAnalytics: function() {
      const self = this;

      this.config.analytics.providers.forEach(provider => {
        if (provider.enabled) {
          pbjs.enableAnalytics([{
            provider: provider.name,
            options: provider.options
          }]);
          console.log('[AdHubPrebid] Analytics enabled:', provider.name);
        }
      });
    },

    /**
     * Log risultati bid per analytics
     */
    _logBidResults: function(bids, duration) {
      const results = {
        timestamp: new Date().toISOString(),
        duration: duration,
        timeout: this.config.timeout,
        bids: {}
      };

      // Verifica che bids sia un oggetto valido
      if (!bids || typeof bids !== 'object') {
        console.warn('[AdHubPrebid] No bids to log');
        return;
      }

      // Analizza ogni ad unit
      Object.keys(bids).forEach(adUnitCode => {
        const unitBids = pbjs.getBidResponsesForAdUnitCode(adUnitCode);

        results.bids[adUnitCode] = {
          received: unitBids.bids ? unitBids.bids.length : 0,
          highest: null,
          bidders: []
        };

        if (unitBids.bids && unitBids.bids.length > 0) {
          // Trova bid più alto
          const sortedBids = unitBids.bids.sort((a, b) => b.cpm - a.cpm);
          results.bids[adUnitCode].highest = {
            bidder: sortedBids[0].bidder,
            cpm: sortedBids[0].cpm,
            currency: sortedBids[0].currency
          };

          // Log tutti i bidder
          results.bids[adUnitCode].bidders = sortedBids.map(bid => ({
            bidder: bid.bidder,
            cpm: bid.cpm,
            size: bid.size,
            dealId: bid.dealId
          }));
        }
      });

      // Log su console solo se ci sono bids
      if (Object.keys(results.bids).length > 0) {
        console.table(results.bids);
      }

      // Salva per analytics
      this._sendAnalytics('auction_complete', results);
    },

    /**
     * Invia dati analytics
     */
    _sendAnalytics: function(eventType, data) {
      if (!this.config.analytics.enabled) return;

      // Puoi inviare a GA4, server custom, ecc.
      if (window.gtag) {
        gtag('event', 'prebid_' + eventType, data);
      }

      // Custom analytics endpoint
      if (this.config.analytics.endpoint) {
        fetch(this.config.analytics.endpoint, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify({ event: eventType, data: data })
        }).catch(e => console.error('[AdHubPrebid] Analytics error:', e));
      }
    },

    /**
     * Helper: deep merge objects
     */
    _deepMerge: function(target, source) {
      const output = Object.assign({}, target);
      if (this._isObject(target) && this._isObject(source)) {
        Object.keys(source).forEach(key => {
          if (this._isObject(source[key])) {
            if (!(key in target))
              Object.assign(output, { [key]: source[key] });
            else
              output[key] = this._deepMerge(target[key], source[key]);
          } else {
            Object.assign(output, { [key]: source[key] });
          }
        });
      }
      return output;
    },

    _isObject: function(item) {
      return item && typeof item === 'object' && !Array.isArray(item);
    },

    /**
     * Get bid info per debugging
     */
    getBidInfo: function(adUnitCode) {
      return pbjs.getBidResponsesForAdUnitCode(adUnitCode);
    },

    /**
     * Get all targeting
     */
    getAllTargeting: function() {
      return this.state.targeting;
    }
  };

  // Export globale
  window.AdHubPrebid = AdHubPrebid;

  /**
   * Inizializzazione automatica solo se non è richiesto il consenso CMP
   * Se è presente AdHubCMP, aspetta l'evento 'adhub:consent:ready'
   *
   * NOTA: Se esiste una configurazione sito-specifica (es. professionemamma/config.js),
   * quella si occuperà dell'inizializzazione. Questo auto-init serve solo come fallback.
   */
  function autoInit() {
    // Se esiste AdHubCMP, aspetta il consenso
    if (window.AdHubCMP) {
      console.log('[AdHubPrebid] AdHubCMP rilevato - Attesa consenso prima dell\'inizializzazione');

      // Ascolta l'evento di consenso pronto
      window.addEventListener('adhub:consent:ready', function(event) {
        console.log('[AdHubPrebid] Consenso ricevuto');

        // Verifica se il consenso è stato effettivamente dato
        if (event.detail && event.detail.consentGiven) {
          // Inizializzazione automatica SOLO se:
          // 1. AdHubPrebidConfig è disponibile
          // 2. Nessuna configurazione sito-specifica ha già inizializzato
          // 3. Aspetta 200ms per dare priorità alle config sito-specifiche
          setTimeout(function() {
            if (window.AdHubPrebidConfig && !AdHubPrebid.state.initialized) {
              console.log('[AdHubPrebid] Inizializzazione automatica (fallback)');
              AdHubPrebid.init(window.AdHubPrebidConfig);
            } else if (!window.AdHubPrebidConfig) {
              console.log('[AdHubPrebid] Nessuna configurazione - Attesa init manuale');
            }
          }, 200);
        } else {
          console.warn('[AdHubPrebid] Consenso negato - Prebid non inizializzato');
        }
      });

      // Gestisci il caso senza CMP
      window.addEventListener('adhub:consent:nocmp', function() {
        console.log('[AdHubPrebid] Nessuna CMP rilevata');

        // Verifica se AdHubCMP è in strict mode
        const cmpState = window.AdHubCMP.getState();
        if (!cmpState.initialized && window.AdHubCMP.getConfig().STRICT_MODE === false) {
          console.log('[AdHubPrebid] Inizializzazione senza CMP (strict mode disabled)');
          setTimeout(function() {
            if (window.AdHubPrebidConfig && !AdHubPrebid.state.initialized) {
              AdHubPrebid.init(window.AdHubPrebidConfig);
            }
          }, 200);
        }
      });

      // Gestisci il caso di consenso negato
      window.addEventListener('adhub:consent:denied', function() {
        console.warn('[AdHubPrebid] Consenso negato - Prebid bloccato');
      });

    } else {
      // Nessun sistema di consenso rilevato - inizializzazione diretta
      console.log('[AdHubPrebid] Nessun sistema di consenso rilevato - Inizializzazione diretta');

      if (window.AdHubPrebidConfig) {
        // Aspetta un breve momento per dare tempo alla configurazione di caricarsi
        setTimeout(function() {
          if (!AdHubPrebid.state.initialized) {
            AdHubPrebid.init(window.AdHubPrebidConfig);
          }
        }, 100);
      }
    }
  }

  // Avvia auto-init quando il DOM è pronto
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', autoInit);
  } else {
    autoInit();
  }

  console.log('[AdHubPrebid] Module loaded');
})();


// ============================================================================
// GAM SLOTS OVERRIDE (SITE-SPECIFIC - Must load BEFORE adhub-gam.js)
// ============================================================================

/**
 * AdHubMedia.com - GAM Slots Override
 *
 * Override della configurazione GAM per AdHubMedia.com
 * Tutti gli ad units usano il tag GAM: /131207395/Adhubmedia
 *
 * @version 1.0.0
 * @date 2024-11-04
 */

(function () {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__adHubMediaGAMOverrideLoaded) {
    console.warn('[AdHubMedia GAM] Override già caricato - Skip duplicato');
    return;
  }
  window.__adHubMediaGAMOverrideLoaded = true;

  /**
   * Configurazione GAM specifica per AdHubMedia.com
   * Questo oggetto viene usato da AdHubGAM per sovrascrivere i default
   */
  window.AdHubGAMConfig = {
    networkCode: '131207395',
    sitePrefix: 'adhubmedia',

    // Slot specifici AdHubMedia - TUTTI usano /131207395/Adhubmedia
    slots: [
      {
        code: 'adhub-top-banner',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[970, 250], [728, 90], [320, 100], [320, 50]],
        // Size mapping responsivo: desktop vs mobile
        sizeMapping: [
          { viewport: [1024, 0], sizes: [[970, 250], [728, 90]] },      // Desktop: 970x250, 728x90
          { viewport: [768, 0], sizes: [[728, 90], [320, 100]] },       // Tablet: 728x90, 320x100
          { viewport: [0, 0], sizes: [[320, 100], [320, 50]] }          // Mobile: solo 320x100, 320x50
        ],
        targeting: { position: 'top', type: 'banner' }
      },
      {
        code: 'adhub-sidebar',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[300, 250], [300, 600]],
        targeting: { position: 'sidebar', type: 'banner' }
      },
      {
        code: 'adhub-in-article',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[300, 250], [336, 280]],
        targeting: { position: 'in-article', type: 'native' }
      },
      {
        code: 'adhub-sticky-bottom',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[728, 90], [320, 50]],
        // Size mapping responsivo
        sizeMapping: [
          { viewport: [768, 0], sizes: [[728, 90]] },           // Desktop/Tablet: 728x90
          { viewport: [0, 0], sizes: [[320, 50]] }              // Mobile: solo 320x50
        ],
        targeting: { position: 'bottom', type: 'sticky' }
      },
      {
        code: 'adhub-728x90-banner',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[728, 90], [300, 250]],
        sizeMapping: [
          { viewport: [768, 0], sizes: [[728, 90]] },     // Desktop: 728x90
          { viewport: [0, 0], sizes: [[300, 250]] }       // Mobile: 300x250
        ],
        targeting: { position: '728x90-banner', type: 'banner' }
      },
      {
        code: 'adhub-300x250-top',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[300, 250]],
        targeting: { position: 'article-top' }
      },
      {
        code: 'adhub-300x250-mid',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[300, 250]],
        targeting: { position: 'article-mid' }
      },
      {
        code: 'adhub-300x250-bottom',
        adUnit: '/131207395/Adhubmedia',
        sizes: [[300, 250]],
        targeting: { position: 'article-bottom' }
      },
      {
        code: 'adhub-in-article-1',
        adUnit: '/131207395/Adhubmedia',  // ← STESSO TAG in-article
        sizes: [[300, 250], [336, 280]],
        targeting: { position: 'in-article-1', type: 'native' }
      },
      {
        code: 'adhub-in-article-2',
        adUnit: '/131207395/Adhubmedia',  // ← STESSO TAG in-article
        sizes: [[300, 250], [336, 280]],
        targeting: { position: 'in-article-2', type: 'native' }
      },
      {
        code: 'adhub-in-article-3',
        adUnit: '/131207395/Adhubmedia',  // ← STESSO TAG in-article
        sizes: [[300, 250], [336, 280]],
        targeting: { position: 'in-article-3', type: 'native' }
      }
    ],

    // Opzioni GAM (ottimizzate per performance)
    options: {
      enableSingleRequest: true,
      collapseEmptyDivs: true,
      centering: true,
      disableInitialLoad: true,

      // Lazy Load per slot sotto fold (migliora performance)
      enableLazyLoad: {
        fetchMarginPercent: 200,    // Inizia fetch quando slot è a 200% viewport dal bordo
        renderMarginPercent: 100,   // Renderizza quando slot è a 100% viewport dal bordo
        mobileScaling: 2.0          // Su mobile: margini 2x più grandi (400% fetch, 200% render)
      }
    },

    // Timeout auction (opzionale)
    auctionTimeout: 2000,

    // Auto-init dopo consenso (opzionale)
    autoInit: true
  };

  console.log('[AdHubMedia GAM] ✅ Override configurazione caricato');
  console.log('[AdHubMedia GAM] 📊 Slot configurati:', window.AdHubGAMConfig.slots.length);
  console.log('[AdHubMedia GAM] 🏷️  Tutti gli slot usano: /131207395/Adhubmedia');

  /**
   * Export API specifica per debug/utility
   * (opzionale - per retro-compatibilità con codice esistente)
   */
  window.AdHubMediaGAM = {
    // Riferimento alla config
    config: window.AdHubGAMConfig,

    // Lista tutti gli slot codes
    getSlotCodes: function() {
      return window.AdHubGAMConfig.slots.map(function(s) { return s.code; });
    },

    // Get slot per code
    getSlotByCode: function(code) {
      return window.AdHubGAMConfig.slots.find(function(s) { return s.code === code; });
    },

    // Refresh slot specifici
    refreshSlots: function(slotCodes) {
      if (window.AdHubGAM) {
        return window.AdHubGAM.refreshSlots(slotCodes);
      }
      console.error('[AdHubMedia GAM] AdHubGAM non ancora caricato');
    },

    // Stato sistema GAM
    getState: function() {
      if (window.AdHubGAM) {
        return window.AdHubGAM.getState();
      }
      return { error: 'AdHubGAM non caricato' };
    },

    // Inizializza GAM manualmente (raramente necessario)
    init: function() {
      if (window.AdHubGAM) {
        return window.AdHubGAM.init();
      }
      console.error('[AdHubMedia GAM] AdHubGAM non ancora caricato');
    },

    // Richiedi annunci (raramente necessario, AutoInit lo fa automaticamente)
    requestAds: function() {
      if (window.AdHubGAM) {
        return window.AdHubGAM.requestAds();
      }
      console.error('[AdHubMedia GAM] AdHubGAM non ancora caricato');
    }
  };

})();
// From: adhub-gam.js (GAM Integration - Default)
/**
 * AdHub GAM Integration - Generic Default Slots
 *
 * Sistema generico per l'integrazione con Google Ad Manager.
 * Definisce slot di default che possono essere sovrascritti da configurazioni specifiche per sito.
 *
 * @version 1.0.0
 * @date 2025-10-30
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__AdHubGAMLoaded) {
    console.warn('[AdHub GAM] Sistema già caricato - Skip duplicato');
    return;
  }
  window.__AdHubGAMLoaded = true;

  /**
   * Configurazione di default
   * Può essere sovrascritta tramite window.AdHubGAMConfig prima del caricamento
   */
  const DEFAULT_CONFIG = {
    networkCode: '131207395', // Default network code
    sitePrefix: 'adhub',      // Default prefix per ad units

    // Slot generici di default
    // Tutti usano AdhubMedia_RON come fallback default (Run of Network)
    slots: [
      {
        code: 'adhub-top-banner',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[970, 250], [728, 90], [320, 100], [320, 50]],
        targeting: { position: 'top', type: 'banner' }
      },
      {
        code: 'adhub-sidebar',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[300, 250], [300, 600]],
        targeting: { position: 'sidebar', type: 'banner' }
      },
      {
        code: 'adhub-in-article',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[300, 250], [336, 280]],
        targeting: { position: 'in-article', type: 'native' }
      },
      {
        code: 'adhub-sticky-bottom',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[728, 90], [320, 50]],
        targeting: { position: 'bottom', type: 'sticky' }
      },
      {
        code: 'adhub-200x250-top',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[300, 250]],
        targeting: { position: 'article-top' }
      },
      {
        code: 'adhub-200x250-mid',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[300, 250]],
        targeting: { position: 'article-mid' }
      },
      {
        code: 'adhub-200x250-bottom',
        adUnit: '/131207395/AdhubMedia_RON',
        sizes: [[300, 250]],
        targeting: { position: 'article-bottom' }
      },
    ],

    // Opzioni globali GAM (DEFAULT - Possono essere sovrascritte da window.AdHubGAMConfig)
    options: {
      // Single Request Mode (default: false per permettere refresh indipendente)
      // I siti possono sovrascrivere con window.AdHubGAMConfig.options.enableSingleRequest = true
      enableSingleRequest: false,
      collapseEmptyDivs: true,
      centering: true,
      disableInitialLoad: true,  // Aspetta Prebid
      enableLazyLoad: false  // Disabilitato - Carica immediatamente
    },

    // Timeout auction Prebid (ms)
    auctionTimeout: 2000,

    // Auto-init dopo consenso
    autoInit: true
  };

  /**
   * Merge configurazione custom con default
   */
  function mergeConfig(customConfig) {
    if (!customConfig) return DEFAULT_CONFIG;

    const merged = Object.assign({}, DEFAULT_CONFIG);

    // Merge proprietà semplici
    Object.keys(customConfig).forEach(function(key) {
      if (key === 'slots') {
        // Per gli slot, se custom definisce slot, usa quelli
        merged.slots = customConfig.slots;
      } else if (key === 'options') {
        // Merge options
        merged.options = Object.assign({}, DEFAULT_CONFIG.options, customConfig.options);
      } else {
        merged[key] = customConfig[key];
      }
    });

    return merged;
  }

  // Configurazione finale (merge custom se presente)
  const CONFIG = mergeConfig(window.AdHubGAMConfig);

  /**
   * Stato interno con tracking dettagliato per ogni slot
   */
  const state = {
    initialized: false,
    slotsCreated: false,
    adsRequested: false,
    definedSlots: [],

    // Tracking separato per ogni slot AdHub
    slotTracking: {}, // { slotCode: { requested, rendered, viewable, empty, lastRefresh, renderCount } }

    // Set di slot codes gestiti da AdHub (per filtrare eventi)
    managedSlots: new Set()
  };

  /**
   * Verifica dipendenze
   */
  function checkDependencies() {
    const missing = [];

    if (!window.googletag) {
      missing.push('googletag (Google Ad Manager)');
    }

    if (typeof pbjs === 'undefined') {
      missing.push('pbjs (Prebid.js)');
    }

    return missing;
  }

  /**
   * Inizializza GAM e definisce slot
   */
  function initializeGAM() {
    if (state.initialized) {
      console.warn('[AdHub GAM] Sistema già inizializzato');
      return;
    }

    const missing = checkDependencies();
    if (missing.length > 0) {
      console.error('[AdHub GAM] Dipendenze mancanti:', missing.join(', '));
      return;
    }

    console.log('[AdHub GAM] 🚀 Inizializzazione slot GAM...');
    console.log('[AdHub GAM] Network Code:', CONFIG.networkCode);
    console.log('[AdHub GAM] Site Prefix:', CONFIG.sitePrefix);

    state.initialized = true;

    googletag.cmd.push(function() {
      defineSlots();
      configurePubads();
      enableServices();
    });
  }

  /**
   * Definisce tutti gli slot GAM
   */
  function defineSlots() {
    if (state.slotsCreated) {
      console.warn('[AdHub GAM] Slot già definiti');
      return;
    }

    console.log('[AdHub GAM] 📋 Definizione slot...');
    let slotsCreated = 0;

    CONFIG.slots.forEach(function(slotConfig) {
      // Verifica che il div esista nel DOM
      const divElement = document.getElementById(slotConfig.code);
      if (!divElement) {
        // Slot configurato ma placeholder non presente in pagina - skip silenzioso
        return;
      }

      // Costruisci ad unit path se necessario
      let adUnitPath = slotConfig.adUnit;
      if (!adUnitPath.startsWith('/')) {
        adUnitPath = '/' + CONFIG.networkCode + '/' + adUnitPath;
      }

      // Definisci slot
      const slot = googletag.defineSlot(
        adUnitPath,
        slotConfig.sizes,
        slotConfig.code
      );

      if (slot) {
        slot.addService(googletag.pubads());

        // Size mapping responsive (se presente)
        if (slotConfig.sizeMapping && slotConfig.sizeMapping.length > 0) {
          var mapping = googletag.sizeMapping();
          slotConfig.sizeMapping.forEach(function(map) {
            mapping.addSize(map.viewport, map.sizes);
          });
          slot.defineSizeMapping(mapping.build());
          console.log('[AdHub GAM] 📐 Size mapping applicato a:', slotConfig.code);
        }

        // Aggiungi targeting custom per questo slot
        if (slotConfig.targeting) {
          Object.keys(slotConfig.targeting).forEach(function(key) {
            slot.setTargeting(key, slotConfig.targeting[key]);
          });
        }

        state.definedSlots.push({
          code: slotConfig.code,
          slot: slot,
          config: slotConfig
        });

        // Aggiungi al set di slot gestiti da AdHub
        state.managedSlots.add(slotConfig.code);

        // Inizializza tracking per questo slot
        state.slotTracking[slotConfig.code] = {
          requested: false,
          rendered: false,
          viewable: false,
          empty: null,
          lastRefresh: null,
          renderCount: 0,
          createdAt: Date.now()
        };

        slotsCreated++;
        console.log('[AdHub GAM] ✅ Slot definito: ' + slotConfig.code);
      } else {
        console.error('[AdHub GAM] ❌ Errore definizione slot: ' + slotConfig.code);
      }
    });

    state.slotsCreated = true;
    console.log('[AdHub GAM] 📊 Slot creati: ' + slotsCreated + '/' + CONFIG.slots.length);

    // Auto-detect e crea slot legacy
    const legacySlots = detectAndCreateLegacySlots();
    if (legacySlots > 0) {
      console.log('[AdHub GAM] 🔄 Slot legacy rilevati e creati: ' + legacySlots);
    }
  }

  /**
   * Rileva e crea automaticamente slot per placeholder legacy
   * (generati da SDK Legacy per tag 4wnetwork)
   */
  function detectAndCreateLegacySlots() {
    console.log('[AdHub GAM] 🔍 Ricerca placeholder legacy...');

    // Trova tutti i placeholder con attributo data-adhub-legacy
    const legacyPlaceholders = document.querySelectorAll('[data-adhub-legacy="true"]');

    if (legacyPlaceholders.length === 0) {
      console.log('[AdHub GAM] ℹ️  Nessun placeholder legacy trovato');
      return 0;
    }

    console.log('[AdHub GAM] 📦 Trovati ' + legacyPlaceholders.length + ' placeholder legacy');

    let createdSlots = 0;

    legacyPlaceholders.forEach(function(div) {
      const placeholderId = div.id;

      // Skip se già definito
      if (state.managedSlots.has(placeholderId)) {
        console.log('[AdHub GAM] ⏭️  Slot già gestito: ' + placeholderId);
        return;
      }

      // Estrai info dal placeholder
      const legacyType = div.getAttribute('data-legacy-type') || 'display';
      const legacyDimensions = div.getAttribute('data-legacy-dimensions') || '';
      const legacyCid = div.getAttribute('data-legacy-cid') || '';

      console.log('[AdHub GAM] 🏷️  Creazione slot legacy: ' + placeholderId + ' (' + legacyDimensions + ')');

      // Determina sizes basandosi sulle dimensioni legacy
      const sizes = parseLegacyDimensions(legacyDimensions);

      if (sizes.length === 0) {
        console.warn('[AdHub GAM] ⚠️  Dimensioni non valide per: ' + placeholderId);
        return;
      }

      // Crea slot GAM
      try {
        // AdUnit path: usa default RON (Run of Network)
        const adUnitPath = '/' + CONFIG.networkCode + '/AdhubMedia_RON';

        const slot = googletag.defineSlot(
          adUnitPath,
          sizes,
          placeholderId
        );

        if (slot) {
          slot.addService(googletag.pubads());

          // Estrai e applica targeting legacy
          const legacyTargeting = extractLegacyTargeting(div);
          Object.keys(legacyTargeting).forEach(function(key) {
            slot.setTargeting(key, legacyTargeting[key]);
          });

          // Aggiungi allo stato
          state.definedSlots.push({
            code: placeholderId,
            slot: slot,
            config: {
              code: placeholderId,
              adUnit: adUnitPath,
              sizes: sizes,
              targeting: legacyTargeting,
              legacy: true
            }
          });

          state.managedSlots.add(placeholderId);

          state.slotTracking[placeholderId] = {
            requested: false,
            rendered: false,
            viewable: false,
            empty: null,
            lastRefresh: null,
            renderCount: 0,
            createdAt: Date.now(),
            legacy: true,
            legacyType: legacyType,
            legacyCid: legacyCid
          };

          createdSlots++;
          console.log('[AdHub GAM] ✅ Slot legacy creato: ' + placeholderId + ' → ' + sizes.join(','));
        }
      } catch (error) {
        console.error('[AdHub GAM] ❌ Errore creazione slot legacy: ' + placeholderId, error);
      }
    });

    return createdSlots;
  }

  /**
   * Parse dimensioni legacy e le converte in array sizes per GAM
   * @param {string} dimensions - Formato "728x90" o "300x250"
   * @returns {Array} Array di sizes es: [[728, 90]] o [[300, 250]]
   */
  function parseLegacyDimensions(dimensions) {
    if (!dimensions) return [];

    // Parse formato "WIDTHxHEIGHT"
    const match = dimensions.match(/(\d+)x(\d+)/i);
    if (!match) return [];

    const width = parseInt(match[1], 10);
    const height = parseInt(match[2], 10);

    // Valida dimensioni
    if (width <= 0 || height <= 0) return [];

    // Per native (1x1), aggiungi anche sizes fluidi
    if (width === 1 && height === 1) {
      return [[1, 1], 'fluid'];
    }

    // Aggiungi size principale + varianti responsive comuni
    const sizes = [[width, height]];

    // Aggiungi varianti responsive basate su dimensione principale
    if (width === 728 && height === 90) {
      // Leaderboard: aggiungi mobile alternatives
      sizes.push([320, 50], [320, 100]);
    } else if (width === 970 && height === 250) {
      // Billboard: aggiungi alternatives
      sizes.push([728, 90], [320, 100]);
    } else if (width === 300 && height === 250) {
      // Medium Rectangle: formato base, no alternatives
    } else if (width === 160 && height === 600) {
      // Wide Skyscraper: aggiungi alternative più piccola
      sizes.push([120, 600]);
    }

    return sizes;
  }

  /**
   * Estrae targeting dai data attributes del placeholder legacy
   * @param {HTMLElement} div - Elemento placeholder
   * @returns {Object} Oggetto targeting key-values
   */
  function extractLegacyTargeting(div) {
    const targeting = {};

    // Estrai tutti gli attributi data-targeting-*
    Array.from(div.attributes).forEach(function(attr) {
      if (attr.name.startsWith('data-targeting-')) {
        const key = attr.name.replace('data-targeting-', '');
        targeting[key] = attr.value;
      }
    });

    // Aggiungi metadata legacy
    targeting['legacy_sdk'] = 'true';
    targeting['legacy_type'] = div.getAttribute('data-legacy-type') || 'display';

    return targeting;
  }

  /**
   * Configura pubads (Publisher Ads Service)
   */
  function configurePubads() {
    const pubads = googletag.pubads();

    // Opzioni globali
    if (CONFIG.options.enableSingleRequest) {
      pubads.enableSingleRequest();
      console.log('[AdHub GAM] ✅ Single Request abilitato');
    }

    if (CONFIG.options.collapseEmptyDivs) {
      pubads.collapseEmptyDivs();
      console.log('[AdHub GAM] ✅ Collapse Empty Divs abilitato');
    }

    if (CONFIG.options.centering) {
      pubads.setCentering(true);
    }

    if (CONFIG.options.disableInitialLoad) {
      pubads.disableInitialLoad();
      console.log('[AdHub GAM] ✅ Initial Load disabilitato (aspetta Prebid)');
    }

    // Lazy Load per slot sotto fold
    if (CONFIG.options.enableLazyLoad) {
      const lazyConfig = CONFIG.options.enableLazyLoad;
      pubads.enableLazyLoad({
        fetchMarginPercent: lazyConfig.fetchMarginPercent || 200,
        renderMarginPercent: lazyConfig.renderMarginPercent || 100,
        mobileScaling: lazyConfig.mobileScaling || 2.0
      });
      console.log('[AdHub GAM] ✅ Lazy Load abilitato (fetch: ' +
        (lazyConfig.fetchMarginPercent || 200) + '%, render: ' +
        (lazyConfig.renderMarginPercent || 100) + '%)');
    }

    // Targeting globale
    pubads.setTargeting('site', CONFIG.sitePrefix);

    // Device targeting
    const device = window.innerWidth >= 1024 ? 'desktop' :
                   window.innerWidth >= 768 ? 'tablet' : 'mobile';
    pubads.setTargeting('platform', device);

    // Domain targeting - traccia il dominio dove viene erogata l'adv
    const currentDomain = window.location.hostname;
    pubads.setTargeting('domain', currentDomain);

    console.log('[AdHub GAM] 🎯 Targeting globale impostato (site: ' +
      CONFIG.sitePrefix + ', platform: ' + device + ', domain: ' + currentDomain + ')');
  }

  /**
   * Helper per verificare se uno slot è gestito da AdHub
   */
  function isAdHubSlot(slotId) {
    return state.managedSlots.has(slotId);
  }

  /**
   * Abilita servizi GAM con event listener filtrati
   */
  function enableServices() {
    // Event listener per slot render - FILTRATO per slot AdHub
    googletag.pubads().addEventListener('slotRenderEnded', function(event) {
      const slotId = event.slot.getSlotElementId();
      const adUnitPath = event.slot.getAdUnitPath();

      // BLOCCO: Rimuovi slot AdSense non autorizzati
      if (adUnitPath && adUnitPath.indexOf('ca-video-pub') !== -1) {
        if (!isAdHubSlot(slotId)) {
          console.warn('[AdHub GAM] 🚫 BLOCCATO render slot AdSense non autorizzato:', adUnitPath, 'ID:', slotId);

          // Rimuovi il div e il contenuto renderizzato
          var divElement = document.getElementById(slotId);
          if (divElement) {
            // Nascondi immediatamente
            divElement.style.display = 'none';
            divElement.style.visibility = 'hidden';
            divElement.style.position = 'absolute';
            divElement.style.left = '-9999px';

            // Rimuovi dopo un breve delay per evitare race condition
            setTimeout(function() {
              if (divElement.parentNode) {
                divElement.parentNode.removeChild(divElement);
                console.log('[AdHub GAM] 🗑️ Rimosso div AdSense non autorizzato:', slotId);
              }
            }, 100);
          }

          return; // Non processare ulteriormente
        }
      }

      // FILTRO: processa solo slot gestiti da AdHub
      if (!isAdHubSlot(slotId)) {
        return; // Ignora slot di altre concessionarie
      }

      // Update tracking
      if (state.slotTracking[slotId]) {
        state.slotTracking[slotId].rendered = true;
        state.slotTracking[slotId].empty = event.isEmpty;
        state.slotTracking[slotId].renderCount++;
        state.slotTracking[slotId].lastRefresh = Date.now();
      }

      if (event.isEmpty) {
        console.warn('[AdHub GAM] ⚠️ Slot vuoto:', slotId, '- Nessun ad disponibile');
      } else {
        console.log('[AdHub GAM] ✅ Slot renderizzato:', slotId,
          '(' + event.size[0] + 'x' + event.size[1] + ')',
          'Creative ID:', event.creativeId,
          'Line Item ID:', event.lineItemId,
          'Render #' + state.slotTracking[slotId].renderCount);
      }
    });

    // Event listener per impression viewable - FILTRATO
    googletag.pubads().addEventListener('impressionViewable', function(event) {
      const slotId = event.slot.getSlotElementId();

      // FILTRO: processa solo slot gestiti da AdHub
      if (!isAdHubSlot(slotId)) {
        return;
      }

      // Update tracking
      if (state.slotTracking[slotId]) {
        state.slotTracking[slotId].viewable = true;
      }

      console.log('[AdHub GAM] 👁️ Impression viewable:', slotId);
    });

    // Event listener per slot requested - FILTRATO
    googletag.pubads().addEventListener('slotRequested', function(event) {
      const slotId = event.slot.getSlotElementId();

      // FILTRO: processa solo slot gestiti da AdHub
      if (!isAdHubSlot(slotId)) {
        return;
      }

      // Update tracking
      if (state.slotTracking[slotId]) {
        state.slotTracking[slotId].requested = true;
      }

      console.log('[AdHub GAM] 📡 Slot richiesto a GAM:', slotId);
    });

    // Event listener per slot loaded - FILTRATO
    googletag.pubads().addEventListener('slotOnload', function(event) {
      const slotId = event.slot.getSlotElementId();

      // FILTRO: processa solo slot gestiti da AdHub
      if (!isAdHubSlot(slotId)) {
        return;
      }

      console.log('[AdHub GAM] 📦 Slot caricato:', slotId);
    });

    // Event listener per bloccare slot AdSense non autorizzati (es. sticky bottom injection)
    googletag.pubads().addEventListener('slotRequested', function(event) {
      const slot = event.slot;
      const slotId = slot.getSlotElementId();
      const adUnitPath = slot.getAdUnitPath();

      // Blocca slot AdSense che non sono gestiti da AdHub
      if (adUnitPath && adUnitPath.indexOf('ca-video-pub') !== -1) {
        // Verifica se è uno slot AdHub autorizzato
        if (!isAdHubSlot(slotId)) {
          console.warn('[AdHub GAM] 🚫 BLOCCATO slot AdSense non autorizzato:', adUnitPath, 'ID:', slotId);

          // Rimuovi il div iniettato da AdSense
          var divElement = document.getElementById(slotId);
          if (divElement && divElement.parentNode) {
            divElement.parentNode.removeChild(divElement);
            console.log('[AdHub GAM] 🗑️ Rimosso div AdSense non autorizzato:', slotId);
          }
        }
      }
    });

    googletag.enableServices();
    console.log('[AdHub GAM] ✅ GAM Services abilitati (event listener filtrati per slot AdHub)');

    // Se disableInitialLoad è attivo, chiama display() per ogni slot DOPO enableServices
    // Questo "registra" gli slot con GAM prima dell'auction Prebid
    if (CONFIG.options.disableInitialLoad) {
      state.definedSlots.forEach(function(slotObj) {
        googletag.display(slotObj.code);
      });
      console.log('[AdHub GAM] 📺 Display() chiamato per ' + state.definedSlots.length + ' slot (pre-auction)');
    }
  }

  /**
   * Lancia auction Prebid e refresh slot GAM
   */
  function requestAds(specificSlots) {
    if (!state.initialized) {
      console.error('[AdHub GAM] Sistema non inizializzato. Chiama init() prima.');
      return;
    }

    if (!state.slotsCreated || state.definedSlots.length === 0) {
      console.warn('[AdHub GAM] ⚠️ Nessuno slot definito nel DOM');
      return;
    }

    // Determina quali ad units richiedere
    let adUnitCodes;

    if (specificSlots) {
      // Slot specifici richiesti
      adUnitCodes = Array.isArray(specificSlots) ? specificSlots : [specificSlots];
    } else {
      // Tutti gli slot presenti nel DOM
      adUnitCodes = state.definedSlots.map(function(s) { return s.code; });
    }

    // Verifica che gli slot esistano ancora nel DOM
    adUnitCodes = adUnitCodes.filter(function(code) {
      return !!document.getElementById(code);
    });

    if (adUnitCodes.length === 0) {
      console.warn('[AdHub GAM] ⚠️ Nessun div ad unit valido trovato');
      return;
    }

    console.log('[AdHub GAM] 📋 Ad units da richiedere:', adUnitCodes);

    // Verifica se ci sono ad units Prebid configurati
    pbjs.que.push(function() {
      const prebidAdUnits = pbjs.adUnits || [];

      // Verifica se ci sono ad units con bidders configurati
      const adUnitsWithBids = prebidAdUnits.filter(function(unit) {
        return unit.bids && unit.bids.length > 0;
      });

      const hasPrebidConfig = adUnitsWithBids.length > 0;

      if (!hasPrebidConfig) {
        // Nessun Prebid configurato o nessun bidder attivo - vai diretto a GAM
        console.log('[AdHub GAM] ⚡ Skip Prebid (no bidders) - Richiesta diretta a GAM');

        googletag.cmd.push(function() {
          if (specificSlots) {
            // Refresh solo slot specifici
            const slotsToRefresh = googletag.pubads().getSlots().filter(function(slot) {
              return adUnitCodes.indexOf(slot.getSlotElementId()) !== -1;
            });

            if (slotsToRefresh.length > 0) {
              googletag.pubads().refresh(slotsToRefresh);
              console.log('[AdHub GAM] 🔄 Refresh slot specifici:', slotsToRefresh.length);
            }
          } else {
            // Refresh tutti gli slot
            googletag.pubads().refresh();
            console.log('[AdHub GAM] 🔄 Refresh tutti gli slot');
          }
        });
        return;
      }

      // Prebid configurato - lancia auction
      console.log('[AdHub GAM] 🎯 Richiesta ads con Prebid (' + prebidAdUnits.length + ' ad units)...');

      pbjs.requestBids({
        timeout: CONFIG.auctionTimeout,
        adUnitCodes: adUnitCodes,
        bidsBackHandler: function(bids) {
          console.log('[AdHub GAM] 💰 Bids ricevuti:', Object.keys(bids).length);

          // Set targeting Prebid su GAM
          pbjs.setTargetingForGPTAsync(adUnitCodes);
          console.log('[AdHub GAM] 🎯 Targeting Prebid impostato su GAM');

          // Refresh slot GAM con targeting Prebid
          googletag.cmd.push(function() {
            // Con disableInitialLoad, gli slot sono già stati "displayati"
            // Ora usiamo refresh() per caricare le ads con i bid Prebid
            if (specificSlots) {
              // Refresh solo slot specifici
              const slotsToRefresh = googletag.pubads().getSlots().filter(function(slot) {
                return adUnitCodes.indexOf(slot.getSlotElementId()) !== -1;
              });

              if (slotsToRefresh.length > 0) {
                googletag.pubads().refresh(slotsToRefresh);
                console.log('[AdHub GAM] 🔄 Refresh slot specifici:', slotsToRefresh.length);
              }
            } else {
              // Refresh tutti gli slot
              googletag.pubads().refresh();
              console.log('[AdHub GAM] 🔄 Refresh ' + adUnitCodes.length + ' slot con targeting Prebid');
            }

            state.adsRequested = true;
          });
        }
      });
    });
  }

  /**
   * Refresh manuale di specifici slot
   */
  function refreshSlots(slotCodes) {
    if (!state.initialized) {
      console.error('[AdHub GAM] Sistema non inizializzato');
      return;
    }

    if (!Array.isArray(slotCodes)) {
      slotCodes = [slotCodes];
    }

    console.log('[AdHub GAM] 🔄 Refresh manuale slot:', slotCodes);
    requestAds(slotCodes);
  }

  /**
   * Distrugge tutti gli slot (per SPA navigation)
   */
  function destroySlots() {
    if (!state.initialized) return;

    googletag.cmd.push(function() {
      googletag.destroySlots();
      state.slotsCreated = false;
      state.definedSlots = [];
      state.managedSlots.clear();
      state.slotTracking = {};
      console.log('[AdHub GAM] 🗑️ Slot distrutti');
    });
  }

  /**
   * Display di uno slot specifico
   */
  function displaySlot(slotCode) {
    if (!state.initialized) {
      console.error('[AdHub GAM] Sistema non inizializzato');
      return;
    }

    googletag.cmd.push(function() {
      googletag.display(slotCode);
      console.log('[AdHub GAM] 📺 Display slot:', slotCode);
    });
  }

  /**
   * Auto-init quando consenso pronto
   */
  function setupAutoInit() {
    if (!CONFIG.autoInit) {
      console.log('[AdHub GAM] Auto-init disabilitato');
      return;
    }

    // Se c'è il sistema di consenso, aspetta
    if (window.AdHubCMP) {
      console.log('[AdHub GAM] Attesa consenso per init GAM...');

      window.addEventListener('adhub:consent:ready', function(event) {
        if (event.detail && event.detail.consentGiven) {
          console.log('[AdHub GAM] Consenso ricevuto - Init GAM');

          // Init GAM
          initializeGAM();

          // Aspetta che Prebid sia configurato
          setTimeout(function() {
            if (pbjs.adUnits && pbjs.adUnits.length > 0) {
              requestAds();
            } else {
              console.warn('[AdHub GAM] ⚠️ Prebid ad units non ancora configurati');
              console.warn('[AdHub GAM] Chiama manualmente AdHubGAM.requestAds() quando pronto');
            }
          }, 500);
        }
      });

      // Gestisci anche il caso senza CMP (strict mode OFF)
      window.addEventListener('adhub:consent:nocmp', function() {
        const cmpConfig = window.AdHubCMP.getConfig();
        if (!cmpConfig.STRICT_MODE) {
          console.log('[AdHub GAM] Nessuna CMP - Init GAM (strict mode disabled)');
          initializeGAM();
          setTimeout(function() {
            requestAds();
          }, 500);
        }
      });

    } else {
      // Nessun sistema di consenso - init diretta
      console.log('[AdHub GAM] Init GAM senza sistema consenso');

      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', function() {
          initializeGAM();
          setTimeout(requestAds, 500);
        });
      } else {
        initializeGAM();
        setTimeout(requestAds, 500);
      }
    }
  }

  /**
   * API Pubblica
   */
  window.AdHubGAM = {
    // Config
    config: CONFIG,

    // Stato
    getState: function() {
      return {
        initialized: state.initialized,
        slotsCreated: state.slotsCreated,
        adsRequested: state.adsRequested,
        slotsCount: state.definedSlots.length,
        slots: state.definedSlots.map(function(s) {
          return {
            code: s.code,
            sizes: s.config.sizes,
            targeting: s.config.targeting
          };
        })
      };
    },

    // Metodi principali
    init: initializeGAM,
    requestAds: requestAds,
    refreshSlots: refreshSlots,
    displaySlot: displaySlot,
    destroySlots: destroySlots,

    // Check inizializzazione
    isInitialized: function() {
      return state.initialized;
    },

    // Refresh tutti gli slot
    refreshAllSlots: function() {
      if (!state.initialized || state.definedSlots.length === 0) {
        console.warn('[AdHub GAM] Cannot refresh - sistema non inizializzato o nessuno slot definito');
        return;
      }
      console.log('[AdHub GAM] 🔄 Refresh di tutti gli slot...');
      var slotCodes = state.definedSlots.map(function(s) { return s.code; });
      refreshSlots(slotCodes);
    },

    // Utility
    getSlotCodes: function() {
      return CONFIG.slots.map(function(s) { return s.code; });
    },

    getSlotByCode: function(code) {
      return CONFIG.slots.find(function(s) { return s.code === code; });
    },

    getDefinedSlots: function() {
      return state.definedSlots;
    },

    // Tracking dettagliato per slot
    getSlotTracking: function(slotCode) {
      if (slotCode) {
        return state.slotTracking[slotCode] || null;
      }
      // Ritorna tutto il tracking se non specificato un slot
      return state.slotTracking;
    },

    // Verifica se uno slot è gestito da AdHub
    isAdHubSlot: function(slotCode) {
      return state.managedSlots.has(slotCode);
    },

    // Statistiche aggregate
    getStats: function() {
      const slots = Object.keys(state.slotTracking);
      const stats = {
        totalSlots: slots.length,
        requested: 0,
        rendered: 0,
        viewable: 0,
        empty: 0,
        totalRenders: 0
      };

      slots.forEach(function(slotCode) {
        const tracking = state.slotTracking[slotCode];
        if (tracking.requested) stats.requested++;
        if (tracking.rendered) stats.rendered++;
        if (tracking.viewable) stats.viewable++;
        if (tracking.empty) stats.empty++;
        stats.totalRenders += tracking.renderCount;
      });

      return stats;
    },

    // Override config (deve essere chiamato PRIMA del caricamento)
    setConfig: function(customConfig) {
      if (state.initialized) {
        console.error('[AdHub GAM] Impossibile cambiare config dopo inizializzazione');
        return false;
      }
      Object.assign(CONFIG, mergeConfig(customConfig));
      console.log('[AdHub GAM] Config aggiornata');
      return true;
    }
  };

  // Avvia auto-init se abilitato
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', setupAutoInit);
  } else {
    setupAutoInit();
  }

  console.log('[AdHub GAM] ✅ Modulo caricato (v1.0.0)');
  console.log('[AdHub GAM] 📊 Slot configurati:', CONFIG.slots.length);
  console.log('[AdHub GAM] 🎯 Auto-init:', CONFIG.autoInit ? 'ON' : 'OFF');

})();

// From: adhub-analytics.js
/**
 * AdHub Analytics Module
 *
 * Traccia eventi Prebid.js verso Google Analytics 4
 * per monitorare performance bidder, CPM, timeout, fill rate.
 *
 * @version 1.0.0
 * @date 2025-10-31
 */

(function() {
  'use strict';

  if (window.AdHubAnalytics) {
    console.warn('[AdHub Analytics] Modulo già caricato');
    return;
  }

  // ============================================================================
  // CONFIGURATION
  // ============================================================================

  const DEFAULT_CONFIG = {
    // Abilita/disabilita tracking
    enabled: true,

    // Send to Google Analytics 4
    ga4Enabled: true,

    // Send to custom endpoint (opzionale)
    customEndpoint: null,

    // Sampling rate (1.0 = 100%, 0.1 = 10%)
    samplingRate: 1.0,

    // Eventi da tracciare
    events: {
      bidWon: true,
      bidTimeout: true,
      auctionEnd: true,
      bidResponse: false,  // Verbose, disabilita per default
      adRenderFailed: true,
      adRenderSucceeded: false  // Verbose
    },

    // Debug
    debug: false
  };

  // ============================================================================
  // STATE
  // ============================================================================

  const state = {
    config: {...DEFAULT_CONFIG},
    initialized: false,
    stats: {
      totalAuctions: 0,
      totalBids: 0,
      totalWins: 0,
      totalTimeouts: 0,
      totalRevenue: 0
    },
    // Video Playlist Stats
    videoPlaylistStats: {
      totalAdRequests: 0,
      totalAdStarts: 0,
      totalAdCompletes: 0,
      totalAdErrors: 0,
      totalAdSkips: 0,
      totalVideoViews: 0,
      totalPlaylistCreated: 0,
      totalPlaylistClosed: 0,
      videoAdRevenue: 0
    },
    sessionId: generateSessionId()
  };

  // ============================================================================
  // UTILITY
  // ============================================================================

  function generateSessionId() {
    return 'adhub_' + Date.now() + '_' + Math.random().toString(36).substr(2, 9);
  }

  function log(...args) {
    if (state.config.debug) {
      console.log('[AdHub Analytics]', ...args);
    }
  }

  function shouldSample() {
    return Math.random() < state.config.samplingRate;
  }

  // ============================================================================
  // GOOGLE ANALYTICS 4 TRACKING
  // ============================================================================

  function sendToGA4(eventName, eventParams) {
    if (!state.config.ga4Enabled) return;
    if (!window.gtag) {
      log('⚠️ gtag non trovato - GA4 non disponibile');
      return;
    }

    try {
      gtag('event', eventName, eventParams);
      log('✅ GA4 event:', eventName, eventParams);
    } catch (e) {
      log('❌ Errore invio GA4:', e);
    }
  }

  // ============================================================================
  // CUSTOM ENDPOINT TRACKING
  // ============================================================================

  function sendToCustomEndpoint(eventData) {
    if (!state.config.customEndpoint) return;

    try {
      // Usa sendBeacon se disponibile (non blocca page unload)
      if (navigator.sendBeacon) {
        navigator.sendBeacon(
          state.config.customEndpoint,
          JSON.stringify(eventData)
        );
      } else {
        // Fallback: fetch con keepalive
        fetch(state.config.customEndpoint, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(eventData),
          keepalive: true
        });
      }
      log('✅ Custom endpoint:', eventData);
    } catch (e) {
      log('❌ Errore custom endpoint:', e);
    }
  }

  // ============================================================================
  // PREBID EVENT HANDLERS
  // ============================================================================

  /**
   * Bid Won - Un bidder ha vinto l'auction
   */
  function onBidWon(bid) {
    if (!state.config.events.bidWon) return;
    if (!shouldSample()) return;

    state.stats.totalWins++;
    state.stats.totalRevenue += bid.cpm || 0;

    // Dati da tracciare
    const eventData = {
      event: 'prebid_bid_won',
      event_category: 'prebid',
      event_label: bid.bidder,
      value: Math.round((bid.cpm || 0) * 100), // CPM in centesimi per GA4

      // Dimensioni custom
      bidder: bid.bidder,
      ad_unit: bid.adUnitCode,
      size: bid.size || (bid.width + 'x' + bid.height),
      cpm: parseFloat((bid.cpm || 0).toFixed(4)),
      currency: bid.currency || 'EUR',
      latency: bid.timeToRespond || 0,
      deal_id: bid.dealId || null,

      // Session tracking
      session_id: state.sessionId,
      timestamp: Date.now()
    };

    // Send to GA4
    sendToGA4('prebid_bid_won', eventData);

    // Send to custom endpoint
    sendToCustomEndpoint(eventData);

    log('🏆 Bid Won:', bid.bidder, '€' + bid.cpm, bid.adUnitCode);
  }

  /**
   * Bid Timeout - Bidder non ha risposto in tempo
   */
  function onBidTimeout(timeoutData) {
    if (!state.config.events.bidTimeout) return;
    if (!shouldSample()) return;

    state.stats.totalTimeouts += timeoutData.length;

    timeoutData.forEach(function(bid) {
      const eventData = {
        event: 'prebid_timeout',
        event_category: 'prebid',
        event_label: bid.bidder,

        bidder: bid.bidder,
        ad_unit: bid.adUnitCode,
        timeout: bid.timeout || 0,

        session_id: state.sessionId,
        timestamp: Date.now()
      };

      // Send to GA4
      sendToGA4('prebid_timeout', eventData);

      // Send to custom endpoint
      sendToCustomEndpoint(eventData);

      log('⏱️ Timeout:', bid.bidder, bid.adUnitCode);
    });
  }

  /**
   * Auction End - Auction completata
   */
  function onAuctionEnd(auctionData) {
    if (!state.config.events.auctionEnd) return;
    if (!shouldSample()) return;

    state.stats.totalAuctions++;
    state.stats.totalBids += auctionData.bidsReceived.length;

    // Calcola statistiche auction
    const bidsReceived = auctionData.bidsReceived || [];
    const noBids = auctionData.noBids || [];
    const totalBidders = bidsReceived.length + noBids.length;
    const fillRate = totalBidders > 0 ? (bidsReceived.length / totalBidders * 100).toFixed(2) : 0;

    const avgCpm = bidsReceived.length > 0
      ? (bidsReceived.reduce(function(sum, bid) { return sum + (bid.cpm || 0); }, 0) / bidsReceived.length).toFixed(4)
      : 0;

    const eventData = {
      event: 'prebid_auction_end',
      event_category: 'prebid',
      event_label: auctionData.auctionId,

      auction_id: auctionData.auctionId,
      bids_received: bidsReceived.length,
      no_bids: noBids.length,
      total_bidders: totalBidders,
      fill_rate: parseFloat(fillRate),
      avg_cpm: parseFloat(avgCpm),
      auction_duration: (auctionData.auctionEnd - auctionData.auctionStart) || 0,

      session_id: state.sessionId,
      timestamp: Date.now()
    };

    // Send to GA4
    sendToGA4('prebid_auction_end', eventData);

    // Send to custom endpoint
    sendToCustomEndpoint(eventData);

    log('🔚 Auction End:', eventData.bids_received, 'bids,', fillRate + '% fill rate');
  }

  /**
   * Bid Response - Bidder ha risposto (verbose)
   */
  function onBidResponse(bid) {
    if (!state.config.events.bidResponse) return;
    if (!shouldSample()) return;

    const eventData = {
      event: 'prebid_bid_response',
      event_category: 'prebid',
      event_label: bid.bidder,

      bidder: bid.bidder,
      ad_unit: bid.adUnitCode,
      cpm: parseFloat((bid.cpm || 0).toFixed(4)),
      currency: bid.currency || 'EUR',
      latency: bid.timeToRespond || 0,

      session_id: state.sessionId,
      timestamp: Date.now()
    };

    sendToGA4('prebid_bid_response', eventData);
    sendToCustomEndpoint(eventData);
  }

  /**
   * Ad Render Failed - Errore rendering annuncio
   */
  function onAdRenderFailed(data) {
    if (!state.config.events.adRenderFailed) return;

    const eventData = {
      event: 'ad_render_failed',
      event_category: 'ads',
      event_label: data.reason || 'unknown',

      ad_unit: data.adUnitCode,
      reason: data.reason || 'unknown',
      message: data.message || '',

      session_id: state.sessionId,
      timestamp: Date.now()
    };

    sendToGA4('ad_render_failed', eventData);
    sendToCustomEndpoint(eventData);

    log('❌ Ad Render Failed:', data.adUnitCode, data.reason);
  }

  // ============================================================================
  // PREBID EVENT REGISTRATION
  // ============================================================================

  function registerPrebidEvents() {
    if (typeof pbjs === 'undefined') {
      log('⚠️ Prebid.js non ancora caricato - retry tra 1s');
      setTimeout(registerPrebidEvents, 1000);
      return;
    }

    // Register event listeners
    pbjs.onEvent('bidWon', onBidWon);
    pbjs.onEvent('bidTimeout', onBidTimeout);
    pbjs.onEvent('auctionEnd', onAuctionEnd);
    pbjs.onEvent('bidResponse', onBidResponse);

    // Google Publisher Tag events
    if (window.googletag && googletag.pubads) {
      googletag.cmd.push(function() {
        googletag.pubads().addEventListener('slotRenderEnded', function(event) {
          if (event.isEmpty) {
            log('📭 Slot vuoto:', event.slot.getSlotElementId());
          }
        });
      });
    }

    log('✅ Prebid events registrati');
  }

  // ============================================================================
  // VIDEO PLAYLIST TRACKING
  // ============================================================================

  /**
   * Track generic custom event
   *
   * @param {string} eventName - Nome evento
   * @param {object} eventData - Dati evento
   */
  function trackEvent(eventName, eventData) {
    if (!state.config.enabled) return;
    if (!shouldSample()) return;

    eventData = eventData || {};

    // Update video playlist stats se evento playlist
    updateVideoPlaylistStats(eventName, eventData);

    const fullEventData = {
      event: eventName,
      event_category: eventData.category || 'custom',
      event_label: eventData.label || '',
      value: eventData.value || 0,

      // Aggiungi tutti i dati custom
      ...eventData,

      // Session tracking
      session_id: state.sessionId,
      timestamp: Date.now()
    };

    // Send to GA4
    sendToGA4(eventName, fullEventData);

    // Send to custom endpoint
    sendToCustomEndpoint(fullEventData);

    log('📊 Custom Event:', eventName, eventData);
  }

  /**
   * Update video playlist stats based on event
   */
  function updateVideoPlaylistStats(eventName, eventData) {
    const stats = state.videoPlaylistStats;

    switch(eventName) {
      case 'video_playlist_ad_request':
        stats.totalAdRequests++;
        break;
      case 'video_playlist_ad_start':
        stats.totalAdStarts++;
        break;
      case 'video_playlist_ad_complete':
        stats.totalAdCompletes++;
        break;
      case 'video_playlist_ad_error':
        stats.totalAdErrors++;
        break;
      case 'video_playlist_ad_skipped':
        stats.totalAdSkips++;
        break;
      case 'video_playlist_video_view':
        stats.totalVideoViews++;
        break;
      case 'video_playlist_created':
        stats.totalPlaylistCreated++;
        break;
      case 'video_playlist_closed':
        stats.totalPlaylistClosed++;
        break;
    }
  }

  /**
   * Track bid (per video playlist o display ads)
   *
   * @param {object} bidData - Dati bid
   */
  function trackBid(bidData) {
    if (!state.config.enabled) return;
    if (!shouldSample()) return;

    const cpm = bidData.cpm || 0;

    // Aggiorna stats se bid vinto
    if (bidData.status === 'won') {
      state.stats.totalWins++;
      state.stats.totalRevenue += cpm;

      // Track video ad revenue separatamente
      if (bidData.mediaType === 'video') {
        state.videoPlaylistStats.videoAdRevenue += cpm;
      }
    }

    const eventData = {
      event: 'custom_bid_' + (bidData.status || 'unknown'),
      event_category: bidData.mediaType || 'display',
      event_label: bidData.bidder || 'unknown',
      value: Math.round(cpm * 100), // CPM in centesimi per GA4

      // Bid details
      ad_unit: bidData.adUnitCode || '',
      bidder: bidData.bidder || 'unknown',
      cpm: parseFloat(cpm.toFixed(4)),
      currency: bidData.currency || 'EUR',
      size: bidData.size || '',
      media_type: bidData.mediaType || 'display',
      status: bidData.status || 'unknown',

      // Video specific
      vast_url: bidData.vastUrl ? 'present' : 'none',

      // Session tracking
      session_id: state.sessionId,
      timestamp: Date.now()
    };

    // Send to GA4
    sendToGA4('custom_bid_' + (bidData.status || 'unknown'), eventData);

    // Send to custom endpoint
    sendToCustomEndpoint(eventData);

    log('💰 Bid Tracked:', bidData.bidder, '€' + cpm, bidData.status);
  }

  // ============================================================================
  // PUBLIC API
  // ============================================================================

  function init(config) {
    if (state.initialized) {
      log('Già inizializzato');
      return;
    }

    // Merge config
    if (config) {
      Object.assign(state.config, config);
    }

    // Debug da URL
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('debug') === 'analytics') {
      state.config.debug = true;
    }

    // Verifica GA4
    if (state.config.ga4Enabled && !window.gtag) {
      console.warn('[AdHub Analytics] ⚠️ Google Analytics 4 non trovato - disabilito GA4 tracking');
      state.config.ga4Enabled = false;
    }

    // Register Prebid events
    registerPrebidEvents();

    state.initialized = true;
    log('✅ Modulo Analytics inizializzato', state.config);
  }

  function getStats() {
    const stats = {...state.stats};

    // Calcola metriche derivate
    if (stats.totalAuctions > 0) {
      stats.avgBidsPerAuction = (stats.totalBids / stats.totalAuctions).toFixed(2);
      stats.winRate = ((stats.totalWins / stats.totalBids) * 100).toFixed(2) + '%';
    }

    if (stats.totalWins > 0) {
      stats.avgRevenuePerWin = (stats.totalRevenue / stats.totalWins).toFixed(4);
    }

    return stats;
  }

  function getVideoPlaylistStats() {
    const stats = {...state.videoPlaylistStats};

    // Calcola metriche derivate
    if (stats.totalAdRequests > 0) {
      stats.adFillRate = ((stats.totalAdStarts / stats.totalAdRequests) * 100).toFixed(2) + '%';
    }

    if (stats.totalAdStarts > 0) {
      stats.completionRate = ((stats.totalAdCompletes / stats.totalAdStarts) * 100).toFixed(2) + '%';
      stats.errorRate = ((stats.totalAdErrors / stats.totalAdStarts) * 100).toFixed(2) + '%';
      stats.skipRate = ((stats.totalAdSkips / stats.totalAdStarts) * 100).toFixed(2) + '%';
      stats.avgRevenuePerAd = (stats.videoAdRevenue / stats.totalAdStarts).toFixed(4);
    }

    if (stats.totalVideoViews > 0) {
      stats.adsPerVideo = (stats.totalAdStarts / stats.totalVideoViews).toFixed(2);
    }

    return stats;
  }

  function getAllStats() {
    return {
      display: getStats(),
      videoPlaylist: getVideoPlaylistStats(),
      session: {
        sessionId: state.sessionId,
        config: state.config
      }
    };
  }

  function resetStats() {
    state.stats = {
      totalAuctions: 0,
      totalBids: 0,
      totalWins: 0,
      totalTimeouts: 0,
      totalRevenue: 0
    };

    state.videoPlaylistStats = {
      totalAdRequests: 0,
      totalAdStarts: 0,
      totalAdCompletes: 0,
      totalAdErrors: 0,
      totalAdSkips: 0,
      totalVideoViews: 0,
      totalPlaylistCreated: 0,
      totalPlaylistClosed: 0,
      videoAdRevenue: 0
    };

    log('📊 All stats reset');
  }

  /**
   * Print analytics dashboard to console
   */
  function printDashboard() {
    console.log('\n');
    console.log('╔═══════════════════════════════════════════════════════════════╗');
    console.log('║         📊 AdHub Analytics Dashboard                         ║');
    console.log('╚═══════════════════════════════════════════════════════════════╝');

    // Display Ads Stats
    const displayStats = getStats();
    console.log('\n📺 DISPLAY ADS');
    console.log('─────────────────────────────────────────────────────────────');
    console.log('  Total Auctions:     ', displayStats.totalAuctions);
    console.log('  Total Bids:         ', displayStats.totalBids);
    console.log('  Total Wins:         ', displayStats.totalWins);
    console.log('  Win Rate:           ', displayStats.winRate || 'N/A');
    console.log('  Total Revenue:      ', '€' + displayStats.totalRevenue.toFixed(4));
    console.log('  Avg Revenue/Win:    ', displayStats.avgRevenuePerWin ? '€' + displayStats.avgRevenuePerWin : 'N/A');
    console.log('  Timeouts:           ', displayStats.totalTimeouts);

    // Video Playlist Stats
    const videoStats = getVideoPlaylistStats();
    console.log('\n🎬 VIDEO PLAYLIST ADS');
    console.log('─────────────────────────────────────────────────────────────');
    console.log('  Playlists Created:  ', videoStats.totalPlaylistCreated);
    console.log('  Playlists Closed:   ', videoStats.totalPlaylistClosed);
    console.log('  Content Videos:     ', videoStats.totalVideoViews);
    console.log('  ');
    console.log('  Ad Requests:        ', videoStats.totalAdRequests);
    console.log('  Ad Starts:          ', videoStats.totalAdStarts);
    console.log('  Ad Completes:       ', videoStats.totalAdCompletes);
    console.log('  Ad Errors:          ', videoStats.totalAdErrors);
    console.log('  Ad Skips:           ', videoStats.totalAdSkips);
    console.log('  ');
    console.log('  Fill Rate:          ', videoStats.adFillRate || 'N/A');
    console.log('  Completion Rate:    ', videoStats.completionRate || 'N/A');
    console.log('  Error Rate:         ', videoStats.errorRate || 'N/A');
    console.log('  Skip Rate:          ', videoStats.skipRate || 'N/A');
    console.log('  ');
    console.log('  Video Ad Revenue:   ', '€' + videoStats.videoAdRevenue.toFixed(4));
    console.log('  Avg Revenue/Ad:     ', videoStats.avgRevenuePerAd ? '€' + videoStats.avgRevenuePerAd : 'N/A');
    console.log('  Ads per Video:      ', videoStats.adsPerVideo || 'N/A');

    // Total Revenue
    const totalRevenue = displayStats.totalRevenue + videoStats.videoAdRevenue;
    console.log('\n💰 TOTAL REVENUE');
    console.log('─────────────────────────────────────────────────────────────');
    console.log('  Display:            ', '€' + displayStats.totalRevenue.toFixed(4));
    console.log('  Video Playlist:     ', '€' + videoStats.videoAdRevenue.toFixed(4));
    console.log('  ────────────────────────────────────────────────────────');
    console.log('  TOTAL:              ', '€' + totalRevenue.toFixed(4));

    console.log('\n═════════════════════════════════════════════════════════════');
    console.log('Session ID:', state.sessionId);
    console.log('═════════════════════════════════════════════════════════════\n');
  }

  // Export
  window.AdHubAnalytics = {
    // Init & Config
    init: init,
    getConfig: function() { return {...state.config}; },
    setConfig: function(config) { Object.assign(state.config, config); },
    getSessionId: function() { return state.sessionId; },

    // Stats
    getStats: getStats,
    getVideoPlaylistStats: getVideoPlaylistStats,
    getAllStats: getAllStats,
    resetStats: resetStats,

    // Dashboard
    printDashboard: printDashboard,
    dashboard: printDashboard, // Alias

    // Custom Tracking (per video playlists e custom events)
    trackEvent: trackEvent,
    trackBid: trackBid,

    // Direct GA4 access (advanced)
    sendToGA4: sendToGA4
  };

  console.log('[AdHub Analytics] ✅ Modulo caricato (versione 1.1.0 - Video Playlist Support)');

})();

// From: adhub-css-loader.js
/**
 * AdHub CSS Auto-Loader
 *
 * Carica automaticamente gli stili CSS necessari per:
 * - Ad containers (responsive)
 * - Video players (sticky, in-content)
 * - Video playlists (sticky, in-content)
 *
 * Il CSS viene iniettato dinamicamente nel <head> del documento
 * evitando così la necessità di file CSS esterni.
 *
 * @version 1.0.0
 * @date 2024-11-04
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.__adHubCSSLoaded) {
    console.warn('[AdHub CSS] CSS già caricato - Skip duplicato');
    return;
  }
  window.__adHubCSSLoaded = true;

  /**
   * Inietta CSS nel <head>
   */
  function injectCSS(css) {
    const style = document.createElement('style');
    style.type = 'text/css';
    style.id = 'adhub-dynamic-styles';

    if (style.styleSheet) {
      // IE
      style.styleSheet.cssText = css;
    } else {
      style.appendChild(document.createTextNode(css));
    }

    (document.head || document.getElementsByTagName('head')[0]).appendChild(style);
  }

  /**
   * CSS completo per AdHub
   */
  const adHubCSS = `
/* ============================================================================
   ADHUB - DYNAMIC STYLES
   Auto-generated and injected by AdHub bundle
   ============================================================================ */

/* -----------------------------------------------------------------------------
   AD CONTAINERS (Base & Responsive)
   ----------------------------------------------------------------------------- */

/* Base styles per tutti gli ad containers */
[id^="adhub-"] {
  margin: 20px auto;
  text-align: center;
  min-height: 50px;
  position: relative;
  overflow: hidden;
}

/* Top Banner */
#adhub-top-banner {
  max-width: 970px;
  margin: 20px auto;
}

/* Sidebar */
#adhub-sidebar {
  max-width: 300px;
  margin: 20px auto;
}

/* In-Article Ads */
#adhub-in-article,
#adhub-in-article-1,
#adhub-in-article-2,
#adhub-in-article-3 {
  max-width: 336px;
  margin: 30px auto;
  clear: both;
}

#adhub-300x250-top,
#adhub-300x250-mid,
#adhub-300x250-bottom {
  max-width: 300px;
  margin: 20px auto;
}

/* Sticky Bottom (Mobile) */
#adhub-sticky-bottom {
  position: fixed;
  bottom: 0;
  left: 0;
  right: 0;
  z-index: 9998;
  background: #fff;
  box-shadow: 0 -2px 5px rgba(0,0,0,0.1);
  text-align: center;
  margin: 0;
}

/* -----------------------------------------------------------------------------
   VIDEO PLAYERS (Single Ad)
   ----------------------------------------------------------------------------- */

/* Video Player Container Base */
.adhub-video-container {
  position: relative;
  width: 100%;
  max-width: 640px;
  margin: 20px auto;
}

/* Video Player Sticky Left */
#adhub-video-sticky-left {
  position: fixed;
  bottom: 20px;
  left: 20px;
  width: 320px;
  height: 180px;
  z-index: 9999;
  box-shadow: 0 4px 12px rgba(0,0,0,0.3);
  border-radius: 8px;
  overflow: hidden;
}

/* Video Player Sticky Right */
#adhub-video-sticky-right {
  position: fixed;
  bottom: 20px;
  right: 20px;
  width: 320px;
  height: 180px;
  z-index: 9999;
  box-shadow: 0 4px 12px rgba(0,0,0,0.3);
  border-radius: 8px;
  overflow: hidden;
}

/* Video Player In-Article */
#adhub-video-in-article {
  position: relative;
  max-width: 640px;
  margin: 30px auto;
  border-radius: 8px;
  overflow: hidden;
}

/* Video Close Button */
.adhub-video-close {
  position: absolute;
  top: 8px;
  right: 8px;
  width: 32px;
  height: 32px;
  background: rgba(0, 0, 0, 0.7);
  color: #fff;
  border: none;
  border-radius: 50%;
  cursor: pointer;
  font-size: 18px;
  line-height: 32px;
  text-align: center;
  z-index: 10000;
  transition: background 0.2s ease;
}

.adhub-video-close:hover {
  background: rgba(0, 0, 0, 0.9);
}

/* -----------------------------------------------------------------------------
   VIDEO PLAYLISTS
   ----------------------------------------------------------------------------- */

/* Playlist Container Base */
.adhub-playlist-container {
  position: relative;
  background: #000;
  border-radius: 8px;
  overflow: hidden;
}

/* Playlist Sticky Bottom-Left */
.adhub-playlist-sticky-bottom-left {
  position: fixed;
  bottom: 20px;
  left: 20px;
  width: 400px;
  height: 225px;
  z-index: 9999;
  box-shadow: 0 4px 16px rgba(0,0,0,0.4);
}

/* Playlist Sticky Bottom-Right */
.adhub-playlist-sticky-bottom-right {
  position: fixed;
  bottom: 20px;
  right: 20px;
  width: 400px;
  height: 225px;
  z-index: 9999;
  box-shadow: 0 4px 16px rgba(0,0,0,0.4);
}

/* Playlist In-Content */
.adhub-playlist-in-content {
  position: relative;
  max-width: 640px;
  margin: 30px auto;
  aspect-ratio: 16 / 9;
}

/* Playlist Video Element */
.adhub-playlist-container video {
  width: 100%;
  height: 100%;
  object-fit: contain;
  background: #000;
}

/* Playlist Controls */
.adhub-playlist-controls {
  position: absolute;
  bottom: 0;
  left: 0;
  right: 0;
  background: linear-gradient(to top, rgba(0,0,0,0.8), transparent);
  padding: 10px;
  display: flex;
  align-items: center;
  gap: 10px;
}

.adhub-playlist-controls button {
  background: rgba(255, 255, 255, 0.2);
  border: 1px solid rgba(255, 255, 255, 0.3);
  color: #fff;
  padding: 8px 12px;
  border-radius: 4px;
  cursor: pointer;
  font-size: 14px;
  transition: all 0.2s ease;
}

.adhub-playlist-controls button:hover {
  background: rgba(255, 255, 255, 0.3);
}

/* Playlist Progress Bar */
.adhub-playlist-progress {
  flex: 1;
  height: 4px;
  background: rgba(255, 255, 255, 0.3);
  border-radius: 2px;
  overflow: hidden;
  cursor: pointer;
}

.adhub-playlist-progress-bar {
  height: 100%;
  background: #1e90ff;
  width: 0%;
  transition: width 0.1s linear;
}

/* Playlist Title */
.adhub-playlist-title {
display:none;
  position: absolute;
  top: 10px;
  left: 10px;
  right: 50px;
  color: #fff;
  font-size: 14px;
  font-weight: 600;
  text-shadow: 0 1px 3px rgba(0,0,0,0.8);
  padding: 8px 12px;
  background: rgba(0, 0, 0, 0.6);
  border-radius: 4px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

/* Playlist Close Button */
.adhub-playlist-close {
  position: absolute;
  top: 10px;
  right: 10px;
  width: 32px;
  height: 32px;
  background: rgba(0, 0, 0, 0.7);
  color: #fff;
  border: none;
  border-radius: 50%;
  cursor: pointer;
  font-size: 18px;
  line-height: 32px;
  text-align: center;
  z-index: 10000;
  transition: background 0.2s ease;
}

.adhub-playlist-close:hover {
  background: rgba(255, 0, 0, 0.8);
}

/* Playlist Next Button */
.adhub-playlist-next {
  position: absolute;
  bottom: 50px;
  right: 10px;
  padding: 8px 16px;
  background: rgba(30, 144, 255, 0.9);
  color: #fff;
  border: none;
  border-radius: 4px;
  cursor: pointer;
  font-size: 14px;
  font-weight: 600;
  transition: background 0.2s ease;
}

.adhub-playlist-next:hover {
  background: rgba(30, 144, 255, 1);
}

/* Playlist Video Count */
.adhub-playlist-count {
  position: absolute;
  bottom: 50px;
  left: 10px;
  padding: 6px 12px;
  background: rgba(0, 0, 0, 0.7);
  color: #fff;
  border-radius: 4px;
  font-size: 12px;
  font-weight: 600;
}

/* IMA Ad Container */
.adhub-ima-ad-container {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  z-index: 100;
}

/* -----------------------------------------------------------------------------
   RESPONSIVE BREAKPOINTS
   ----------------------------------------------------------------------------- */

/* Desktop (≥ 1024px) */
@media (min-width: 1024px) {
  #adhub-top-banner {
    min-height: 250px;
  }

  #adhub-sidebar {
    min-height: 600px;
  }
}

/* Tablet (768px - 1023px) */
@media (min-width: 768px) and (max-width: 1023px) {
  #adhub-top-banner {
    min-height: 90px;
  }

  #adhub-sidebar {
    min-height: 250px;
  }

  .adhub-playlist-sticky-bottom-left,
  .adhub-playlist-sticky-bottom-right {
    width: 350px;
    height: 197px;
  }
}

/* Mobile (< 768px) */
@media (max-width: 767px) {
  /* Hide desktop sticky bottom, mostrato solo su mobile */
  #adhub-sticky-bottom {
    display: block;
  }

  /* Hide sidebar on mobile */
  #adhub-sidebar {
    display: none;
  }

  /* Top banner mobile */
  #adhub-top-banner {
    min-height: 100px;
  }

  /* Video players sticky - ridimensiona per mobile */
  #adhub-video-sticky-left,
  #adhub-video-sticky-right {
    width: 280px;
    height: 157px;
    bottom: 10px;
  }

  #adhub-video-sticky-left {
    left: 10px;
  }

  #adhub-video-sticky-right {
    right: 10px;
  }

  /* Playlist sticky - ridimensiona per mobile */
  .adhub-playlist-sticky-bottom-left,
  .adhub-playlist-sticky-bottom-right {
    width: calc(100vw - 20px);
    max-width: 350px;
    height: auto;
    aspect-ratio: 16 / 9;
    bottom: 10px;
  }

  .adhub-playlist-sticky-bottom-left {
    left: 10px;
    right: auto;
  }

  .adhub-playlist-sticky-bottom-right {
    right: 10px;
    left: auto;
  }

  /* In-content video/playlist - full width mobile */
  #adhub-video-in-article,
  .adhub-playlist-in-content {
    max-width: 100%;
    margin: 20px 0;
  }
}

/* Very Small Mobile (< 480px) */
@media (max-width: 479px) {
  #adhub-top-banner {
    min-height: 50px;
  }

  #adhub-in-article,
  #adhub-in-article-1,
  #adhub-in-article-2,
  #adhub-in-article-3,
  #adhub-300x250-top,
  #adhub-300x250-mid,
  #adhub-300x250-bottom {
    margin: 15px auto;
  }

  .adhub-playlist-sticky-bottom-left,
  .adhub-playlist-sticky-bottom-right {
    max-width: 300px;
  }
}

/* -----------------------------------------------------------------------------
   ACCESSIBILITY & UX
   ----------------------------------------------------------------------------- */

/* Focus styles for keyboard navigation */
.adhub-playlist-controls button:focus,
.adhub-playlist-close:focus,
.adhub-playlist-next:focus,
.adhub-video-close:focus {
  outline: 2px solid #1e90ff;
  outline-offset: 2px;
}

/* Reduced motion for users who prefer it */
@media (prefers-reduced-motion: reduce) {
  .adhub-playlist-controls button,
  .adhub-playlist-close,
  .adhub-playlist-next,
  .adhub-video-close,
  .adhub-playlist-progress-bar {
    transition: none;
  }
}

/* Loading state */
.adhub-loading {
  position: relative;
}

.adhub-loading::after {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  width: 40px;
  height: 40px;
  margin: -20px 0 0 -20px;
  border: 4px solid rgba(30, 144, 255, 0.2);
  border-top-color: #1e90ff;
  border-radius: 50%;
  animation: adhub-spin 1s linear infinite;
}

@keyframes adhub-spin {
  to { transform: rotate(360deg); }
}

/* -----------------------------------------------------------------------------
   PRINT STYLES (Hide ads when printing)
   ----------------------------------------------------------------------------- */

@media print {
  [id^="adhub-"],
  .adhub-video-container,
  .adhub-playlist-container {
    display: none !important;
  }
}

/* ============================================================================
   END ADHUB DYNAMIC STYLES
   ============================================================================ */
`;

  /**
   * Inizializza CSS loader
   */
  function init() {
    // Inietta CSS nel DOM
    injectCSS(adHubCSS);
    console.log('[AdHub CSS] ✅ Stili dinamici iniettati (' + Math.round(adHubCSS.length / 1024) + 'KB)');
  }

  // Auto-init quando DOM è pronto
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

  // Export API (opzionale)
  window.AdHubCSS = {
    loaded: true,
    version: '1.0.0',

    // Reload CSS (per debug)
    reload: function() {
      const existing = document.getElementById('adhub-dynamic-styles');
      if (existing) {
        existing.parentNode.removeChild(existing);
      }
      init();
      console.log('[AdHub CSS] 🔄 Stili ricaricati');
    },

    // Get CSS content
    getCSS: function() {
      return adHubCSS;
    }
  };

})();

// From: adhub-debug.js
/**
 * AdHub Debug Module
 *
 * Sistema di diagnostica per verificare perché le chiamate ai bidder
 * non vengono effettuate
 *
 * @version 1.0.0
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__adHubDebugLoaded) {
    console.warn('[AdHubDebug] Modulo già caricato - Skip duplicato');
    return;
  }
  window.__adHubDebugLoaded = true;

  const AdHubDebug = {
    // Flag per abilitare debug esteso
    enabled: window.location.search.indexOf('debug=adhub') !== -1 ||
             window.location.search.indexOf('debug=1') !== -1,

    /**
     * Log con timestamp
     */
    log: function(message, data, level = 'info') {
      if (!this.enabled && level !== 'error' && level !== 'warn') return;

      const timestamp = new Date().toISOString().substr(11, 12);
      const prefix = '[AdHubDebug]';
      const icons = {
        info: 'ℹ️',
        warn: '⚠️',
        error: '❌',
        success: '✅',
        debug: '🔍'
      };

      const icon = icons[level] || 'ℹ️';
      const consoleMethod = level === 'error' ? 'error' : level === 'warn' ? 'warn' : 'log';

      console[consoleMethod](`${prefix} ${icon} [${timestamp}] ${message}`, data || '');
    },

    /**
     * Verifica stato Prebid
     */
    checkPrebidStatus: function() {
      this.log('=== VERIFICA STATO PREBID ===', null, 'debug');

      const checks = {
        prebidLoaded: typeof window.pbjs !== 'undefined',
        prebidVersion: window.pbjs?.version || 'N/A',
        prebidQueue: window.pbjs?.que?.length || 0,
        adUnitsRegistered: window.pbjs?.adUnits?.length || 0,
        biddersConfigured: window.pbjs?.installedModules?.length || 0
      };

      this.log('Prebid caricato:', checks.prebidLoaded, checks.prebidLoaded ? 'success' : 'error');
      this.log('Prebid versione:', checks.prebidVersion, 'info');
      this.log('Queue size:', checks.prebidQueue, 'info');
      this.log('Ad units registrati:', checks.adUnitsRegistered, checks.adUnitsRegistered > 0 ? 'success' : 'warn');
      this.log('Bidders installati:', checks.biddersConfigured, 'info');

      if (!checks.prebidLoaded) {
        this.log('❌ PROBLEMA: Prebid.js non caricato!', null, 'error');
        return false;
      }

      if (checks.adUnitsRegistered === 0) {
        this.log('⚠️ PROBLEMA: Nessun ad unit registrato!', null, 'warn');
        return false;
      }

      return true;
    },

    /**
     * Verifica ad units
     */
    checkAdUnits: function() {
      this.log('=== VERIFICA AD UNITS ===', null, 'debug');

      if (typeof pbjs === 'undefined') {
        this.log('Prebid non disponibile', null, 'error');
        return;
      }

      const adUnits = pbjs.adUnits || [];

      this.log(`Totale ad units: ${adUnits.length}`, null, 'info');

      adUnits.forEach((unit, index) => {
        this.log(`\n--- Ad Unit ${index + 1}: ${unit.code} ---`, null, 'info');
        this.log(`  Codice: ${unit.code}`, null, 'info');

        // Media types
        if (unit.mediaTypes) {
          Object.keys(unit.mediaTypes).forEach(type => {
            const sizes = unit.mediaTypes[type].sizes;
            this.log(`  Media Type: ${type}`, null, 'info');
            this.log(`  Sizes: ${JSON.stringify(sizes)}`, null, 'info');
          });
        }

        // Bidders
        const bidders = unit.bids || [];
        this.log(`  Bidders configurati: ${bidders.length}`, null, bidders.length > 0 ? 'success' : 'warn');

        bidders.forEach(bid => {
          this.log(`    - ${bid.bidder}`, bid.params, 'info');
        });

        // Verifica che il div esista
        const divExists = !!document.getElementById(unit.code);
        this.log(`  Div presente in DOM: ${divExists}`, null, divExists ? 'success' : 'error');

        if (!divExists) {
          this.log(`  ❌ PROBLEMA: Div #${unit.code} non trovato nel DOM!`, null, 'error');
        }
      });
    },

    /**
     * Verifica configurazione bidders
     */
    checkBiddersConfig: function() {
      this.log('=== VERIFICA CONFIGURAZIONE BIDDERS ===', null, 'debug');

      if (typeof pbjs === 'undefined') {
        this.log('Prebid non disponibile', null, 'error');
        return;
      }

      // Moduli installati
      const installedModules = pbjs.installedModules || [];
      this.log('Moduli installati:', installedModules, 'info');

      // Verifica bidder adapters
      const bidderAdapters = installedModules.filter(m => m.includes('BidAdapter'));
      this.log(`Bidder adapters: ${bidderAdapters.length}`, bidderAdapters, 'info');

      if (bidderAdapters.length === 0) {
        this.log('⚠️ PROBLEMA: Nessun bidder adapter installato!', null, 'error');
      }

      // Verifica configurazione Prebid
      const config = pbjs.getConfig() || {};
      this.log('Timeout auction:', config.bidderTimeout || config.timeout, 'info');
      this.log('Price granularity:', config.priceGranularity, 'info');
      this.log('Currency:', config.currency, 'info');
    },

    /**
     * Verifica consent management
     */
    checkConsent: function() {
      this.log('=== VERIFICA CONSENT MANAGEMENT ===', null, 'debug');

      // Verifica CMP
      const cmpExists = typeof window.__tcfapi === 'function';
      this.log('CMP presente:', cmpExists, cmpExists ? 'success' : 'warn');

      // Verifica AdHubCMP
      const adhubCMPExists = typeof window.AdHubCMP !== 'undefined';
      this.log('AdHubCMP presente:', adhubCMPExists, adhubCMPExists ? 'success' : 'warn');

      if (adhubCMPExists) {
        const state = window.AdHubCMP.getState();
        this.log('CMP rilevata:', state.cmpDetected, state.cmpDetected ? 'success' : 'error');
        this.log('CMP pronta:', state.cmpReady, state.cmpReady ? 'success' : 'warn');
        this.log('Consenso dato:', state.consentGiven, state.consentGiven ? 'success' : 'error');
        this.log('Sistema inizializzato:', state.initialized, state.initialized ? 'success' : 'warn');

        if (state.error) {
          this.log('Errore CMP:', state.error, 'error');
        }

        if (!state.consentGiven) {
          this.log('❌ PROBLEMA: Consenso NON dato - Le chiamate ai bidder sono bloccate!', null, 'error');
        }
      }

      // Verifica configurazione consent in Prebid
      if (typeof pbjs !== 'undefined') {
        const config = pbjs.getConfig() || {};
        if (config.consentManagement) {
          this.log('Consent Management config:', config.consentManagement, 'info');
        }
      }
    },

    /**
     * Verifica che le auction siano partite
     */
    checkAuctions: function() {
      this.log('=== VERIFICA AUCTION ===', null, 'debug');

      if (typeof pbjs === 'undefined') {
        this.log('Prebid non disponibile', null, 'error');
        return;
      }

      // Verifica bid responses
      const bidResponses = pbjs.getBidResponses() || {};
      const adUnitCodes = Object.keys(bidResponses);

      this.log(`Ad units con risposte: ${adUnitCodes.length}`, null, 'info');

      if (adUnitCodes.length === 0) {
        this.log('⚠️ PROBLEMA: Nessuna auction eseguita ancora!', null, 'warn');
        this.log('Possibili cause:', null, 'info');
        this.log('  1. Auction non ancora partita', null, 'info');
        this.log('  2. requestBids() non chiamato', null, 'info');
        this.log('  3. Consenso bloccato', null, 'info');
        return;
      }

      // Analizza ogni ad unit
      adUnitCodes.forEach(code => {
        const response = bidResponses[code];
        const bids = response.bids || [];

        this.log(`\n--- Ad Unit: ${code} ---`, null, 'info');
        this.log(`  Bids ricevuti: ${bids.length}`, null, bids.length > 0 ? 'success' : 'warn');

        if (bids.length === 0) {
          this.log('  ⚠️ Nessun bid ricevuto', null, 'warn');
        } else {
          bids.forEach(bid => {
            this.log(`  - ${bid.bidder}: $${bid.cpm} CPM (${bid.currency})`, null, 'success');
            this.log(`    Size: ${bid.width}x${bid.height}`, null, 'info');
            this.log(`    Status: ${bid.status}`, null, 'info');
            if (bid.timeToRespond) {
              this.log(`    Response time: ${bid.timeToRespond}ms`, null, 'info');
            }
          });
        }
      });
    },

    /**
     * Verifica DOM elements
     */
    checkDOMElements: function() {
      this.log('=== VERIFICA ELEMENTI DOM ===', null, 'debug');

      if (typeof pbjs === 'undefined' || !pbjs.adUnits) {
        this.log('Prebid o ad units non disponibili', null, 'error');
        return;
      }

      const adUnits = pbjs.adUnits || [];
      let foundCount = 0;
      let missingCount = 0;

      adUnits.forEach(unit => {
        const element = document.getElementById(unit.code);

        if (element) {
          foundCount++;
          this.log(`✅ Trovato: #${unit.code}`, null, 'success');

          // Verifica dimensioni
          const rect = element.getBoundingClientRect();
          this.log(`   Dimensioni: ${rect.width}x${rect.height}px`, null, 'info');
          this.log(`   Visibile: ${rect.width > 0 && rect.height > 0}`, null, rect.width > 0 && rect.height > 0 ? 'success' : 'warn');
        } else {
          missingCount++;
          this.log(`❌ Mancante: #${unit.code}`, null, 'error');
        }
      });

      this.log(`\nRiepilogo: ${foundCount} trovati, ${missingCount} mancanti`, null, 'info');

      if (missingCount > 0) {
        this.log('❌ PROBLEMA: Alcuni div degli ad slots non sono presenti nel DOM!', null, 'error');
      }
    },

    /**
     * Verifica network requests
     */
    checkNetworkRequests: function() {
      this.log('=== SUGGERIMENTO: VERIFICA NETWORK ===', null, 'debug');
      this.log('Apri la tab Network degli strumenti sviluppatore e cerca:', null, 'info');
      this.log('  - Richieste a domini bidder (appnexus.com, nexx360, etc.)', null, 'info');
      this.log('  - Status code (200 = OK, 4xx = errore)', null, 'info');
      this.log('  - Response body (contiene bid?)', null, 'info');
    },

    /**
     * Diagnostica completa
     */
    runFullDiagnostics: function() {
      console.log('\n');
      console.log('╔════════════════════════════════════════════════════════════════╗');
      console.log('║                                                                ║');
      console.log('║           🔍 ADHUB DIAGNOSTICA COMPLETA                       ║');
      console.log('║                                                                ║');
      console.log('╚════════════════════════════════════════════════════════════════╝');
      console.log('\n');

      // 1. Prebid status
      const prebidOk = this.checkPrebidStatus();
      console.log('\n');

      // 2. Consent
      this.checkConsent();
      console.log('\n');

      // 3. Ad units
      if (prebidOk) {
        this.checkAdUnits();
        console.log('\n');
      }

      // 4. Bidders config
      if (prebidOk) {
        this.checkBiddersConfig();
        console.log('\n');
      }

      // 5. DOM elements
      if (prebidOk) {
        this.checkDOMElements();
        console.log('\n');
      }

      // 6. Auctions
      if (prebidOk) {
        this.checkAuctions();
        console.log('\n');
      }

      // 7. Network
      this.checkNetworkRequests();
      console.log('\n');

      // Riepilogo finale
      console.log('╔════════════════════════════════════════════════════════════════╗');
      console.log('║                    🎯 POSSIBILI PROBLEMI                      ║');
      console.log('╚════════════════════════════════════════════════════════════════╝');
      console.log('\n');

      this.suggestFixes();
    },

    /**
     * Suggerisci fix per problemi comuni
     */
    suggestFixes: function() {
      const issues = [];

      // Check Prebid
      if (typeof pbjs === 'undefined') {
        issues.push({
          problem: 'Prebid.js non caricato',
          solution: 'Verifica che lo script prebid-custom.js sia incluso nel HTML'
        });
      }

      // Check consent
      if (window.AdHubCMP) {
        const state = window.AdHubCMP.getState();
        if (!state.consentGiven) {
          issues.push({
            problem: 'Consenso non dato',
            solution: 'Accetta il banner CMP oppure usa: AdHubCMP.forceInit() (solo test)'
          });
        }
      }

      // Check ad units
      if (typeof pbjs !== 'undefined') {
        const adUnits = pbjs.adUnits || [];
        if (adUnits.length === 0) {
          issues.push({
            problem: 'Nessun ad unit registrato',
            solution: 'Verifica che la configurazione del sito sia caricata correttamente'
          });
        }

        // Check missing divs
        adUnits.forEach(unit => {
          if (!document.getElementById(unit.code)) {
            issues.push({
              problem: `Div #${unit.code} mancante nel DOM`,
              solution: `Aggiungi <div id="${unit.code}"></div> nell'HTML`
            });
          }
        });

        // Check auction
        const bidResponses = pbjs.getBidResponses() || {};
        if (Object.keys(bidResponses).length === 0) {
          issues.push({
            problem: 'Nessuna auction eseguita',
            solution: 'Chiama manualmente: pbjs.requestBids() oppure aspetta init automatica'
          });
        }
      }

      // Mostra problemi
      if (issues.length === 0) {
        console.log('✅ Nessun problema rilevato!');
        console.log('Se le chiamate non partono comunque, verifica la tab Network.');
      } else {
        issues.forEach((issue, index) => {
          console.log(`\n${index + 1}. ❌ ${issue.problem}`);
          console.log(`   💡 Soluzione: ${issue.solution}`);
        });
      }
    },

    /**
     * Monitor auction in real-time
     */
    monitorAuction: function() {
      this.log('=== MONITOR AUCTION ATTIVO ===', null, 'debug');
      this.log('Ascolto eventi Prebid in tempo reale...', null, 'info');

      if (typeof pbjs === 'undefined') {
        this.log('Prebid non disponibile', null, 'error');
        return;
      }

      pbjs.que.push(() => {
        // Bid requested
        pbjs.onEvent('bidRequested', (bidRequest) => {
          this.log(`📤 Bid richiesto: ${bidRequest.bidderCode}`, {
            bidder: bidRequest.bidderCode,
            bids: bidRequest.bids.length,
            timeout: bidRequest.timeout
          }, 'info');
        });

        // Bid response
        pbjs.onEvent('bidResponse', (bid) => {
          this.log(`📥 Bid ricevuto: ${bid.bidder}`, {
            bidder: bid.bidder,
            cpm: bid.cpm,
            currency: bid.currency,
            size: `${bid.width}x${bid.height}`,
            timeToRespond: `${bid.timeToRespond}ms`
          }, 'success');
        });

        // Bid timeout
        pbjs.onEvent('bidTimeout', (timedOutBidders) => {
          timedOutBidders.forEach(bidder => {
            this.log(`⏱️ Bid timeout: ${bidder.bidder}`, bidder, 'warn');
          });
        });

        // No bid
        pbjs.onEvent('noBid', (noBid) => {
          this.log(`🚫 No bid: ${noBid.bidder}`, noBid, 'warn');
        });

        // Auction end
        pbjs.onEvent('auctionEnd', (auction) => {
          this.log(`🏁 Auction terminata`, {
            adUnitCodes: auction.adUnitCodes,
            bidsReceived: auction.bidsReceived?.length || 0,
            noBids: auction.noBids?.length || 0
          }, 'info');
        });

        this.log('✅ Monitor eventi attivo', null, 'success');
      });
    }
  };

  // Export globale
  window.AdHubDebug = AdHubDebug;

  // Auto-run se debug abilitato
  if (AdHubDebug.enabled) {
    console.log('[AdHubDebug] 🔍 Debug mode attivo');
    console.log('[AdHubDebug] Usa AdHubDebug.runFullDiagnostics() per diagnostica completa');
    console.log('[AdHubDebug] Usa AdHubDebug.monitorAuction() per monitor real-time');

    // Run diagnostica dopo 3 secondi
    setTimeout(() => {
      console.log('\n[AdHubDebug] 🔍 Esecuzione diagnostica automatica...\n');
      AdHubDebug.runFullDiagnostics();
    }, 3000);
  }

  console.log('[AdHubDebug] Module loaded');
})();

// From: adhub-dynamic-tags.js
/**
 * AdHub Dynamic Tags Injector
 *
 * Sistema per l'iniezione dinamica di tag pubblicitari prima del caricamento di GAM.
 * Supporta formati speciali come:
 * - Video Sticky
 * - Skin/Wallpaper
 * - Interstitial
 * - In-text/In-image ads
 * - Altre posizioni custom
 *
 * @version 1.0.0
 * @date 2025-01-14
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__AdHubDynamicTagsLoaded) {
    console.warn('[AdHub DynamicTags] Modulo già caricato - Skip duplicato');
    return;
  }
  window.__AdHubDynamicTagsLoaded = true;

  /**
   * Configurazione di default
   */
  const DEFAULT_CONFIG = {
    enabled: true,
    debug: false,

    // Tags da iniettare
    tags: []
    /*
    Esempio configurazione:
    tags: [
      {
        type: 'video-sticky',           // Tipo di tag (usato per logging)
        enabled: true,                  // Flag per abilitare/disabilitare
        targetSelector: 'body',         // Dove inserire (CSS selector)
        position: 'afterbegin',         // 'beforebegin', 'afterbegin', 'beforeend', 'afterend'
        html: '<div id="adhub-video-sticky"></div>',  // HTML da iniettare
        attributes: {                   // Attributi opzionali da aggiungere
          'data-ad-type': 'video-sticky',
          'style': 'position: fixed; bottom: 0; right: 0; z-index: 9999;'
        }
      },
      {
        type: 'skin',
        enabled: true,
        targetSelector: 'body',
        position: 'afterbegin',
        html: '<div id="adhub-skin-left"></div><div id="adhub-skin-right"></div>',
        condition: function() {         // Condizione opzionale per iniettare
          return window.innerWidth >= 1440;  // Solo desktop large
        }
      },
      {
        type: 'interstitial',
        enabled: true,
        targetSelector: 'body',
        position: 'beforeend',
        html: '<div id="adhub-interstitial" style="display:none;"></div>'
      }
    ]
    */
  };

  /**
   * Stato interno
   */
  const state = {
    initialized: false,
    injectedTags: [],
    errors: []
  };

  /**
   * Merge configurazione custom con default
   */
  function mergeConfig(customConfig) {
    if (!customConfig) return DEFAULT_CONFIG;

    const merged = Object.assign({}, DEFAULT_CONFIG);

    Object.keys(customConfig).forEach(function(key) {
      if (key === 'tags') {
        // Per i tags, merge array
        merged.tags = (customConfig.tags || []).slice();
      } else {
        merged[key] = customConfig[key];
      }
    });

    return merged;
  }

  // Configurazione finale
  const CONFIG = mergeConfig(window.AdHubDynamicTagsConfig);

  /**
   * Logging helper
   */
  function log(message, data) {
    if (CONFIG.debug) {
      if (data) {
        console.log('[AdHub DynamicTags]', message, data);
      } else {
        console.log('[AdHub DynamicTags]', message);
      }
    }
  }

  /**
   * Inietta un singolo tag nel DOM
   */
  function injectTag(tagConfig) {
    // Verifica se il tag è abilitato
    if (tagConfig.enabled === false) {
      log('⏭️  Tag disabilitato:', tagConfig.type);
      return { success: false, reason: 'disabled' };
    }

    // Verifica condizione opzionale
    if (typeof tagConfig.condition === 'function') {
      try {
        if (!tagConfig.condition()) {
          log('⏭️  Condizione non soddisfatta per:', tagConfig.type);
          return { success: false, reason: 'condition_not_met' };
        }
      } catch (e) {
        console.error('[AdHub DynamicTags] Errore nella valutazione della condizione per:', tagConfig.type, e);
        state.errors.push({ tag: tagConfig.type, error: 'condition_error', message: e.message });
        return { success: false, reason: 'condition_error', error: e };
      }
    }

    // Trova l'elemento target
    const targetElement = document.querySelector(tagConfig.targetSelector || 'body');
    if (!targetElement) {
      console.warn('[AdHub DynamicTags] Elemento target non trovato:', tagConfig.targetSelector);
      state.errors.push({ tag: tagConfig.type, error: 'target_not_found', selector: tagConfig.targetSelector });
      return { success: false, reason: 'target_not_found' };
    }

    try {
      // Crea un container temporaneo per parsare l'HTML
      const tempDiv = document.createElement('div');
      tempDiv.innerHTML = tagConfig.html.trim();

      // Applica attributi aggiuntivi se specificati
      if (tagConfig.attributes) {
        Array.from(tempDiv.children).forEach(function(element) {
          Object.keys(tagConfig.attributes).forEach(function(attr) {
            if (attr === 'style' && element.getAttribute('style')) {
              // Merge style esistente con nuovo
              element.setAttribute('style', element.getAttribute('style') + '; ' + tagConfig.attributes[attr]);
            } else {
              element.setAttribute(attr, tagConfig.attributes[attr]);
            }
          });
        });
      }

      // Inietta nel DOM usando insertAdjacentHTML
      const position = tagConfig.position || 'beforeend';
      targetElement.insertAdjacentHTML(position, tempDiv.innerHTML);

      log('✅ Tag iniettato:', { type: tagConfig.type, target: tagConfig.targetSelector, position: position });

      state.injectedTags.push({
        type: tagConfig.type,
        selector: tagConfig.targetSelector,
        position: position,
        timestamp: Date.now()
      });

      return { success: true };

    } catch (e) {
      console.error('[AdHub DynamicTags] Errore nell\'iniezione del tag:', tagConfig.type, e);
      state.errors.push({ tag: tagConfig.type, error: 'injection_error', message: e.message });
      return { success: false, reason: 'injection_error', error: e };
    }
  }

  /**
   * Inizializza e inietta tutti i tag configurati
   */
  function initialize() {
    if (state.initialized) {
      console.warn('[AdHub DynamicTags] Modulo già inizializzato');
      return;
    }

    if (!CONFIG.enabled) {
      console.log('[AdHub DynamicTags] Modulo disabilitato');
      return;
    }

    console.log('[AdHub DynamicTags] 🚀 Inizializzazione...');
    console.log('[AdHub DynamicTags] Tags configurati:', CONFIG.tags.length);

    state.initialized = true;

    // Inietta tutti i tag
    let injectedCount = 0;
    let skippedCount = 0;
    let errorCount = 0;

    CONFIG.tags.forEach(function(tagConfig) {
      const result = injectTag(tagConfig);

      if (result.success) {
        injectedCount++;
      } else if (result.reason === 'disabled' || result.reason === 'condition_not_met') {
        skippedCount++;
      } else {
        errorCount++;
      }
    });

    console.log('[AdHub DynamicTags] ✅ Iniezione completata');
    console.log('[AdHub DynamicTags] 📊 Statistiche:', {
      totale: CONFIG.tags.length,
      iniettati: injectedCount,
      saltati: skippedCount,
      errori: errorCount
    });

    if (errorCount > 0) {
      console.warn('[AdHub DynamicTags] ⚠️  Errori rilevati:', state.errors);
    }

    // Dispatch evento per notificare altri moduli
    window.dispatchEvent(new CustomEvent('adhub:dynamictags:ready', {
      detail: {
        injected: state.injectedTags,
        errors: state.errors
      }
    }));
  }

  /**
   * API Pubblica
   */
  window.AdHubDynamicTags = {
    /**
     * Inizializza manualmente (se non auto-init)
     */
    init: function() {
      initialize();
    },

    /**
     * Ottieni configurazione corrente
     */
    getConfig: function() {
      return CONFIG;
    },

    /**
     * Ottieni stato corrente
     */
    getState: function() {
      return {
        initialized: state.initialized,
        injectedTags: state.injectedTags.slice(),
        errors: state.errors.slice()
      };
    },

    /**
     * Inietta un tag dinamicamente dopo l'inizializzazione
     */
    injectTag: function(tagConfig) {
      if (!state.initialized) {
        console.warn('[AdHub DynamicTags] Modulo non ancora inizializzato');
        return { success: false, reason: 'not_initialized' };
      }
      return injectTag(tagConfig);
    },

    /**
     * Verifica se un tag è stato iniettato
     */
    isTagInjected: function(tagType) {
      return state.injectedTags.some(function(tag) {
        return tag.type === tagType;
      });
    },

    /**
     * Debug info
     */
    debug: function() {
      console.group('🔍 AdHub Dynamic Tags - Debug Info');
      console.log('Configurazione:', CONFIG);
      console.log('Stato:', state);
      console.log('Tags iniettati:', state.injectedTags);
      console.log('Errori:', state.errors);
      console.groupEnd();
    }
  };

  // ============================================================================
  // AUTO-INIZIALIZZAZIONE
  // ============================================================================

  /**
   * Inizializzazione automatica
   * Eseguita PRIMA del caricamento di GAM per iniettare i container
   *
   * IMPORTANTE: L'inizializzazione viene ritardata fino a quando il config del sito
   * non definisce window.AdHubDynamicTagsConfig
   */
  function autoInit() {
    // Aspetta che il DOM sia pronto E che la config sia caricata
    function waitForDOMAndConfig() {
      // Aspetta che il DOM sia completamente caricato
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', waitForDOMAndConfig);
        return;
      }

      // Polling per aspettare che la config del sito venga caricata
      // (il modulo può essere caricato prima della config nel bundle)
      let attempts = 0;
      const maxAttempts = 100; // Max 1 secondo (10ms * 100)

      function checkConfig() {
        attempts++;

        // Verifica se la config è stata definita
        const hasConfig = window.AdHubDynamicTagsConfig &&
                         typeof window.AdHubDynamicTagsConfig === 'object' &&
                         window.AdHubDynamicTagsConfig.tags &&
                         Array.isArray(window.AdHubDynamicTagsConfig.tags);

        if (hasConfig) {
          // Config trovata, merge e inizializza
          const finalConfig = mergeConfig(window.AdHubDynamicTagsConfig);
          CONFIG.enabled = finalConfig.enabled;
          CONFIG.debug = finalConfig.debug;
          CONFIG.tags = finalConfig.tags;

          log('Config caricata da site config');
          initialize();
        } else if (attempts < maxAttempts) {
          // Config non ancora pronta, riprova
          setTimeout(checkConfig, 10);
        } else {
          // Timeout: usa config di default (probabilmente tags vuoto)
          console.log('[AdHub DynamicTags] Config del sito non trovata, uso default (probabilmente nessun tag)');
          initialize();
        }
      }

      // Inizia il polling
      checkConfig();
    }

    waitForDOMAndConfig();
  }

  // Avvia auto-init
  autoInit();

  console.log('[AdHub DynamicTags] ✅ Modulo caricato');

})();

// From: adhub-refresh.js
/**
 * AdHub Bid Refresh Module
 *
 * Gestisce il refresh automatico delle bid per slot permanenti
 * (sticky, sidebar) per massimizzare il revenue.
 *
 * IMPORTANTE: Il refresh aumenta il revenue del 30-50% su slot
 * sempre visibili, ma deve essere fatto solo quando lo slot
 * è in viewport.
 *
 * @version 1.0.0
 * @date 2025-10-31
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.AdHubRefresh) {
    console.warn('[AdHubRefresh] Modulo già caricato');
    return;
  }

  // ============================================================================
  // CONFIGURAZIONE
  // ============================================================================

  const DEFAULT_CONFIG = {
    // Intervallo refresh (millisecondi)
    refreshInterval: 30000, // 30 secondi

    // Minimo viewability time prima di refresh
    minViewabilityTime: 10000, // 10 secondi

    // Max refresh per session
    maxRefreshPerSession: 10,

    // Viewability threshold (% in viewport)
    viewabilityThreshold: 50, // 50% visibile

    // Slot che possono essere refreshed
    eligibleSlots: [
      'adhub-sticky-bottom',
      'adhub-sidebar',
      'adhub-300x250-top',
      'adhub-300x250-mid'
    ],

    // Debug
    debug: false
  };

  // ============================================================================
  // STATE
  // ============================================================================

  const state = {
    config: {...DEFAULT_CONFIG},
    initialized: false,
    refreshCounters: {},  // adUnitCode -> count
    viewabilityTimers: {}, // adUnitCode -> timestamp first view
    activeTimers: {},     // adUnitCode -> interval ID
    observers: {}         // adUnitCode -> IntersectionObserver
  };

  // ============================================================================
  // UTILITY FUNCTIONS
  // ============================================================================

  function log(...args) {
    if (state.config.debug) {
      console.log('[AdHubRefresh]', ...args);
    }
  }

  function error(...args) {
    console.error('[AdHubRefresh]', ...args);
  }

  /**
   * Verifica se lo slot è eleggibile per refresh
   */
  function isEligible(adUnitCode) {
    return state.config.eligibleSlots.indexOf(adUnitCode) !== -1;
  }

  /**
   * Verifica se lo slot ha raggiunto il max refresh
   */
  function canRefresh(adUnitCode) {
    const count = state.refreshCounters[adUnitCode] || 0;
    return count < state.config.maxRefreshPerSession;
  }

  /**
   * Verifica se lo slot è stato visibile abbastanza a lungo
   */
  function hasMinViewabilityTime(adUnitCode) {
    const firstView = state.viewabilityTimers[adUnitCode];
    if (!firstView) return false;

    const timeVisible = Date.now() - firstView;
    return timeVisible >= state.config.minViewabilityTime;
  }

  // ============================================================================
  // VIEWABILITY TRACKING
  // ============================================================================

  /**
   * Setup IntersectionObserver per trackare viewability
   */
  function setupViewabilityObserver(adUnitCode) {
    const element = document.getElementById(adUnitCode);
    if (!element) {
      log(`Elemento non trovato: ${adUnitCode}`);
      return;
    }

    // Crea observer con threshold
    const observer = new IntersectionObserver(
      function(entries) {
        entries.forEach(function(entry) {
          const isVisible = entry.intersectionRatio >= (state.config.viewabilityThreshold / 100);

          if (isVisible) {
            onSlotVisible(adUnitCode);
          } else {
            onSlotHidden(adUnitCode);
          }
        });
      },
      {
        threshold: [0, 0.25, 0.5, 0.75, 1.0]
      }
    );

    observer.observe(element);
    state.observers[adUnitCode] = observer;

    log(`Viewability observer setup per: ${adUnitCode}`);
  }

  /**
   * Chiamato quando slot diventa visibile
   */
  function onSlotVisible(adUnitCode) {
    log(`Slot visible: ${adUnitCode}`);

    // Traccia primo momento di visibilità
    if (!state.viewabilityTimers[adUnitCode]) {
      state.viewabilityTimers[adUnitCode] = Date.now();
      log(`Timer viewability iniziato per: ${adUnitCode}`);
    }

    // Avvia refresh automatico se eleggibile
    if (!state.activeTimers[adUnitCode] && canRefresh(adUnitCode)) {
      startAutoRefresh(adUnitCode);
    }
  }

  /**
   * Chiamato quando slot non è più visibile
   */
  function onSlotHidden(adUnitCode) {
    log(`Slot hidden: ${adUnitCode}`);

    // Ferma refresh automatico
    stopAutoRefresh(adUnitCode);

    // Reset timer viewability
    delete state.viewabilityTimers[adUnitCode];
  }

  // ============================================================================
  // AUTO REFRESH
  // ============================================================================

  /**
   * Avvia refresh automatico per uno slot
   */
  function startAutoRefresh(adUnitCode) {
    if (state.activeTimers[adUnitCode]) {
      log(`Refresh già attivo per: ${adUnitCode}`);
      return;
    }

    if (!canRefresh(adUnitCode)) {
      log(`Max refresh raggiunto per: ${adUnitCode}`);
      return;
    }

    log(`Avvio auto-refresh per: ${adUnitCode} (intervallo: ${state.config.refreshInterval}ms)`);

    const intervalId = setInterval(function() {
      refreshSlot(adUnitCode);
    }, state.config.refreshInterval);

    state.activeTimers[adUnitCode] = intervalId;
  }

  /**
   * Ferma refresh automatico per uno slot
   */
  function stopAutoRefresh(adUnitCode) {
    const intervalId = state.activeTimers[adUnitCode];
    if (intervalId) {
      clearInterval(intervalId);
      delete state.activeTimers[adUnitCode];
      log(`Auto-refresh fermato per: ${adUnitCode}`);
    }
  }

  /**
   * Refresh singolo slot
   */
  function refreshSlot(adUnitCode) {
    // Verifica condizioni
    if (!canRefresh(adUnitCode)) {
      log(`Max refresh raggiunto per: ${adUnitCode}`);
      stopAutoRefresh(adUnitCode);
      return;
    }

    if (!hasMinViewabilityTime(adUnitCode)) {
      log(`Viewability time minimo non raggiunto per: ${adUnitCode}`);
      return;
    }

    // Incrementa counter
    state.refreshCounters[adUnitCode] = (state.refreshCounters[adUnitCode] || 0) + 1;

    log(`Refreshing slot: ${adUnitCode} (count: ${state.refreshCounters[adUnitCode]})`);

    // Refresh con Prebid + GAM
    if (typeof pbjs !== 'undefined' && pbjs.requestBids) {
      pbjs.requestBids({
        timeout: 2000,
        adUnitCodes: [adUnitCode],
        bidsBackHandler: function() {
          log(`Bid ricevute per: ${adUnitCode}`);

          // Applica targeting a GAM
          pbjs.setTargetingForGPTAsync([adUnitCode]);

          // Refresh slot GAM
          if (typeof googletag !== 'undefined') {
            googletag.cmd.push(function() {
              const slots = googletag.pubads().getSlots().filter(function(slot) {
                return slot.getSlotElementId() === adUnitCode;
              });

              if (slots.length > 0) {
                googletag.pubads().refresh(slots);
                log(`GAM slot refreshed: ${adUnitCode}`);
              }
            });
          }
        }
      });
    }

    // Dispatch evento
    window.dispatchEvent(new CustomEvent('adhub:refresh', {
      detail: {
        adUnitCode: adUnitCode,
        refreshCount: state.refreshCounters[adUnitCode]
      }
    }));
  }

  // ============================================================================
  // PUBLIC API
  // ============================================================================

  /**
   * Inizializza il modulo refresh
   */
  function init(config) {
    if (state.initialized) {
      log('Già inizializzato');
      return;
    }

    // Merge config
    if (config) {
      Object.assign(state.config, config);
    }

    // Debug mode da URL
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('debug') === 'refresh') {
      state.config.debug = true;
    }

    state.initialized = true;

    log('✅ Modulo Refresh inizializzato', state.config);

    // Setup viewability observers per slot eleggibili
    state.config.eligibleSlots.forEach(function(adUnitCode) {
      setupViewabilityObserver(adUnitCode);
    });

    // Dispatch evento
    window.dispatchEvent(new CustomEvent('adhub:refresh:ready'));
  }

  /**
   * Abilita refresh per uno slot specifico
   */
  function enableSlot(adUnitCode) {
    if (state.config.eligibleSlots.indexOf(adUnitCode) === -1) {
      state.config.eligibleSlots.push(adUnitCode);
      setupViewabilityObserver(adUnitCode);
      log(`Refresh abilitato per: ${adUnitCode}`);
    }
  }

  /**
   * Disabilita refresh per uno slot specifico
   */
  function disableSlot(adUnitCode) {
    stopAutoRefresh(adUnitCode);

    const index = state.config.eligibleSlots.indexOf(adUnitCode);
    if (index !== -1) {
      state.config.eligibleSlots.splice(index, 1);
    }

    // Cleanup observer
    if (state.observers[adUnitCode]) {
      state.observers[adUnitCode].disconnect();
      delete state.observers[adUnitCode];
    }

    log(`Refresh disabilitato per: ${adUnitCode}`);
  }

  /**
   * Forza refresh immediato
   */
  function forceRefresh(adUnitCode) {
    if (!isEligible(adUnitCode)) {
      error(`Slot non eleggibile: ${adUnitCode}`);
      return;
    }

    refreshSlot(adUnitCode);
  }

  /**
   * Reset counter per uno slot
   */
  function resetCounter(adUnitCode) {
    state.refreshCounters[adUnitCode] = 0;
    log(`Counter reset per: ${adUnitCode}`);
  }

  /**
   * Ferma tutti i refresh
   */
  function stopAll() {
    Object.keys(state.activeTimers).forEach(function(adUnitCode) {
      stopAutoRefresh(adUnitCode);
    });
    log('Tutti i refresh fermati');
  }

  // Export API pubblica
  window.AdHubRefresh = {
    init: init,
    enableSlot: enableSlot,
    disableSlot: disableSlot,
    forceRefresh: forceRefresh,
    resetCounter: resetCounter,
    stopAll: stopAll,
    getState: function() {
      return {
        initialized: state.initialized,
        refreshCounters: {...state.refreshCounters},
        eligibleSlots: [...state.config.eligibleSlots]
      };
    },
    getConfig: function() {
      return {...state.config};
    },
    setConfig: function(config) {
      Object.assign(state.config, config);
      log('Config aggiornata:', state.config);
    }
  };

  console.log('[AdHubRefresh] ✅ Modulo caricato (versione 1.0.0)');

})();

// From: adhub-video-auto-init.js
/**
 * AdHub Video & Playlist Auto-Init
 *
 * Inizializza automaticamente video players e playlists in base agli attributi HTML.
 *
 * VIDEO PLAYER (Single Ad):
 * <div id="adhub-video-sticky-left" data-adhub-video="sticky-left"></div>
 * <div id="adhub-video-sticky-right" data-adhub-video="sticky-right"></div>
 * <div id="adhub-video-in-article" data-adhub-video="in-article"></div>
 *
 * VIDEO PLAYLIST:
 * <div id="my-playlist" data-adhub-playlist="sticky-left" data-playlist-code="viral"></div>
 * <div id="my-playlist" data-adhub-playlist="sticky-right" data-playlist-code="news"></div>
 * <div id="my-playlist" data-adhub-playlist="in-content" data-playlist-code="gossip"></div>
 *
 * Attributi opzionali:
 * - data-enable-ads="true|false"  (default: true)
 * - data-autoplay="true|false"     (default: true per sticky, false per in-content)
 *
 * @version 1.0.0
 * @date 2024-11-04
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.__adHubVideoAutoInitLoaded) {
    console.warn('[AdHub Video Auto-Init] Already loaded - Skip');
    return;
  }
  window.__adHubVideoAutoInitLoaded = true;

  // Stato inizializzazione
  const state = {
    initialized: false,
    videoPlayersInitialized: [],
    playlistsInitialized: []
  };

  /**
   * Inizializza video players automaticamente
   */
  function initVideoPlayers() {
    // Cerca tutti gli elementi con data-adhub-video
    const videoElements = document.querySelectorAll('[data-adhub-video]');

    if (videoElements.length === 0) {
      console.log('[AdHub Video Auto-Init] No ad-only video players found');
      return;
    }

    console.log('[AdHub Video Auto-Init] Found ' + videoElements.length + ' ad-only video player(s)');

    // Trova l'API della playlist da usare (es. AdHubMediaPlaylist)
    const playlistAPI = findPlaylistAPI();
    if (!playlistAPI) {
      console.error('[AdHub Video Auto-Init] No Playlist API found - cannot initialize ad-only video players');
      return;
    }

    videoElements.forEach(function(element) {
      const videoType = element.getAttribute('data-adhub-video');
      const elementId = element.id || 'adhub-video-' + Math.random().toString(36).substr(2, 9);

      if (!element.id) {
        element.id = elementId;
      }

      if (state.videoPlayersInitialized.indexOf(elementId) !== -1) {
        console.log('[AdHub Video Auto-Init] Ad-only video player already initialized:', elementId);
        return;
      }

      console.log('[AdHub Video Auto-Init] Initializing ad-only video player:', elementId, 'type:', videoType);

      try {
        // Leggi attributi custom
        const customWidth = element.getAttribute('data-width') || null;
        const customHeight = element.getAttribute('data-height') || null;

        const options = {
          adOnly: true, // <-- MODALITÀ SOLO-AD
          enableAds: true // Forzato a true
        };

        // Aggiungi dimensioni custom se specificate
        if (customWidth) {
          options.width = customWidth;
          console.log('[AdHub Video Auto-Init] Custom width:', customWidth);
        }
        if (customHeight) {
          options.height = customHeight;
          console.log('[AdHub Video Auto-Init] Custom height:', customHeight);
        }

        // Inizializza in base al tipo
        switch (videoType) {
          case 'sticky-left':
            playlistAPI.showStickyPlaylist('left', options);
            break;

          case 'sticky-right':
            playlistAPI.showStickyPlaylist('right', options);
            break;

          case 'in-article':
          case 'in-content':
            playlistAPI.showInContentPlaylist(elementId, options);
            break;

          default:
            console.warn('[AdHub Video Auto-Init] Unknown ad-only video type:', videoType);
            return;
        }

        state.videoPlayersInitialized.push(elementId);
        console.log('[AdHub Video Auto-Init] ✅ Ad-only video player initialized:', elementId);

      } catch (error) {
        console.error('[AdHub Video Auto-Init] Error initializing ad-only video player:', elementId, error);
      }
    });
  }

  /**
   * Trova una API per playlist disponibile (es. AdHubMediaPlaylist)
   */
  function findPlaylistAPI() {
    // IMPORTANTE: Usa sempre AdHubMediaPlaylist se disponibile (è quella generica che funziona ovunque)
    let playlistAPI = null;

    // Prima prova AdHubMediaPlaylist (la libreria generica)
    if (typeof window.AdHubMediaPlaylist !== 'undefined') {
      playlistAPI = window.AdHubMediaPlaylist;
      console.log('[AdHub Video Auto-Init] Using AdHubMediaPlaylist (generic library)');
      return playlistAPI;
    }

    // Se non c'è, cerca altre API playlist specifiche del sito
    const possibleNames = [
      'ProfessioneMammaPlaylist',
      'DonneMagazinePlaylist',
      'ExamplePlaylist',
      'Finanzas24Playlist'
    ];

    for (let i = 0; i < possibleNames.length; i++) {
      if (typeof window[possibleNames[i]] !== 'undefined') {
        playlistAPI = window[possibleNames[i]];
        console.log('[AdHub Video Auto-Init] Using site-specific playlist:', possibleNames[i]);
        return playlistAPI;
      }
    }

    // Fallback: cerca qualsiasi oggetto window con "Playlist" nel nome
    if (!playlistAPI) {
      for (let key in window) {
        if (key.indexOf('Playlist') !== -1 && typeof window[key] === 'object' && window[key].showStickyPlaylist) {
          playlistAPI = window[key];
          console.log('[AdHub Video Auto-Init] Using fallback playlist:', key);
          return playlistAPI;
        }
      }
    }

    return null;
  }

  /**
   * Inizializza playlists automaticamente
   */
  function initPlaylists() {
    // Cerca elementi con data-adhub-playlist, data-video-url O con attributo playlist (retrocompatibilità)
    const newStyleElements = document.querySelectorAll('[data-adhub-playlist]');
    const videoUrlElements = document.querySelectorAll('[data-video-url]');
    const oldStyleElements = document.querySelectorAll('[playlist]:not([data-adhub-playlist])');

    const playlistElements = [];

    // Aggiungi nuovi elementi (data-adhub-playlist)
    for (let i = 0; i < newStyleElements.length; i++) {
      playlistElements.push(newStyleElements[i]);
    }

    // Aggiungi elementi con data-video-url (se non già inclusi)
    for (let i = 0; i < videoUrlElements.length; i++) {
      if (playlistElements.indexOf(videoUrlElements[i]) === -1) {
        playlistElements.push(videoUrlElements[i]);
      }
    }

    // Aggiungi vecchi elementi (retrocompatibilità)
    for (let i = 0; i < oldStyleElements.length; i++) {
      playlistElements.push(oldStyleElements[i]);
    }

    if (playlistElements.length === 0) {
      console.log('[AdHub Video Auto-Init] No playlists found');
      return;
    }

    console.log('[AdHub Video Auto-Init] Found ' + playlistElements.length + ' playlist(s)');

    playlistElements.forEach(function(element) {
      // Supporta sia data-adhub-playlist (nuovo) che deduzione da ID/context (vecchio)
      let playlistPosition = element.getAttribute('data-adhub-playlist');

      // Leggi data-position se presente (priorità su data-adhub-playlist)
      const dataPosition = element.getAttribute('data-position');
      if (dataPosition) {
        playlistPosition = dataPosition;
      }

      // Retrocompatibilità: deduce posizione dall'ID o classe se non specificata
      if (!playlistPosition) {
        const elementId = element.id || '';
        const className = element.className || '';

        if (elementId.indexOf('sticky-left') !== -1 || className.indexOf('sticky-left') !== -1) {
          playlistPosition = 'sticky-left';
        } else if (elementId.indexOf('sticky-right') !== -1 || className.indexOf('sticky-right') !== -1) {
          playlistPosition = 'sticky-right';
        } else {
          playlistPosition = 'in-content'; // default
        }
      }

      // NUOVO: Leggi attributi opzionali e sovrascrivi posizione se necessario
      const stickyOption = element.getAttribute('data-sticky');
      if (stickyOption) {
        console.log(`[AdHub Video Auto-Init] Trovato data-sticky="${stickyOption}", che sovrascrive la posizione.`);
        if (stickyOption === 'left') {
          playlistPosition = 'sticky-left';
        } else if (stickyOption === 'right') {
          playlistPosition = 'sticky-right';
        } else if (stickyOption === 'none') {
          playlistPosition = 'in-content';
        }
      }

      // Supporta sia data-playlist-code (nuovo) che playlist (vecchio)
      const playlistCode = element.getAttribute('data-playlist-code') ||
                          element.getAttribute('playlist') ||
                          'viral';

      // NUOVO: Leggi data-video-url se presente
      const videoUrl = element.getAttribute('data-video-url') || null;

      // NUOVO: Leggi larghezza custom
      const customWidth = element.getAttribute('data-width') || null;

      const enableAds = element.getAttribute('data-enable-ads') !== 'false'; // default true
      const elementId = element.id || 'adhub-playlist-' + Math.random().toString(36).substr(2, 9);

      // Assegna ID se non presente
      if (!element.id) {
        element.id = elementId;
      }

      // Verifica se già inizializzato
      if (state.playlistsInitialized.indexOf(elementId) !== -1) {
        console.log('[AdHub Video Auto-Init] Playlist already initialized:', elementId);
        return;
      }

      if (videoUrl) {
        console.log('[AdHub Video Auto-Init] Initializing video player:', elementId, 'position:', playlistPosition, 'videoUrl:', videoUrl);
      } else {
        console.log('[AdHub Video Auto-Init] Initializing playlist:', elementId, 'position:', playlistPosition, 'code:', playlistCode);
      }

      // Determina il nome della API playlist per il sito corrente
      const playlistAPI = findPlaylistAPI();

      // Prepare options object
      const options = {
        playlist: playlistCode,
        enableAds: enableAds
      };

      // NUOVO: Aggiungi videoUrl e customWidth se presenti
      if (videoUrl) {
        options.videoUrl = videoUrl;
      }
      if (customWidth) {
        options.width = customWidth;
      }

      try {
        // Se non c'è un wrapper site-specific, usa direttamente AdHubVideoPlaylist
        if (!playlistAPI) {
          console.warn('[AdHub Video Auto-Init] No site-specific Playlist API found, using generic AdHubVideoPlaylist directly');

          if (!window.AdHubVideoPlaylist || typeof window.AdHubVideoPlaylist.createPlaylist !== 'function') {
            console.error('[AdHub Video Auto-Init] AdHubVideoPlaylist.createPlaylist not available');
            return;
          }

          // Per tutte le posizioni, usa createPlaylist direttamente
          const createOptions = {
            ...options,
            position: playlistPosition,
            enableAds: options.enableAds !== false
          };

          console.log('[AdHub Video Auto-Init] Calling AdHubVideoPlaylist.createPlaylist with:', elementId, createOptions);
          window.AdHubVideoPlaylist.createPlaylist(elementId, createOptions);

          // Segna come inizializzato
          state.playlistsInitialized.push(elementId);
          console.log('[AdHub Video Auto-Init] ✅ Playlist initialized:', elementId);
          return;
        }

        // Se c'è un wrapper site-specific, usalo
        switch (playlistPosition) {
          case 'sticky-left':
            playlistAPI.showStickyPlaylist('left', options);
            break;

          case 'sticky-right':
            playlistAPI.showStickyPlaylist('right', options);
            break;

          case 'in-content':
          case 'in-article':
            // Check if showInContentPlaylist exists (site-specific wrapper)
            if (typeof playlistAPI.showInContentPlaylist === 'function') {
              playlistAPI.showInContentPlaylist(elementId, options);
            } else {
              console.error('[AdHub Video Auto-Init] Site-specific API found but missing showInContentPlaylist function');
              return;
            }
            break;

          default:
            console.warn('[AdHub Video Auto-Init] Unknown playlist position:', playlistPosition);
            return;
        }

        // Segna come inizializzato
        state.playlistsInitialized.push(elementId);
        console.log('[AdHub Video Auto-Init] ✅ Playlist initialized:', elementId);

      } catch (error) {
        console.error('[AdHub Video Auto-Init] Error initializing playlist:', elementId, error);
      }
    });
  }

  /**
   * Inizializza tutto
   */
  function init() {
    if (state.initialized) {
      console.warn('[AdHub Video Auto-Init] Already initialized');
      return;
    }

    console.log('[AdHub Video Auto-Init] 🚀 Starting auto-initialization...');

    // Inizializza video players
    initVideoPlayers();

    // Inizializza playlists
    initPlaylists();

    state.initialized = true;

    // Emetti evento
    const event = new CustomEvent('adhub:video:auto-init:complete', {
      detail: {
        videoPlayers: state.videoPlayersInitialized.length,
        playlists: state.playlistsInitialized.length
      }
    });
    window.dispatchEvent(event);

    console.log('[AdHub Video Auto-Init] ✅ Auto-initialization complete');
    console.log('[AdHub Video Auto-Init] Video players:', state.videoPlayersInitialized.length);
    console.log('[AdHub Video Auto-Init] Playlists:', state.playlistsInitialized.length);
  }

  /**
   * Attendi che il sistema AdHub sia pronto
   */
  function waitForAdHub() {
    // Verifica se AdHub è già pronto
    if (window.__adHubReady) {
      init();
      return;
    }

    // Se i moduli necessari sono già disponibili, inizializza comunque
    // Questo è importante per siti che non emettono adhub:ready
    if (window.AdHubVideo && (window.AdHubMediaPlaylist || window.AdHubVideoPlaylist)) {
      console.log('[AdHub Video Auto-Init] Modules available, initializing without adhub:ready event');
      // Marca come pronto per evitare doppia inizializzazione
      window.__adHubReady = true;
      init();
      return;
    }

    // Ascolta evento ready (potrebbe non arrivare mai)
    window.addEventListener('adhub:ready', function() {
      // Delay di 500ms per assicurarsi che tutti i moduli siano caricati
      setTimeout(init, 500);
    });

    // Fallback: controlla periodicamente se i moduli sono disponibili
    let checkCount = 0;
    const checkInterval = setInterval(function() {
      checkCount++;

      if (window.__adHubReady || (window.AdHubVideo && (window.AdHubMediaPlaylist || window.AdHubVideoPlaylist))) {
        clearInterval(checkInterval);
        console.log('[AdHub Video Auto-Init] Modules available after ' + checkCount + ' checks');
        if (!window.__adHubReady) {
          window.__adHubReady = true;
        }
        init();
      } else if (checkCount > 20) { // Max 10 secondi (20 * 500ms)
        clearInterval(checkInterval);
        console.warn('[AdHub Video Auto-Init] Timeout waiting for modules');
      }
    }, 500);
  }

  /**
   * Re-scan sicuro al DOMContentLoaded
   * Rileva elementi video/playlist inseriti DOPO l'init iniziale
   * ma presenti quando il DOM è completo
   */
  function performDOMReadyRescan() {
    console.log('[AdHub Video Auto-Init] 🔄 DOMContentLoaded - Re-scanning for new elements...');

    // Re-scan solo se già inizializzato
    if (state.initialized) {
      // Conta elementi prima del re-scan
      const videoPlayersBefore = state.videoPlayersInitialized.length;
      const playlistsBefore = state.playlistsInitialized.length;

      // Esegui re-scan (rileva solo nuovi elementi grazie al check su state.playlistsInitialized)
      initVideoPlayers();
      initPlaylists();

      // Conta elementi dopo il re-scan
      const videoPlayersAfter = state.videoPlayersInitialized.length;
      const playlistsAfter = state.playlistsInitialized.length;

      const newVideoPlayers = videoPlayersAfter - videoPlayersBefore;
      const newPlaylists = playlistsAfter - playlistsBefore;

      if (newVideoPlayers > 0 || newPlaylists > 0) {
        console.log('[AdHub Video Auto-Init] ✅ DOMContentLoaded re-scan found:');
        console.log('  - New video players:', newVideoPlayers);
        console.log('  - New playlists:', newPlaylists);

        // Emetti evento per i nuovi elementi
        window.dispatchEvent(new CustomEvent('adhub:video:auto-init:rescan-complete', {
          detail: {
            newVideoPlayers: newVideoPlayers,
            newPlaylists: newPlaylists,
            totalVideoPlayers: videoPlayersAfter,
            totalPlaylists: playlistsAfter
          }
        }));
      } else {
        console.log('[AdHub Video Auto-Init] ℹ️ DOMContentLoaded re-scan: no new elements found');
      }
    }
  }

  // Auto-init quando DOM è pronto
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', waitForAdHub);
  } else {
    waitForAdHub();
  }

  // Re-scan aggiuntivo al DOMContentLoaded (dopo init)
  // Questo cattura elementi che erano già nel DOM ma non ancora processati
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function() {
      // Aspetta 1 secondo dopo DOMContentLoaded per dare tempo all'init
      setTimeout(performDOMReadyRescan, 1000);
    });
  } else if (document.readyState === 'interactive' || document.readyState === 'complete') {
    // Se il DOM è già pronto, esegui re-scan subito (con delay)
    setTimeout(performDOMReadyRescan, 1000);
  }

  // Export API (opzionale per debug)
  window.AdHubVideoAutoInit = {
    state: state,
    init: init,
    initVideoPlayers: initVideoPlayers,
    initPlaylists: initPlaylists,

    // Helper per re-scan (utile per SPA)
    rescan: function() {
      console.log('[AdHub Video Auto-Init] Re-scanning DOM...');
      initVideoPlayers();
      initPlaylists();
    }
  };

  console.log('[AdHub Video Auto-Init] ✅ Module loaded');

})();

// From: adhub-video.js
/**
 * AdHub Video Module (Compatibility Wrapper)
 *
 * Questo modulo è un wrapper per garantire retrocompatibilità con il più nuovo
 * AdHubVideoPlaylist. Tutta la logica è ora centralizzata in AdHubVideoPlaylist.
 * Questo modulo mappa le vecchie chiamate a AdHubVideo verso il nuovo sistema.
 *
 * @version 2.0.0
 * @date 2025-11-13
 */
(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.AdHubVideo && window.AdHubVideo.isWrapper) {
    console.warn('[AdHubVideo] Wrapper già caricato');
    return;
  }

  function log(...args) {
    const config = window.AdHubVideoPlaylist ? window.AdHubVideoPlaylist.getConfig() : {};
    if (config.debug) {
      console.log('[AdHubVideo Wrapper]', ...args);
    }
  }

  function error(...args) {
    console.error('[AdHubVideo Wrapper]', ...args);
  }

  // Verifica che il modulo principale (AdHubVideoPlaylist) sia disponibile
  function checkPlaylistModule() {
    if (typeof window.AdHubVideoPlaylist === 'undefined') {
      error('Il modulo principale AdHubVideoPlaylist non è caricato. Il wrapper AdHubVideo non può funzionare.');
      return false;
    }
    return true;
  }

  // Mappa i player creati per ad-unit code
  const playerMap = new Map();

  window.AdHubVideo = {
    isWrapper: true,

    init: function(config = {}) {
      log('init() chiamato. La configurazione viene gestita da AdHubVideoPlaylist.');
      if (checkPlaylistModule() && !window.AdHubVideoPlaylist.isInitialized()) {
        window.AdHubVideoPlaylist.init(config);
      }
    },

    createPlayer: function(adUnitCode, options = {}) {
      log(`createPlayer() per ${adUnitCode}. Mappato a AdHubVideoPlaylist.createPlaylist.`);
      if (!checkPlaylistModule()) return null;

      const targetElement = document.getElementById(adUnitCode);
      if (!targetElement) {
        error(`Elemento DOM non trovato: ${adUnitCode}`);
        return null;
      }

      const playlistOptions = {
        ...options,
        adOnly: true,
        enableAds: true,
        position: options.position || 'in-content'
      };

      // AdHubVideoPlaylist.createPlaylist è asincrono
      const promise = window.AdHubVideoPlaylist.createPlaylist(adUnitCode, playlistOptions)
        .then(playerInstance => {
          if (playerInstance) {
            playerMap.set(adUnitCode, playerInstance);
            log(`Player ${adUnitCode} creato e mappato.`, playerInstance);
            return playerInstance;
          }
          return null;
        });

      // Per retrocompatibilità, non possiamo restituire una promise.
      // Restituiamo un oggetto placeholder. La logica che dipende dall'istanza
      // del player dovrà essere asincrona.
      const placeholder = { adUnitCode, isPlaceholder: true, promise };
      playerMap.set(adUnitCode, placeholder);
      return placeholder;
    },

    loadVast: function(adUnitCode, vastUrl) {
      log(`loadVast() per ${adUnitCode}. Questa funzione è ora deprecata.`);
      log('Il VAST URL dovrebbe essere gestito tramite Prebid o adRequestCallback.');
      // In un sistema a playlist, il VAST viene caricato da playAd(), non manualmente.
      // Se il player è stato creato, il processo di caricamento ad è già in corso.
      const player = playerMap.get(adUnitCode);
      if (!player) {
        error('loadVast chiamato per un player non esistente:', adUnitCode);
        return;
      }
      // Non c'è un'azione diretta da compiere qui perché il flusso è cambiato.
      // Aggiungiamo solo un log per notificare.
      console.warn('[AdHubVideo Wrapper] loadVast() è deprecato e non ha più effetto diretto. Il caricamento degli annunci è automatico.');
    },

    closePlayer: function(adUnitCode) {
      log(`closePlayer() per ${adUnitCode}. Mappato a AdHubVideoPlaylist.closePlaylist.`);
      if (checkPlaylistModule()) {
        window.AdHubVideoPlaylist.closePlaylist(adUnitCode);
        playerMap.delete(adUnitCode);
      }
    },

    closeAllPlayers: function() {
      log('closeAllPlayers(). Mappato a AdHubVideoPlaylist.closeAllPlaylists.');
      if (checkPlaylistModule()) {
        window.AdHubVideoPlaylist.closeAllPlaylists();
        playerMap.clear();
      }
    },

    fireVideoEvent: function(adUnitCode, eventType, data) {
      log(`fireVideoEvent() per ${adUnitCode}. Evento: ${eventType}. Deprecato.`);
      // La gestione degli eventi è ora interna a AdHubVideoPlaylist
    },

    getPlayer: function(adUnitCode) {
      log(`getPlayer() per ${adUnitCode}.`);
      return playerMap.get(adUnitCode);
    },

    getAllPlayers: function() {
      log('getAllPlayers().');
      return Array.from(playerMap.values());
    },

    getConfig: function() {
      log('getConfig().');
      if (checkPlaylistModule()) {
        return window.AdHubVideoPlaylist.getConfig();
      }
      return {};
    },

    setConfig: function(config) {
      log('setConfig().');
      if (checkPlaylistModule()) {
        window.AdHubVideoPlaylist.setConfig(config);
      }
    },

    isInitialized: function() {
      if (checkPlaylistModule()) {
        return window.AdHubVideoPlaylist.isInitialized();
      }
      return false;
    },

    isMobile: function() {
      if (checkPlaylistModule()) {
        return window.AdHubVideoPlaylist.isMobile();
      }
      return window.innerWidth < 768;
    }
  };

  console.log('[AdHubVideo] ✅ Wrapper di compatibilità caricato. Usa AdHubVideoPlaylist per nuove implementazioni.');

})();

/**
 * Le animazioni CSS sono ora gestite da AdHubVideoPlaylist,
 * quindi questo blocco non è più necessario qui.
 */

// From: adhub-video-playlist.js
/**
 * AdHub Video Playlist Module
 *
 * Gestisce playlist di video content con integrazione ads VAST/VPAID:
 * - Caricamento playlist da API XML o URL video diretto
 * - Riproduzione sequenziale/casuale
 * - Inserimento ads tra i video content (pre-roll, mid-roll)
 * - Supporto per sticky e in-content positioning
 * - Gestione coda video e transizioni
 *
 * USO CON URL VIDEO DIRETTO:
 * HTML: <div id="my-video" data-video-url="https://example.com/video.mp4"></div>
 * JS: AdHubVideoPlaylist.createPlaylist('my-video', { videoUrl: 'https://example.com/video.mp4' })
 *
 * @version 1.1.0
 * @date 2025-11-13
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.AdHubVideoPlaylist) {
    console.warn('[AdHubVideoPlaylist] Modulo già caricato');
    return;
  }

  // ============================================================================
  // CONFIGURAZIONE
  // ============================================================================

  const DEFAULT_CONFIG = {
    // API endpoint
    apiEndpoint: 'https://static.4wnetwork.com/asset/api/playlist.php',
    apiKey: 'Y2Q0MjgyYTZhNzgxM2E1ODRlN2MxNTE',

    // Playlist settings
    defaultPlaylist: 'viral', // actualidad, gossip, viral, news, donnemagazine
    shuffle: true, // Ordine casuale (già fatto dal server)
    autoPlay: true,
    loop: true, // Riparti dall'inizio quando finiscono i video

    // Ads integration
    enableAds: true,
    preRoll: true, // Ad prima del primo video
    midRoll: true, // Ad tra i video
    midRollFrequency: 1, // Un ad ogni X video content (1 = tra ogni video)
    postRoll: false, // Ad finale (opzionale)
    skipAdIfNoBid: false, // Se true, skip ad se Prebid non ritorna bid

    // Audio strategy - prova prima con audio on (CPM più alto)
    preferUnmutedAds: true, // Prova prima a richiedere ads con audio attivo
    fallbackToMutedAds: true, // Se no bid, riprova con audio mutato
    startMuted: 'auto', // 'auto' | true | false - 'auto' = basato sul bid ricevuto

    // VAST fallback URL (GAM) quando Prebid non ritorna bid
    // Default: AdhubMedia_RON (multi-size, tutti i siti)
    // Può essere sovrascritto da config site-specific
    vastFallbackUrl: 'https://pubads.g.doubleclick.net/gampad/ads?' +
      'sz=300x250|400x300|728x90|120x600|320x100|320x50|336x280|640x480|300x600|970x250' +
      '&iu=/131207395/AdhubMedia_RON' +
      '&env=vp&impl=s&gdfp_req=1&output=vast&unviewed_position_start=1' +
      '&url=[referrer_url]&description_url=[description_url]&correlator=[timestamp]',

    // Player settings
    controls: false,  // Disabilita controlli nativi HTML5
    showProgress: true,
    showPlaylist: false, // Mostra lista video (opzionale)
    showMuteButton: true,  // Mostra solo bottone mute/unmute

    // UI
    showTitle: true,
    showNextButton: true,
    closeDelay: 5, // secondi prima di mostrare close button

    // Auto-init from DOM
    autoInitFromDOM: true, // Inizializza automaticamente dai div con data-adhub-playlist

    // Debug
    debug: false
  };

  // ============================================================================
  // STATE MANAGEMENT
  // ============================================================================

  const state = {
    playlists: new Map(), // Map<playerId, playlistInstance>
    config: {...DEFAULT_CONFIG},
    initialized: false
  };

  // ============================================================================
  // UTILITY FUNCTIONS
  // ============================================================================

  function log(...args) {
    if (state.config.debug) {
      console.log('[AdHubVideoPlaylist]', ...args);
    }
  }

  function error(...args) {
    console.error('[AdHubVideoPlaylist]', ...args);
  }

  function isMobile() {
    return window.innerWidth < 768;
  }

  /**
   * Carica Google IMA SDK
   */
  function loadImaSDK() {
    return new Promise((resolve, reject) => {
      // Se già caricato, return
      if (typeof google !== 'undefined' && google.ima) {
        log('IMA SDK già caricato');
        resolve();
        return;
      }

      // Se già in loading, aspetta
      if (window.__imaSDKLoading) {
        log('IMA SDK già in loading...');
        const checkInterval = setInterval(() => {
          if (typeof google !== 'undefined' && google.ima) {
            clearInterval(checkInterval);
            resolve();
          }
        }, 100);
        return;
      }

      window.__imaSDKLoading = true;
      log('Caricamento IMA SDK...');

      const script = document.createElement('script');
      script.src = 'https://imasdk.googleapis.com/js/sdkloader/ima3.js';
      script.async = true;

      script.onload = () => {
        log('✅ IMA SDK caricato');
        window.__imaSDKLoading = false;
        resolve();
      };

      script.onerror = () => {
        error('❌ Errore caricamento IMA SDK');
        window.__imaSDKLoading = false;
        reject(new Error('Failed to load IMA SDK'));
      };

      document.head.appendChild(script);
    });
  }

  // ============================================================================
  // API FUNCTIONS
  // ============================================================================

  /**
   * Carica playlist dall'API PHP o da URL diretto
   */
  async function loadPlaylistFromAPI(playlistCode, videoUrl = null) {
    // Se è stato passato un videoUrl diretto, crea una playlist con quel singolo video
    if (videoUrl) {
      log('Caricamento video diretto da URL:', videoUrl);

      // Estrai nome file dall'URL per usarlo come titolo
      const videoName = videoUrl.split('/').pop().split('?')[0].replace(/\.[^/.]+$/, "");

      return [{
        id: 'direct-video-0',
        name: videoName || 'Video',
        description: '',
        thumbnail: '',
        videoUrl: videoUrl,
        dataUrl: '',
        duration: 60,
        width: 640,
        height: 480,
        updatedAt: new Date().toISOString()
      }];
    }

    log('Caricamento playlist da dati statici:', playlistCode);

    try {
      // Usa dati statici invece di chiamare API esterna
      if (!window.AdHubVideoPlaylistsData) {
        throw new Error('AdHubVideoPlaylistsData non caricato');
      }

      const playlistData = window.AdHubVideoPlaylistsData.getPlaylist(playlistCode);

      if (!playlistData) {
        throw new Error(`Playlist "${playlistCode}" non trovata`);
      }

      // Converti formato dati statici in formato playlist interno
      const videos = playlistData.videos.map((video, index) => ({
        id: `${playlistCode}-${index}`,
        name: video.name,
        description: video.description || '',
        thumbnail: video.thumbnail || '',
        videoUrl: video.url,
        dataUrl: '',
        duration: video.duration || 60,
        width: 640,
        height: 480,
        updatedAt: new Date().toISOString()
      }));

      log(`Playlist caricata: ${videos.length} video`);
      return videos;

    } catch (err) {
      error('Errore caricamento playlist:', err);
      throw err;
    }
  }

  // ============================================================================
  // PLAYLIST CREATION
  // ============================================================================

  /**
   * Crea container per playlist player
   */
  function createPlaylistContainer(playerId, position, config) {
    const container = document.createElement('div');
    container.id = `adhub-playlist-${playerId}`;
    container.className = 'adhub-playlist-container';
    container.setAttribute('data-position', position);
    container.setAttribute('data-player-id', playerId);

    const stickyStyles = position.startsWith('sticky-')
      ? getPositionStyles(position)
      : 'position: relative; margin: 20px auto;';

    let sizeStyles;
    if (config && config.width) {
      const widthValue = /^\d+$/.test(config.width) ? `${config.width}px` : config.width;
      sizeStyles = `
        max-width: ${widthValue};
        width: 100%;
        aspect-ratio: 16 / 9;
        height: auto;
      `;
    } else {
      const size = isMobile()
        ? { width: 400, height: 300 }
        : { width: 640, height: 480 };
      sizeStyles = `
        width: ${size.width}px;
        height: ${size.height}px;
      `;
    }

    container.style.cssText = `
      ${sizeStyles}
      background: #000;
      overflow: hidden;
      border-radius: 8px;
      ${stickyStyles}
    `;

    return container;
  }

  /**
   * Ottieni stili CSS in base alla posizione
   */
  function getPositionStyles(position) {
    const offset = 20;

    switch(position) {
      case 'sticky-bottom-left':
        return `
          position: fixed;
          bottom: ${offset}px;
          left: ${offset}px;
          z-index: 9999;
          box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        `;

      case 'sticky-bottom-right':
        return `
          position: fixed;
          bottom: ${offset}px;
          right: ${offset}px;
          z-index: 9999;
          box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        `;

      default:
        return 'position: relative;';
    }
  }

  /**
   * Crea video element HTML5
   */
  function createVideoElement(container, playerId) {
    const videoEl = document.createElement('video');
    videoEl.id = `adhub-playlist-video-${playerId}`;
    videoEl.className = 'adhub-playlist-video';
    videoEl.style.cssText = `
      width: 100%;
      height: 100%;
      object-fit: contain;
      background: #000;
    `;

    if (state.config.controls) {
      videoEl.controls = true;
    }

    if (state.config.autoPlay) {
      videoEl.autoplay = true;

      // Determina stato mute iniziale basato su config
      if (state.config.startMuted === 'auto') {
        // Auto: parte muted, poi si attiva in base al bid ricevuto
        videoEl.muted = true;
      } else {
        videoEl.muted = state.config.startMuted === true;
      }
    }

    container.appendChild(videoEl);
    return videoEl;
  }

  /**
   * Crea overlay per ads
   */
  function createAdsOverlay(container, playerId) {
    const overlay = document.createElement('div');
    overlay.id = `adhub-playlist-ads-${playerId}`;
    overlay.className = 'adhub-playlist-ads-overlay';
    overlay.style.cssText = `
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: #000;
      display: none;
      z-index: 10;
    `;

    container.appendChild(overlay);
    return overlay;
  }

  /**
   * Crea UI overlay (titolo, controlli, progress)
   */
  function createUIOverlay(container, playerId, adOnly = false) {
    const overlay = document.createElement('div');
    overlay.className = 'adhub-playlist-ui-overlay';
    overlay.style.cssText = `
      position: absolute;
      bottom: 0;
      left: 0;
      width: 100%;
      background: linear-gradient(transparent, rgba(0,0,0,0.8));
      padding: 15px;
      box-sizing: border-box;
      z-index: 20;
      display: flex;
      flex-direction: column;
      gap: 10px;
    `;

    // Titolo video (solo se non in modalità ad-only)
    if (state.config.showTitle && !adOnly) {
      const title = document.createElement('div');
      title.className = 'adhub-playlist-title';
      title.style.cssText = `
        color: #fff;
        font-size: 14px;
        font-weight: 500;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      `;
      overlay.appendChild(title);
    }

    // Progress bar (solo se non in modalità ad-only)
    if (state.config.showProgress && !adOnly) {
      const progressContainer = document.createElement('div');
      progressContainer.style.cssText = `
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 12px;
        color: #fff;
      `;

      const currentText = document.createElement('span');
      currentText.className = 'adhub-playlist-current';
      currentText.textContent = '1';

      const separator = document.createElement('span');
      separator.textContent = '/';

      const totalText = document.createElement('span');
      totalText.className = 'adhub-playlist-total';
      totalText.textContent = '0';

      progressContainer.appendChild(currentText);
      progressContainer.appendChild(separator);
      progressContainer.appendChild(totalText);

      overlay.appendChild(progressContainer);
    }

    // Next button (solo se non in modalità ad-only)
    if (state.config.showNextButton && !adOnly) {
      const nextBtn = document.createElement('button');
      nextBtn.className = 'adhub-playlist-next-btn';
      nextBtn.textContent = 'Next →';
      nextBtn.style.cssText = `
        background: rgba(255,255,255,0.2);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        padding: 8px 16px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 12px;
        transition: background 0.2s;
        align-self: flex-start;
      `;

      // Gli event listener saranno aggiunti in setupVideoEventListeners()

      overlay.appendChild(nextBtn);
    }

    // Mute/Unmute button
    if (state.config.showMuteButton) {
      const muteBtn = document.createElement('button');
      muteBtn.className = 'adhub-playlist-mute-btn';
      muteBtn.innerHTML = '🔊'; // Speaker icon (unmuted by default)
      muteBtn.setAttribute('aria-label', 'Mute/Unmute');
      muteBtn.style.cssText = `
        position: absolute;
        top: 15px;
        right: 50px;
        background: rgba(0,0,0,0.6);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        cursor: pointer;
        font-size: 16px;
        transition: all 0.2s;
        z-index: 30;
        display: flex;
        align-items: center;
        justify-content: center;
      `;

      // Gli event listener saranno aggiunti in setupVideoEventListeners()

      container.appendChild(muteBtn);
    }

    container.appendChild(overlay);
    return overlay;
  }

  /**
   * Crea close button
   */
  function createCloseButton(container, playerId) {
    const button = document.createElement('button');
    button.className = 'adhub-playlist-close';
    button.innerHTML = '&times;';
    button.setAttribute('aria-label', 'Chiudi playlist');

    button.style.cssText = `
      position: absolute;
      top: 8px;
      right: 8px;
      width: 32px;
      height: 32px;
      border: none;
      border-radius: 50%;
      background: rgba(0,0,0,0.7);
      color: #fff;
      font-size: 24px;
      line-height: 1;
      cursor: pointer;
      z-index: 30;
      transition: background 0.2s;
      display: none;
    `;

    // Salva riferimenti agli handler per cleanup
    button._handlers = {};

    button._handlers.mouseenter = () => {
      button.style.background = 'rgba(0,0,0,0.9)';
    };
    button.addEventListener('mouseenter', button._handlers.mouseenter);

    button._handlers.mouseleave = () => {
      button.style.background = 'rgba(0,0,0,0.7)';
    };
    button.addEventListener('mouseleave', button._handlers.mouseleave);

    button._handlers.click = () => {
      closePlaylist(playerId);
    };
    button.addEventListener('click', button._handlers.click);

    container.appendChild(button);

    // Mostra dopo delay
    setTimeout(() => {
      button.style.display = 'block';
    }, state.config.closeDelay * 1000);

    return button;
  }

  // ============================================================================
  // PLAYLIST MANAGEMENT
  // ============================================================================

  /**
   * Crea e inizializza playlist player
   */
  async function createPlaylist(playerId, options = {}) {
    log('Creazione playlist:', playerId, options);

    // Merge config
    const config = {
      ...state.config,
      ...options
    };

    // Se in modalità solo-ad, non caricare video content
    let videos = [];
    if (!config.adOnly) {
      // Carica playlist dall'API o da URL diretto
      const playlistCode = config.playlist || config.defaultPlaylist;
      const videoUrl = config.videoUrl || null; // Nuovo parametro per URL diretto
      videos = await loadPlaylistFromAPI(playlistCode, videoUrl);

      if (videos.length === 0) {
        error('Nessun video nella playlist');
        return null;
      }
    } else {
      log('Creazione player in modalità "ad-only"');
    }

    // Crea container
    const position = config.position || 'in-content';
    const container = createPlaylistContainer(playerId, position, config);

    // Per sticky, aggiungi al body; per in-content, cerca elemento target
    if (position.startsWith('sticky-')) {
      document.body.appendChild(container);
    } else {
      const targetElement = document.getElementById(playerId);
      if (targetElement) {
        targetElement.appendChild(container);
      } else {
        document.body.appendChild(container);
      }
    }

    // Crea elementi UI
    const videoElement = createVideoElement(container, playerId);
    const adsOverlay = createAdsOverlay(container, playerId);
    const uiOverlay = createUIOverlay(container, playerId, config.adOnly);
    const closeButton = createCloseButton(container, playerId);

    // Crea playlist instance
    const playlist = {
      playerId,
      container,
      videoElement,
      adsOverlay,
      uiOverlay,
      closeButton,
      position,
      config,

      // Playlist data
      playlistCode: config.adOnly ? 'ad-only' : (config.playlist || config.defaultPlaylist),
      videos,
      currentIndex: 0,
      videosPlayed: 0,

      // State
      isPlaying: false,
      isPlayingAd: false,
      isClosed: false,

      // Error handling
      errorCount: 0,
      maxErrors: 5,  // Massimo 5 tentativi prima di stop

      // Ad units
      adUnitCode: null,
      nextAdIndex: config.preRoll ? 0 : config.midRollFrequency
    };

    // Salva playlist
    state.playlists.set(playerId, playlist);

    // Setup event listeners
    setupVideoEventListeners(playlist);

    // Update UI
    updatePlaylistUI(playlist);

    // Animazione entrata
    container.style.opacity = '0';
    container.style.transform = position.startsWith('sticky-')
      ? 'translateY(20px)'
      : 'scale(0.95)';

    setTimeout(() => {
      container.style.transition = 'all 300ms ease-out';
      container.style.opacity = '1';
      container.style.transform = 'translateY(0) scale(1)';
    }, 10);

    log('Playlist creata:', playerId, `${videos.length} video`);

    // Start playback
    if (config.adOnly) {
      // Modalità solo-ad: riproduci subito un annuncio
      await playAd(playlist);
    } else if (config.enableAds && config.preRoll) {
      // Pre-roll ad prima del primo video
      await playAd(playlist);
    } else {
      // Carica primo video
      playVideoAtIndex(playlist, 0);
    }

    return playlist;
  }

  /**
   * Setup event listeners per video element
   */
  function setupVideoEventListeners(playlist) {
    const { videoElement, uiOverlay, playerId } = playlist;

    // Crea oggetto per salvare i riferimenti agli handler (per cleanup)
    playlist.eventHandlers = {};

    // Video ended - passa al prossimo
    playlist.eventHandlers.videoEnded = () => {
      log('Video terminato:', playlist.currentIndex);
      playlist.videosPlayed++;

      // Verifica se mostrare mid-roll ad
      if (playlist.config.enableAds &&
          playlist.config.midRoll &&
          playlist.videosPlayed >= playlist.nextAdIndex) {

        log('Mid-roll ad');
        playlist.nextAdIndex = playlist.videosPlayed + playlist.config.midRollFrequency;
        playAd(playlist);
      } else {
        // Prossimo video
        playNextVideo(playlist);
      }
    };
    videoElement.addEventListener('ended', playlist.eventHandlers.videoEnded);

    // Video error - Con limite di tentativi
    playlist.eventHandlers.videoError = (e) => {
      error('Errore riproduzione video:', e);
      playlist.errorCount++;

      // Check se raggiunto limite errori
      if (playlist.errorCount >= playlist.maxErrors) {
        error(`Raggiunto limite errori (${playlist.maxErrors}). Stop playlist.`);
        firePlaylistEvent(playlist.playerId, 'playlist:error:max-retries', {
          errorCount: playlist.errorCount,
          currentIndex: playlist.currentIndex
        });

        // Mostra messaggio di errore all'utente
        showErrorMessage(playlist, 'Impossibile caricare i video. Playlist interrotta.');

        // Stop playlist
        return;
      }

      // Altrimenti skip al prossimo video
      log(`Errore video (${playlist.errorCount}/${playlist.maxErrors}), skip al prossimo`);
      playNextVideo(playlist);
    };
    videoElement.addEventListener('error', playlist.eventHandlers.videoError);

    // Next button click + hover
    const nextBtn = uiOverlay.querySelector('.adhub-playlist-next-btn');
    if (nextBtn) {
      playlist.eventHandlers.nextBtnClick = () => {
        log('Next button clicked');
        playNextVideo(playlist);
      };
      playlist.eventHandlers.nextBtnMouseenter = () => {
        nextBtn.style.background = 'rgba(255,255,255,0.3)';
      };
      playlist.eventHandlers.nextBtnMouseleave = () => {
        nextBtn.style.background = 'rgba(255,255,255,0.2)';
      };

      nextBtn.addEventListener('click', playlist.eventHandlers.nextBtnClick);
      nextBtn.addEventListener('mouseenter', playlist.eventHandlers.nextBtnMouseenter);
      nextBtn.addEventListener('mouseleave', playlist.eventHandlers.nextBtnMouseleave);
      playlist.nextBtn = nextBtn; // Salva riferimento per cleanup
    }

    // Mute/Unmute button click + hover
    const muteBtn = playlist.container.querySelector('.adhub-playlist-mute-btn');
    if (muteBtn) {
      playlist.eventHandlers.muteBtnClick = () => {
        videoElement.muted = !videoElement.muted;
        muteBtn.innerHTML = videoElement.muted ? '🔇' : '🔊';
        log('Mute toggled:', videoElement.muted);
        firePlaylistEvent(playerId, videoElement.muted ? 'video:muted' : 'video:unmuted');
      };
      playlist.eventHandlers.muteBtnMouseenter = () => {
        muteBtn.style.background = 'rgba(0,0,0,0.8)';
        muteBtn.style.transform = 'scale(1.1)';
      };
      playlist.eventHandlers.muteBtnMouseleave = () => {
        muteBtn.style.background = 'rgba(0,0,0,0.6)';
        muteBtn.style.transform = 'scale(1)';
      };

      muteBtn.addEventListener('click', playlist.eventHandlers.muteBtnClick);
      muteBtn.addEventListener('mouseenter', playlist.eventHandlers.muteBtnMouseenter);
      muteBtn.addEventListener('mouseleave', playlist.eventHandlers.muteBtnMouseleave);
      playlist.muteBtn = muteBtn; // Salva riferimento per cleanup
    }

    // Video started - Reset error count on success
    playlist.eventHandlers.videoPlay = () => {
      playlist.isPlaying = true;
      playlist.errorCount = 0;  // Reset errori dopo successo
      firePlaylistEvent(playerId, 'video:play', {
        index: playlist.currentIndex,
        video: playlist.videos[playlist.currentIndex]
      });
    };
    videoElement.addEventListener('play', playlist.eventHandlers.videoPlay);

    // Video paused
    playlist.eventHandlers.videoPause = () => {
      playlist.isPlaying = false;
    };
    videoElement.addEventListener('pause', playlist.eventHandlers.videoPause);
  }

  /**
   * Play video a un indice specifico
   */
  function playVideoAtIndex(playlist, index) {
    if (index >= playlist.videos.length) {
      // Fine playlist
      if (playlist.config.loop) {
        log('Loop playlist - ripartenza');
        // Usa setTimeout per spezzare lo stack di ricorsione
        setTimeout(function() {
          playlist.currentIndex = 0;
          playlist.videosPlayed = 0;
          playVideoAtIndex(playlist, 0);
        }, 100);
      } else {
        log('Playlist terminata');
        if (playlist.config.enableAds && playlist.config.postRoll) {
          playAd(playlist);
        }
        firePlaylistEvent(playlist.playerId, 'playlist:complete');
      }
      return;
    }

    const video = playlist.videos[index];
    playlist.currentIndex = index;

    log('Riproduzione video:', index, video.name);

    // Update UI
    updatePlaylistUI(playlist);

    // Load video
    playlist.videoElement.src = video.videoUrl;
    playlist.videoElement.load();

    if (playlist.config.autoPlay) {
      playlist.videoElement.play().catch(err => {
        error('Errore autoplay:', err);
      });
    }

    // Hide ads overlay
    playlist.adsOverlay.style.display = 'none';

    firePlaylistEvent(playlist.playerId, 'video:load', { index, video });
  }

  /**
   * Play prossimo video
   */
  function playNextVideo(playlist) {
    playVideoAtIndex(playlist, playlist.currentIndex + 1);
  }

  /**
   * Play ad VAST tramite Google IMA SDK
   */
  async function playAd(playlist) {
    log('Riproduzione ad...');

    playlist.isPlayingAd = true;

    // Pause video content
    playlist.videoElement.pause();

    // Show ads overlay
    playlist.adsOverlay.style.display = 'block';
    playlist.adsOverlay.innerHTML = `
      <div style="
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 14px;
      ">
        <div>Loading ad...</div>
      </div>
    `;

    firePlaylistEvent(playlist.playerId, 'ad:request');

    try {
      // Request VAST ad via Prebid (se integrazione disponibile)
      let vastUrl = null;
      let unmutedBidReceived = false;

      if (playlist.config.adRequestCallback && typeof playlist.config.adRequestCallback === 'function') {
        // STRATEGIA AUDIO: Prova prima con audio unmuted (CPM più alto)
        if (playlist.config.preferUnmutedAds) {
          log('🔊 Tentativo 1: Richiesta bid con AUDIO ATTIVO (unmuted, CPM più alto)');

          try {
            const adResponse = await playlist.config.adRequestCallback(
              `adhub-playlist-ad-${playlist.playerId}`,
              playlist.position,
              { startMuted: false } // Richiede ads con audio attivo
            );

            if (adResponse && adResponse.vastUrl) {
              vastUrl = adResponse.vastUrl;
              unmutedBidReceived = true;
              log('✅ Bid UNMUTED ricevuto! CPM:', adResponse.cpm || 'N/A');
              log('VAST URL:', vastUrl);
            }
          } catch (err) {
            log('❌ Nessun bid per ads unmuted:', err.message);
          }
        }

        // FALLBACK: Se nessun bid unmuted, prova con muted
        if (!vastUrl && playlist.config.fallbackToMutedAds) {
          log('🔇 Tentativo 2: Richiesta bid con AUDIO MUTATO (muted, CPM standard)');

          try {
            const adResponse = await playlist.config.adRequestCallback(
              `adhub-playlist-ad-${playlist.playerId}`,
              playlist.position,
              { startMuted: true } // Richiede ads con audio mutato
            );

            if (adResponse && adResponse.vastUrl) {
              vastUrl = adResponse.vastUrl;
              unmutedBidReceived = false;
              log('✅ Bid MUTED ricevuto! CPM:', adResponse.cpm || 'N/A');
              log('VAST URL:', vastUrl);
            }
          } catch (err) {
            log('❌ Nessun bid anche per ads muted:', err.message);
          }
        }
      }

      // Se nessun VAST URL da Prebid, usa fallback GAM
      if (!vastUrl) {
        // Fallback: usa VAST tag GAM (o skip ad)
        if (playlist.config.skipAdIfNoBid) {
          log('Nessun bid, skip ad');
          onAdComplete(playlist);
          return;
        }

        // VAST fallback URL - Da config (default: AdhubMedia_RON)
        const referrerUrl = encodeURIComponent(window.location.href);
        const timestamp = Date.now();

        vastUrl = playlist.config.vastFallbackUrl
          .replace('[referrer_url]', referrerUrl)
          .replace('[description_url]', referrerUrl)
          .replace('[timestamp]', timestamp);

        log('Uso VAST fallback GAM:', vastUrl.match(/iu=([^&]+)/)?.[1] || 'AdhubMedia_RON');
      }

      // Load VAST ad usando Google IMA SDK
      await loadVastAd(playlist, vastUrl, unmutedBidReceived);

      // Imposta audio del video content in base al bid ricevuto
      if (playlist.config.startMuted === 'auto') {
        // Se abbiamo ricevuto bid unmuted, attiva audio anche per il video content
        playlist.videoElement.muted = !unmutedBidReceived;

        // Aggiorna icona bottone mute
        const muteBtn = playlist.container.querySelector('.adhub-playlist-mute-btn');
        if (muteBtn) {
          muteBtn.innerHTML = playlist.videoElement.muted ? '🔇' : '🔊';
        }

        log(`Audio video content impostato: ${playlist.videoElement.muted ? 'MUTED' : 'UNMUTED'} (basato su bid)`);
      }

    } catch (err) {
      error('Errore caricamento ad:', err);
      onAdComplete(playlist);
    }
  }

  /**
   * Carica e riproduce VAST ad usando Google IMA SDK
   * @param {boolean} unmutedBid - true se abbiamo ricevuto bid per ad unmuted
   */
  async function loadVastAd(playlist, vastUrl, unmutedBid = false) {
    return new Promise((resolve, reject) => {
      // Verifica che IMA SDK sia caricato
      if (typeof google === 'undefined' || !google.ima) {
        error('Google IMA SDK non caricato');
        onAdComplete(playlist);
        resolve();
        return;
      }

      // Crea video element per l'ad
      const adVideoEl = document.createElement('video');
      adVideoEl.style.cssText = 'width: 100%; height: 100%; object-fit: contain;';
      adVideoEl.setAttribute('playsinline', '');

      // Imposta mute in base al bid ricevuto
      adVideoEl.muted = !unmutedBid;
      log(`Ad video impostato: ${adVideoEl.muted ? 'MUTED' : 'UNMUTED'}`);

      // Crea ad container
      const adContainer = document.createElement('div');
      adContainer.style.cssText = 'width: 100%; height: 100%; position: relative;';
      adContainer.appendChild(adVideoEl);

      playlist.adsOverlay.innerHTML = '';
      playlist.adsOverlay.appendChild(adContainer);

      // Crea IMA container
      const imaContainer = document.createElement('div');
      imaContainer.style.cssText = 'position: absolute; top: 0; left: 0; width: 100%; height: 100%;';
      adContainer.appendChild(imaContainer);

      // Setup IMA
      const adDisplayContainer = new google.ima.AdDisplayContainer(imaContainer, adVideoEl);
      const adsLoader = new google.ima.AdsLoader(adDisplayContainer);
      let adsManager = null;

      // Ads Loader events
      adsLoader.addEventListener(
        google.ima.AdsManagerLoadedEvent.Type.ADS_MANAGER_LOADED,
        (event) => {
          log('IMA: AdsManager loaded');

          adsManager = event.getAdsManager(adVideoEl);

          // Setup ads manager events
          adsManager.addEventListener(
            google.ima.AdErrorEvent.Type.AD_ERROR,
            (adErrorEvent) => {
              error('IMA Ad Error:', adErrorEvent.getError());
              firePlaylistEvent(playlist.playerId, 'ad:error', {
                error: adErrorEvent.getError().getMessage()
              });
              adsManager.destroy();
              onAdComplete(playlist);
              resolve();
            }
          );

          adsManager.addEventListener(
            google.ima.AdEvent.Type.CONTENT_PAUSE_REQUESTED,
            () => {
              log('IMA: Content pause requested');
              playlist.videoElement.pause();
            }
          );

          adsManager.addEventListener(
            google.ima.AdEvent.Type.CONTENT_RESUME_REQUESTED,
            () => {
              log('IMA: Content resume requested');
              adsManager.destroy();
              onAdComplete(playlist);
              resolve();
            }
          );

          // Track ad events
          adsManager.addEventListener(google.ima.AdEvent.Type.STARTED, () => {
            log('IMA: Ad started');
            firePlaylistEvent(playlist.playerId, 'ad:start');
          });

          adsManager.addEventListener(google.ima.AdEvent.Type.IMPRESSION, () => {
            log('IMA: Ad impression');
            firePlaylistEvent(playlist.playerId, 'ad:impression');
          });

          adsManager.addEventListener(google.ima.AdEvent.Type.COMPLETE, () => {
            log('IMA: Ad complete');
            firePlaylistEvent(playlist.playerId, 'ad:complete');
          });

          adsManager.addEventListener(google.ima.AdEvent.Type.SKIPPED, () => {
            log('IMA: Ad skipped');
            firePlaylistEvent(playlist.playerId, 'ad:skipped');
          });

          try {
            adDisplayContainer.initialize();

            // Get container dimensions
            const width = playlist.container.offsetWidth;
            const height = playlist.container.offsetHeight;

            adsManager.init(width, height, google.ima.ViewMode.NORMAL);
            adsManager.start();
          } catch (adError) {
            error('IMA: Error starting ads manager:', adError);
            adsManager.destroy();
            onAdComplete(playlist);
            resolve();
          }
        },
        false
      );

      adsLoader.addEventListener(
        google.ima.AdErrorEvent.Type.AD_ERROR,
        (adErrorEvent) => {
          error('IMA Ads Loader Error:', adErrorEvent.getError());
          firePlaylistEvent(playlist.playerId, 'ad:error', {
            error: adErrorEvent.getError().getMessage()
          });
          onAdComplete(playlist);
          resolve();
        },
        false
      );

      // Request ads
      const adsRequest = new google.ima.AdsRequest();
      adsRequest.adTagUrl = vastUrl;
      adsRequest.linearAdSlotWidth = playlist.container.offsetWidth;
      adsRequest.linearAdSlotHeight = playlist.container.offsetHeight;
      adsRequest.nonLinearAdSlotWidth = playlist.container.offsetWidth;
      adsRequest.nonLinearAdSlotHeight = playlist.container.offsetHeight;

      log('IMA: Requesting ads from:', vastUrl);
      adsLoader.requestAds(adsRequest);

      // Timeout safety
      const adTimeout = setTimeout(() => {
        error('IMA: Ad timeout');
        if (adsManager) {
          adsManager.destroy();
        }
        onAdComplete(playlist);
        resolve();
      }, 30000); // 30 secondi timeout

      // Clear timeout on completion (wrappa sia resolve che reject per evitare race condition)
      const cleanup = () => clearTimeout(adTimeout);

      const originalResolve = resolve;
      const originalReject = reject;

      resolve = function() {
        cleanup();
        originalResolve.apply(this, arguments);
      };

      reject = function() {
        cleanup();
        originalReject.apply(this, arguments);
      };
    });
  }

  /**
   * Callback quando ad è completato
   */
  function onAdComplete(playlist) {
    log('Ad completato');

    playlist.isPlayingAd = false;
    playlist.adsOverlay.style.display = 'none';

    firePlaylistEvent(playlist.playerId, 'ad:complete');

    // Se in modalità solo-ad, chiudi il player. Altrimenti, continua con il video.
    if (playlist.config.adOnly) {
      log('Modalità ad-only, chiusura player dopo ad.');
      closePlaylist(playlist.playerId);
    } else {
      // Continua con il prossimo video content
      playVideoAtIndex(playlist, playlist.currentIndex);
    }
  }

  /**
   * Mostra messaggio di errore nella playlist
   */
  function showErrorMessage(playlist, message) {
    // Nascondi video element
    playlist.videoElement.style.display = 'none';
    playlist.adsOverlay.style.display = 'none';

    // Crea messaggio di errore
    const errorDiv = document.createElement('div');
    errorDiv.className = 'adhub-playlist-error';
    errorDiv.style.cssText = `
      width: 100%;
      height: 100%;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      background: #1a1a1a;
      color: #fff;
      padding: 20px;
      text-align: center;
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    `;

    errorDiv.innerHTML = `
      <div style="font-size: 48px; margin-bottom: 15px;">⚠️</div>
      <div style="font-size: 16px; font-weight: 500; margin-bottom: 10px;">${message}</div>
      <div style="font-size: 12px; opacity: 0.7; margin-bottom: 20px;">
        Tentativi falliti: ${playlist.errorCount}/${playlist.maxErrors}
      </div>
      <button class="adhub-playlist-error-retry" style="
        background: rgba(255,255,255,0.2);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        padding: 10px 20px;
        border-radius: 6px;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
        transition: background 0.2s;
      ">
        Chiudi
      </button>
    `;

    // Aggiungi al container
    playlist.container.appendChild(errorDiv);

    // Handler bottone chiudi
    const retryBtn = errorDiv.querySelector('.adhub-playlist-error-retry');
    retryBtn.addEventListener('click', () => {
      closePlaylist(playlist.playerId);
    });

    retryBtn.addEventListener('mouseenter', () => {
      retryBtn.style.background = 'rgba(255,255,255,0.3)';
    });

    retryBtn.addEventListener('mouseleave', () => {
      retryBtn.style.background = 'rgba(255,255,255,0.2)';
    });
  }

  /**
   * Update playlist UI (titolo, progress)
   */
  function updatePlaylistUI(playlist) {
    const video = playlist.videos[playlist.currentIndex];

    // Update title
    const titleEl = playlist.uiOverlay.querySelector('.adhub-playlist-title');
    if (titleEl && video) {
      titleEl.textContent = video.name;
    }

    // Update progress
    const currentEl = playlist.uiOverlay.querySelector('.adhub-playlist-current');
    const totalEl = playlist.uiOverlay.querySelector('.adhub-playlist-total');

    if (currentEl) {
      currentEl.textContent = String(playlist.currentIndex + 1);
    }

    if (totalEl) {
      totalEl.textContent = String(playlist.videos.length);
    }
  }

  /**
   * Fire playlist event
   */
  function firePlaylistEvent(playerId, eventType, data = {}) {
    log(`Event: ${eventType}`, data);

    window.dispatchEvent(new CustomEvent('adhub:playlist:' + eventType, {
      detail: {
        playerId,
        eventType,
        timestamp: Date.now(),
        ...data
      }
    }));
  }

  /**
   * Chiudi playlist
   */
  function closePlaylist(playerId) {
    const playlist = state.playlists.get(playerId);
    if (!playlist || playlist.isClosed) {
      return;
    }

    log('Chiusura playlist:', playerId);

    playlist.isClosed = true;

    // CLEANUP EVENT LISTENERS (fix memory leak)
    if (playlist.eventHandlers) {
      const { videoElement } = playlist;

      // Rimuovi video event listeners
      if (playlist.eventHandlers.videoEnded) {
        videoElement.removeEventListener('ended', playlist.eventHandlers.videoEnded);
      }
      if (playlist.eventHandlers.videoError) {
        videoElement.removeEventListener('error', playlist.eventHandlers.videoError);
      }
      if (playlist.eventHandlers.videoPlay) {
        videoElement.removeEventListener('play', playlist.eventHandlers.videoPlay);
      }
      if (playlist.eventHandlers.videoPause) {
        videoElement.removeEventListener('pause', playlist.eventHandlers.videoPause);
      }

      // Rimuovi button event listeners
      if (playlist.nextBtn) {
        if (playlist.eventHandlers.nextBtnClick) {
          playlist.nextBtn.removeEventListener('click', playlist.eventHandlers.nextBtnClick);
        }
        if (playlist.eventHandlers.nextBtnMouseenter) {
          playlist.nextBtn.removeEventListener('mouseenter', playlist.eventHandlers.nextBtnMouseenter);
        }
        if (playlist.eventHandlers.nextBtnMouseleave) {
          playlist.nextBtn.removeEventListener('mouseleave', playlist.eventHandlers.nextBtnMouseleave);
        }
      }
      if (playlist.muteBtn) {
        if (playlist.eventHandlers.muteBtnClick) {
          playlist.muteBtn.removeEventListener('click', playlist.eventHandlers.muteBtnClick);
        }
        if (playlist.eventHandlers.muteBtnMouseenter) {
          playlist.muteBtn.removeEventListener('mouseenter', playlist.eventHandlers.muteBtnMouseenter);
        }
        if (playlist.eventHandlers.muteBtnMouseleave) {
          playlist.muteBtn.removeEventListener('mouseleave', playlist.eventHandlers.muteBtnMouseleave);
        }
      }

      // Cleanup riferimenti
      playlist.eventHandlers = null;
    }

    // Cleanup close button event listeners
    if (playlist.closeButton && playlist.closeButton._handlers) {
      if (playlist.closeButton._handlers.mouseenter) {
        playlist.closeButton.removeEventListener('mouseenter', playlist.closeButton._handlers.mouseenter);
      }
      if (playlist.closeButton._handlers.mouseleave) {
        playlist.closeButton.removeEventListener('mouseleave', playlist.closeButton._handlers.mouseleave);
      }
      if (playlist.closeButton._handlers.click) {
        playlist.closeButton.removeEventListener('click', playlist.closeButton._handlers.click);
      }
      playlist.closeButton._handlers = null;
    }

    // Stop video
    playlist.videoElement.pause();
    playlist.videoElement.src = '';

    // Animazione uscita
    playlist.container.style.transition = 'all 300ms ease-in';
    playlist.container.style.opacity = '0';
    playlist.container.style.transform = playlist.position.startsWith('sticky-')
      ? 'translateY(20px)'
      : 'scale(0.95)';

    setTimeout(() => {
      playlist.container.remove();
      state.playlists.delete(playerId);

      firePlaylistEvent(playerId, 'closed');

      log('Playlist rimossa:', playerId);
    }, 300);
  }

  /**
   * Chiudi tutte le playlist
   */
  function closeAllPlaylists() {
    log('Chiusura di tutte le playlist');
    state.playlists.forEach((playlist, playerId) => {
      closePlaylist(playerId);
    });
  }

  // ============================================================================
  // INITIALIZATION
  // ============================================================================

  /**
   * Auto-init playlist dai placeholder HTML
   * Cerca div con attributo data-adhub-playlist o playlist, o ID adhub-player
   */
  function autoInitFromDOM() {
    log('Auto-init: Cerca placeholder playlist nel DOM');

    // Cerca elementi con data-adhub-playlist o playlist attribute
    const placeholders = document.querySelectorAll('[data-adhub-playlist], [playlist]');

    // Cerca anche elemento con ID adhub-player (default)
    const defaultPlayer = document.getElementById('adhub-player');

    // Crea lista elementi da processare
    const elementsToProcess = new Set();

    placeholders.forEach(el => elementsToProcess.add(el));

    if (defaultPlayer && !elementsToProcess.has(defaultPlayer)) {
      elementsToProcess.add(defaultPlayer);
    }

    elementsToProcess.forEach((element) => {
      const playlistCode = element.getAttribute('data-adhub-playlist') ||
                          element.getAttribute('playlist') ||
                          state.config.defaultPlaylist;

      const playerId = element.id || `playlist-auto-${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;

      // Set ID se non presente
      if (!element.id) {
        element.id = playerId;
      }

      // Leggi altri attributi opzionali
      const position = element.getAttribute('data-position') || 'in-content';
      const enableAds = element.getAttribute('data-enable-ads') !== 'false';
      const sizePreset = element.getAttribute('data-size-preset') || 'standard';
      const autoPlay = element.getAttribute('data-autoplay') !== 'false';
      const videoUrl = element.getAttribute('data-video-url') || null; // Nuovo: URL video diretto

      // Audio strategy attributes (nuovi)
      const preferUnmuted = element.getAttribute('data-prefer-unmuted-ads');
      const fallbackMuted = element.getAttribute('data-fallback-muted-ads');
      const startMuted = element.getAttribute('data-start-muted');

      if (videoUrl) {
        log(`Auto-init playlist: ${playerId}, video diretto: ${videoUrl}, position: ${position}`);
      } else {
        log(`Auto-init playlist: ${playerId}, playlist: ${playlistCode}, position: ${position}`);
      }

      // Crea config options
      const options = {
        playlist: playlistCode,
        position: position,
        enableAds: enableAds,
        sizePreset: sizePreset,
        autoPlay: autoPlay,
        videoUrl: videoUrl // Nuovo: supporto per URL video diretto
      };

      // Audio strategy config (se specificato)
      if (preferUnmuted !== null) {
        options.preferUnmutedAds = preferUnmuted !== 'false';
      }
      if (fallbackMuted !== null) {
        options.fallbackToMutedAds = fallbackMuted !== 'false';
      }
      if (startMuted !== null) {
        // Può essere: 'auto' | 'true' | 'false'
        if (startMuted === 'true') {
          options.startMuted = true;
        } else if (startMuted === 'false') {
          options.startMuted = false;
        } else {
          options.startMuted = 'auto'; // default
        }
      }

      // Crea playlist
      createPlaylist(playerId, options).catch(err => {
        error(`Errore auto-init playlist ${playerId}:`, err);
      });
    });

    if (elementsToProcess.size === 0) {
      log('Auto-init: Nessun placeholder trovato');
    } else {
      log(`Auto-init: ${elementsToProcess.size} playlist inizializzate`);
    }
  }

  async function init(config = {}) {
    if (state.initialized) {
      log('Già inizializzato');
      return;
    }

    // Merge config
    state.config = {
      ...DEFAULT_CONFIG,
      ...config
    };

    // Debug mode da URL
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('debug') === 'playlist') {
      state.config.debug = true;
    }

    // Carica IMA SDK se ads abilitati
    if (state.config.enableAds) {
      try {
        await loadImaSDK();
      } catch (err) {
        error('Impossibile caricare IMA SDK, ads disabilitati:', err);
        state.config.enableAds = false;
      }
    }

    // Cleanup on page unload
    window.addEventListener('beforeunload', closeAllPlaylists);

    state.initialized = true;

    log('✅ Modulo Playlist inizializzato', state.config);

    // Dispatch event
    window.dispatchEvent(new CustomEvent('adhub:playlist:ready'));

    // Auto-init from DOM se abilitato
    if (state.config.autoInitFromDOM) {
      // Aspetta che il DOM sia pronto
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', autoInitFromDOM);
      } else {
        // DOM già pronto, init subito
        setTimeout(autoInitFromDOM, 100);
      }
    }
  }

  // ============================================================================
  // PUBLIC API
  // ============================================================================

  window.AdHubVideoPlaylist = {
    // Initialization
    init,

    // Playlist management
    createPlaylist,
    closePlaylist,
    closeAllPlaylists,

    // Getters
    getPlaylist: (playerId) => state.playlists.get(playerId),
    getAllPlaylists: () => Array.from(state.playlists.values()),
    getConfig: () => ({...state.config}),

    // Setters
    setConfig: (config) => {
      state.config = {...state.config, ...config};
      log('Config aggiornata:', state.config);
    },

    // Control
    playNext: (playerId) => {
      const playlist = state.playlists.get(playerId);
      if (playlist) playNextVideo(playlist);
    },

    playVideoAt: (playerId, index) => {
      const playlist = state.playlists.get(playerId);
      if (playlist) playVideoAtIndex(playlist, index);
    },

    // State
    isInitialized: () => state.initialized,

    // Utils
    isMobile
  };

  // Auto-init
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', () => init());
  } else {
    init();
  }

  console.log('[AdHubVideoPlaylist] ✅ Modulo caricato (versione 1.0.0)');

})();

// From: adhub-viewability.js
/**
 * AdHub Viewability Tracking Module
 *
 * Traccia viewability degli ad slots per analytics e ottimizzazione.
 * Usa IntersectionObserver API per performance ottimali.
 *
 * @version 1.0.0
 * @date 2025-10-31
 */

(function() {
  'use strict';

  if (window.AdHubViewability) {
    console.warn('[AdHubViewability] Modulo già caricato');
    return;
  }

  // ============================================================================
  // CONFIGURATION
  // ============================================================================

  const DEFAULT_CONFIG = {
    // Threshold viewability (50% IAB standard)
    threshold: 0.5,

    // Tempo minimo visibile per contare come viewed (1 secondo IAB standard)
    minViewTime: 1000,

    // Track anche partial viewability
    trackPartial: true,

    // Invia eventi a Google Analytics
    sendToGA: true,

    // Debug
    debug: false
  };

  // ============================================================================
  // STATE
  // ============================================================================

  const state = {
    config: {...DEFAULT_CONFIG},
    initialized: false,
    observers: {},      // adUnitCode -> IntersectionObserver
    viewTimers: {},     // adUnitCode -> timeout ID
    viewData: {},       // adUnitCode -> { firstView, totalTime, isViewable }
    stats: {
      totalSlots: 0,
      viewableSlots: 0,
      impressions: 0,
      viewableImpressions: 0
    }
  };

  // ============================================================================
  // UTILITY
  // ============================================================================

  function log(...args) {
    if (state.config.debug) {
      console.log('[AdHubViewability]', ...args);
    }
  }

  // ============================================================================
  // VIEWABILITY TRACKING
  // ============================================================================

  /**
   * Setup viewability tracking per uno slot
   */
  function trackSlot(adUnitCode) {
    const element = document.getElementById(adUnitCode);
    if (!element) {
      log(`Elemento non trovato: ${adUnitCode}`);
      return;
    }

    // Init view data
    state.viewData[adUnitCode] = {
      firstView: null,
      totalViewTime: 0,
      isViewable: false,
      maxViewability: 0,
      impressionFired: false
    };

    state.stats.totalSlots++;

    // Create IntersectionObserver
    const observer = new IntersectionObserver(
      function(entries) {
        entries.forEach(function(entry) {
          handleIntersection(adUnitCode, entry);
        });
      },
      {
        threshold: [0, 0.25, 0.5, 0.75, 1.0]
      }
    );

    observer.observe(element);
    state.observers[adUnitCode] = observer;

    log(`Tracking viewability per: ${adUnitCode}`);
  }

  /**
   * Handle intersection change
   */
  function handleIntersection(adUnitCode, entry) {
    const viewability = entry.intersectionRatio;
    const viewData = state.viewData[adUnitCode];

    if (!viewData) return;

    // Update max viewability
    viewData.maxViewability = Math.max(viewData.maxViewability, viewability);

    // Check if viewable (>= threshold)
    const isViewable = viewability >= state.config.threshold;

    if (isViewable) {
      onSlotViewable(adUnitCode, viewability);
    } else {
      onSlotNotViewable(adUnitCode);
    }
  }

  /**
   * Slot diventa viewable
   */
  function onSlotViewable(adUnitCode, viewability) {
    const viewData = state.viewData[adUnitCode];

    // Primo momento viewable
    if (!viewData.firstView) {
      viewData.firstView = Date.now();
      log(`Slot viewable: ${adUnitCode} (${Math.round(viewability * 100)}%)`);
    }

    // Setup timer per viewable impression
    if (!viewData.impressionFired && !state.viewTimers[adUnitCode]) {
      state.viewTimers[adUnitCode] = setTimeout(function() {
        fireViewableImpression(adUnitCode, viewability);
      }, state.config.minViewTime);
    }

    viewData.isViewable = true;
  }

  /**
   * Slot non più viewable
   */
  function onSlotNotViewable(adUnitCode) {
    const viewData = state.viewData[adUnitCode];

    // Calcola tempo totale viewable
    if (viewData.firstView && viewData.isViewable) {
      viewData.totalViewTime += Date.now() - viewData.firstView;
      viewData.firstView = null;
    }

    // Cancella timer viewable impression
    if (state.viewTimers[adUnitCode]) {
      clearTimeout(state.viewTimers[adUnitCode]);
      delete state.viewTimers[adUnitCode];
    }

    viewData.isViewable = false;
  }

  /**
   * Fire viewable impression
   */
  function fireViewableImpression(adUnitCode, viewability) {
    const viewData = state.viewData[adUnitCode];

    if (viewData.impressionFired) return;

    viewData.impressionFired = true;
    state.stats.viewableImpressions++;

    log(`Viewable impression: ${adUnitCode} (${Math.round(viewability * 100)}%)`);

    // Send to Google Analytics
    if (state.config.sendToGA && window.gtag) {
      gtag('event', 'viewable_impression', {
        event_category: 'viewability',
        event_label: adUnitCode,
        value: Math.round(viewability * 100)
      });
    }

    // Dispatch event
    window.dispatchEvent(new CustomEvent('adhub:viewable:impression', {
      detail: {
        adUnitCode,
        viewability,
        viewTime: state.config.minViewTime
      }
    }));
  }

  // ============================================================================
  // PUBLIC API
  // ============================================================================

  function init(config) {
    if (state.initialized) {
      log('Già inizializzato');
      return;
    }

    if (config) {
      Object.assign(state.config, config);
    }

    // Debug da URL
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('debug') === 'viewability') {
      state.config.debug = true;
    }

    state.initialized = true;
    log('✅ Modulo Viewability inizializzato', state.config);
  }

  function getStats() {
    return {
      ...state.stats,
      viewabilityRate: state.stats.totalSlots > 0
        ? (state.stats.viewableImpressions / state.stats.totalSlots * 100).toFixed(2) + '%'
        : '0%'
    };
  }

  function getSlotData(adUnitCode) {
    return state.viewData[adUnitCode] || null;
  }

  function stopTracking(adUnitCode) {
    if (state.observers[adUnitCode]) {
      state.observers[adUnitCode].disconnect();
      delete state.observers[adUnitCode];
    }

    if (state.viewTimers[adUnitCode]) {
      clearTimeout(state.viewTimers[adUnitCode]);
      delete state.viewTimers[adUnitCode];
    }

    log(`Tracking fermato per: ${adUnitCode}`);
  }

  function stopAll() {
    Object.keys(state.observers).forEach(stopTracking);
    log('Tracking fermato per tutti gli slot');
  }

  // Export
  window.AdHubViewability = {
    init,
    trackSlot,
    stopTracking,
    stopAll,
    getStats,
    getSlotData,
    getConfig: () => ({...state.config}),
    setConfig: (config) => Object.assign(state.config, config)
  };

  console.log('[AdHubViewability] ✅ Modulo caricato (versione 1.0.0)');

})();


// ============================================================================
// SSP CONFIGURATION (GLOBAL DEFAULTS)
// ============================================================================

/**
 * AdHub SSP Credentials Configuration
 *
 * File centralizzato per gestire le credenziali SSP.
 * Le configurazioni possono essere:
 * - GLOBALI: Usate per tutti i siti (default)
 * - SITE-SPECIFIC: Override per sito specifico (economymagazine, notizie, mrwatch93)
 *
 * Priorità: Site-specific > Global
 *
 * @version 1.0.0
 * @date 2025-10-23
 */

window.AdHubSSPConfig = window.AdHubSSPConfig || {};

(function() {
    'use strict';

    /**
     * CONFIGURAZIONI GLOBALI (Default per tutti i siti)
     * Configurazione SSP dirette AdHub Media - Usate se non c'è un override specifico per il sito
     */
    const GLOBAL_SSP_CONFIG = {

        // ========================================
        // APPNEXUS / XANDR
        // ========================================
        appnexus: {
            enabled: false,  // Disabilitato - Usa solo Nexx360
            // memberId: '123456',  // Opzionale - commentato per usare default Prebid

            // Placement ID di default AdHub Media
            // I siti possono sovrascrivere con valori specifici
            placements: {
                'top-banner': '35867964',
                'sidebar': '35867964',
                'in-article': '35867964',
                'sticky-bottom': '35867964'
            }
        },

        // ========================================
        // NEXX360
        // Mapping completo tagId per size specifiche
        // ========================================
        nexx360: {
            enabled: true,

            // Tag ID mappati per size display (reali da Nexx360)
            tagIdsBySize: {
                // Desktop - Large formats
                '970x250': 'jcwva15v',  // adhubmedia_owned_sites_nexx360_display_970x250_prebid
                '728x90': 'mg32sw72',   // adhubmedia_owned_sites_nexx360_display_728x90_prebid

                // Desktop/Mobile - Medium formats
                '300x600': '42uowtbf',  // adhubmedia_owned_sites_nexx360_display_300x600_prebid
                '300x250': 'd7yqsikf',  // adhubmedia_owned_sites_nexx360_display_300x250_prebid
                '336x280': 'arf3dsmb',  // adhubmedia_owned_sites_nexx360_display_336x280_prebid

                // Desktop - Skyscraper
                '160x600': 'z9wgjnya',  // adhubmedia_owned_sites_nexx360_display_160x600_prebid
                '120x600': 'hq7515y4',  // adhubmedia_owned_sites_nexx360_display_120x600_prebid

                // Mobile
                '320x100': 'gn1sj0pa',  // adhubmedia_owned_sites_nexx360_display_320x100_prebid
                '320x50': '0cm7gkde',   // adhubmedia_owned_sites_nexx360_display_320x50_prebid

                // Other
                '468x60': 'zqahj4ta'    // adhubmedia_owned_sites_nexx360_display_468x60_prebid
            },

            // Video tagIds (separati da display)
            videoTagIds: {
                desktop: '7iellh0i',    // adhubmedia_owned_sites_nexx360_video_prebid_desktop
                mobile: 'oura2ehq'      // adhubmedia_owned_sites_nexx360_video_prebid_mobile
            },

            // DEPRECATED: Backward compatibility
            // Tag ID di default (usa il 300x250 come fallback)
            tagIds: {
                'top-banner': 'd7yqsikf',
                'sidebar': 'd7yqsikf',
                'in-article': 'd7yqsikf',
                'sticky-bottom': 'd7yqsikf',
                // Article positions (300x250)
                'article-top': 'd7yqsikf',
                'article-mid': 'd7yqsikf',
                'article-bottom': 'd7yqsikf',
                // Additional in-article positions
                'in-article-1': 'd7yqsikf',
                'in-article-2': 'd7yqsikf',
                'in-article-3': 'd7yqsikf'
            }
        },

        // ========================================
        // E_VOLUTION
        // ========================================
        e_volution: {
            enabled: true,

            // Placement ID mappati per size specifiche
            placementIdsBySize: {
                '300x600': '1854',
                '300x250': '1852',
                '728x90': '1855',
                '320x50': '1856',
                '468x60': '1857',
                '160x600': '1858',
                '120x600': '1859',
                '336x280': '1860',
                '970x250': '1861',
                '320x100': '1862'
            },

            // DEPRECATED: Backward compatibility
            // Placement ID di default (usa il 300x250 come fallback)
            placements: {
                'top-banner': '1852',
                'sidebar': '1852',
                'in-article': '1852',
                'sticky-bottom': '1852',
                // Article positions (300x250)
                'article-top': '1852',
                'article-mid': '1852',
                'article-bottom': '1852',
                // Additional in-article positions
                'in-article-1': '1852',
                'in-article-2': '1852',
                'in-article-3': '1852'
            }
        },

        // ========================================
        // SSP NON UTILIZZATI (Disabilitati di default)
        // ========================================

        // RUBICON PROJECT (MAGNITE)
        rubicon: {
            enabled: false,
            accountId: '12345',  // TODO: Il tuo Account ID se vuoi abilitare
            siteId: '67890',     // TODO: Il tuo Site ID
        },

        // OPENX
        openx: {
            enabled: false,
            delDomain: 'adhubmedia-d.openx.net',  // TODO: Il tuo Delivery Domain
        },

        // PUBMATIC
        pubmatic: {
            enabled: false,
            publisherId: '123456',  // TODO: Il tuo Publisher ID
        },

        // INDEX EXCHANGE
        ix: {
            enabled: false,
            siteId: '123456',  // TODO: Il tuo Site ID
        },

        // CRITEO
        criteo: {
            enabled: false,
            networkId: 123456,  // TODO: Il tuo Network ID
        },

        // SOVRN
        sovrn: {
            enabled: false,
            tagId: '123456',  // TODO: Il tuo Tag ID
        },

        // TRIPLELIFT
        triplelift: {
            enabled: false,
            inventoryCode: 'code_here',  // TODO: Il tuo Inventory Code
        },

        // SMART AD SERVER
        smartadserver: {
            enabled: false,
            networkId: 123456,  // TODO: Network ID
            siteId: 123456,     // TODO: Site ID
        },

        // ========================================
        // TEADS
        // ========================================
        teads: {
            enabled: false,
            pageId: 123456,  // TODO: Page ID
            placementId: 123456,  // TODO: Placement ID
        },

        // ========================================
        // YOBEE
        // ========================================
        yobee: {
            enabled: true,
            networkId: 1305829008,
            host: 'adhubmedia.rtb.yobee.it',
        },

    };

    /**
     * Funzione per ottenere la configurazione SSP per un sito specifico
     * @param {string} site - Nome del sito (professionemamma, example, etc.)
     * @param {string} bidder - Nome del bidder (appnexus, rubicon, openx, etc.)
     * @returns {object} Configurazione mergiata (override > global)
     */
    function getSSPConfig(site, bidder) {
        const globalConfig = GLOBAL_SSP_CONFIG[bidder] || {};

        // Config override (da sites/{site}/ssp-credentials.js)
        const overrideConfig = (window.AdHubSSPOverride && window.AdHubSSPOverride[site])
            ? window.AdHubSSPOverride[site][bidder]
            : {};

        // Merge: override > global
        // Priorità: 1. Override (massima), 2. Global (default)
        return Object.assign({}, globalConfig, overrideConfig);
    }

    /**
     * Funzione per ottenere il Placement/Zone ID per un ad unit
     * @param {string} site - Nome del sito
     * @param {string} bidder - Nome del bidder
     * @param {string} adUnitCode - Codice dell'ad unit (es: 'top-banner', 'sidebar')
     * @returns {string|number|array} Placement/Zone ID (o array per IX)
     */
    function getAdUnitId(site, bidder, adUnitCode) {
        // Cerca negli override (da sites/{site}/ssp-credentials.js)
        if (window.AdHubSSPOverride && window.AdHubSSPOverride[site]) {
            const siteOverride = window.AdHubSSPOverride[site][bidder];

            if (siteOverride) {
                // Supporto vari formati di override
                if (siteOverride.placements && siteOverride.placements[adUnitCode]) {
                    return siteOverride.placements[adUnitCode];
                }
                if (siteOverride.zones && siteOverride.zones[adUnitCode]) {
                    return siteOverride.zones[adUnitCode];
                }
                if (siteOverride.units && siteOverride.units[adUnitCode]) {
                    return siteOverride.units[adUnitCode];
                }
                if (siteOverride.adSlots && siteOverride.adSlots[adUnitCode]) {
                    return siteOverride.adSlots[adUnitCode];
                }
                if (siteOverride.sizes && siteOverride.sizes[adUnitCode]) {
                    return siteOverride.sizes[adUnitCode];  // Index Exchange
                }
            }
        }

        // Fallback to global configuration
        const globalConfig = GLOBAL_SSP_CONFIG[bidder];
        if (globalConfig) {
            // Check different property names used by different bidders
            if (globalConfig.placements && globalConfig.placements[adUnitCode]) {
                return globalConfig.placements[adUnitCode];
            }
            if (globalConfig.zones && globalConfig.zones[adUnitCode]) {
                return globalConfig.zones[adUnitCode];
            }
            if (globalConfig.units && globalConfig.units[adUnitCode]) {
                return globalConfig.units[adUnitCode];
            }
            if (globalConfig.adSlots && globalConfig.adSlots[adUnitCode]) {
                return globalConfig.adSlots[adUnitCode];
            }
            if (globalConfig.tagIds && globalConfig.tagIds[adUnitCode]) {
                return globalConfig.tagIds[adUnitCode];
            }
        }

        return null;
    }

    /**
     * Funzione per verificare se un bidder è abilitato per un sito
     * @param {string} site - Nome del sito
     * @param {string} bidder - Nome del bidder
     * @returns {boolean} True se abilitato
     */
    function isBidderEnabled(site, bidder) {
        const config = getSSPConfig(site, bidder);
        return config.enabled === true;
    }

    /**
     * Funzione per ottenere il tagId Nexx360 corretto per una size specifica
     * @param {array|string} size - Size come array [width, height] o string 'widthxheight'
     * @returns {string} tagId Nexx360 per quella size, o fallback al 300x250
     */
    function getNexx360TagIdBySize(size) {
        // Converti size a formato string 'widthxheight'
        let sizeKey;
        if (Array.isArray(size)) {
            sizeKey = size[0] + 'x' + size[1];
        } else if (typeof size === 'string') {
            sizeKey = size;
        } else {
            console.warn('[AdHubSSP] Invalid size format for Nexx360:', size);
            return GLOBAL_SSP_CONFIG.nexx360.tagIdsBySize['300x250']; // Fallback
        }

        // Cerca tagId per questa size
        const tagId = GLOBAL_SSP_CONFIG.nexx360.tagIdsBySize[sizeKey];

        if (tagId) {
            return tagId;
        }

        // Fallback al 300x250 (più comune)
        console.warn('[AdHubSSP] No Nexx360 tagId for size', sizeKey, '- using 300x250 fallback');
        return GLOBAL_SSP_CONFIG.nexx360.tagIdsBySize['300x250'];
    }

    /**
     * Funzione per ottenere i tagId Nexx360 per un array di sizes
     * Ritorna un array di tagId unici
     * @param {array} sizes - Array di sizes [[width, height], ...]
     * @returns {array} Array di tagId unici per quelle sizes
     */
    function getNexx360TagIdsBySizes(sizes) {
        if (!Array.isArray(sizes) || sizes.length === 0) {
            return [GLOBAL_SSP_CONFIG.nexx360.tagIdsBySize['300x250']];
        }

        const tagIds = sizes.map(size => getNexx360TagIdBySize(size));

        // Rimuovi duplicati
        return [...new Set(tagIds)];
    }

    /**
     * Funzione per ottenere il placementId E_volution corretto per una size specifica
     * @param {array|string} size - Size come array [width, height] o string 'widthxheight'
     * @returns {string} placementId E_volution per quella size, o fallback al 300x250
     */
    function getEvolutionPlacementIdBySize(size) {
        // Converti size a formato string 'widthxheight'
        let sizeKey;
        if (Array.isArray(size)) {
            sizeKey = size[0] + 'x' + size[1];
        } else if (typeof size === 'string') {
            sizeKey = size;
        } else {
            console.warn('[AdHubSSP] Invalid size format for E_volution:', size);
            return GLOBAL_SSP_CONFIG.e_volution.placementIdsBySize['300x250']; // Fallback
        }

        // Cerca placementId per questa size
        const placementId = GLOBAL_SSP_CONFIG.e_volution.placementIdsBySize[sizeKey];

        if (placementId) {
            return placementId;
        }

        // Fallback al 300x250 (più comune)
        console.warn('[AdHubSSP] No E_volution placementId for size', sizeKey, '- using 300x250 fallback');
        return GLOBAL_SSP_CONFIG.e_volution.placementIdsBySize['300x250'];
    }

    /**
     * Funzione per ottenere i placementId E_volution per un array di sizes
     * Ritorna un array di placementId unici
     * @param {array} sizes - Array di sizes [[width, height], ...]
     * @returns {array} Array di placementId unici per quelle sizes
     */
    function getEvolutionPlacementIdsBySizes(sizes) {
        if (!Array.isArray(sizes) || sizes.length === 0) {
            return [GLOBAL_SSP_CONFIG.e_volution.placementIdsBySize['300x250']];
        }

        const placementIds = sizes.map(size => getEvolutionPlacementIdBySize(size));

        // Rimuovi duplicati
        return [...new Set(placementIds)];
    }

    /**
     * Funzione per ottenere tutti i bidder abilitati per un sito
     * @param {string} site - Nome del sito
     * @returns {array} Array di nomi bidder abilitati
     */
    function getEnabledBidders(site) {
        const bidders = Object.keys(GLOBAL_SSP_CONFIG);
        const enabled = bidders.filter(function(bidder) {
            const isEnabled = isBidderEnabled(site, bidder);
            // Debug log (rimuovi in produzione se causa troppo rumore)
            if (window.location.search.indexOf('debug=ssp') !== -1) {
                console.log('[SSP Debug] Bidder:', bidder, 'Enabled:', isEnabled);
            }
            return isEnabled;
        });
        return enabled;
    }

    /**
     * Funzione per generare la configurazione bidder completa per Prebid.js
     * @param {string} site - Nome del sito
     * @param {string} adUnitCode - Codice dell'ad unit
     * @param {array} sizes - Array di size [[w,h], ...]
     * @returns {array} Array di configurazioni bidder per Prebid.js
     */
    function generateBidderParams(site, adUnitCode, sizes) {
        const enabledBidders = getEnabledBidders(site);
        const bidders = [];

        enabledBidders.forEach(function(bidderName) {
            const config = getSSPConfig(site, bidderName);
            let params = {};

            switch(bidderName) {
                case 'appnexus':
                    const appnexusId = getAdUnitId(site, bidderName, adUnitCode);
                    if (!appnexusId) {
                        console.warn('[AdHub SSP Config] Nessun ID trovato per', site, bidderName, adUnitCode);
                        return;
                    }
                    params = {
                        placementId: appnexusId
                    };
                    break;

                case 'nexx360':
                    // Usa size-specific mapping
                    // Per Nexx360, genera un bid per ogni size con il tagId corretto
                    if (sizes && sizes.length > 0) {
                        // Ottieni tutti i tagId unici per le sizes richieste
                        const tagIds = getNexx360TagIdsBySizes(sizes);

                        // Crea un bid per ogni tagId unico
                        tagIds.forEach(function(tagId) {
                            bidders.push({
                                bidder: 'nexx360',
                                params: {
                                    tagId: tagId
                                }
                            });
                        });
                        return; // Skip il push finale, abbiamo già aggiunto i bid
                    }
                    break;

                case 'yobee':
                    // Yobee è un alias di Admatic Bid Adapter
                    // Usa networkId + host, non size-specific
                    params = {
                        networkId: config.networkId,
                        host: config.host
                    };
                    break;

                case 'e_volution':
                    // Usa size-specific mapping
                    // Per E_volution, genera un bid per ogni size con il placementId corretto
                    if (sizes && sizes.length > 0) {
                        // Ottieni tutti i placementId unici per le sizes richieste
                        const placementIds = getEvolutionPlacementIdsBySizes(sizes);

                        // Crea un bid per ogni placementId unico
                        placementIds.forEach(function(placementId) {
                            bidders.push({
                                bidder: 'e_volution',
                                params: {
                                    placementId: placementId
                                }
                            });
                        });
                        return; // Skip il push finale, abbiamo già aggiunto i bid
                    }
                    break;

                case 'rubicon':
                    params = {
                        accountId: config.accountId,
                        siteId: config.siteId,
                        zoneId: adUnitId
                    };
                    break;

                case 'openx':
                    params = {
                        unit: adUnitId,
                        delDomain: config.delDomain
                    };
                    break;

                case 'pubmatic':
                    params = {
                        publisherId: config.publisherId,
                        adSlot: adUnitId
                    };
                    break;

                case 'ix':
                    params = {
                        siteId: config.siteId,
                        size: sizes[0] || [300, 250]  // Prima size come default
                    };
                    break;

                case 'criteo':
                    params = {
                        networkId: config.networkId
                    };
                    break;

                case 'sovrn':
                    params = {
                        tagid: config.tagId
                    };
                    break;

                case 'triplelift':
                    params = {
                        inventoryCode: config.inventoryCode
                    };
                    break;

                case 'smartadserver':
                    params = {
                        networkId: config.networkId,
                        siteId: config.siteId,
                        pageId: adUnitId,
                        formatId: getSmartFormatId(sizes[0])
                    };
                    break;

                case 'teads':
                    params = {
                        pageId: config.pageId,
                        placementId: config.placementId
                    };
                    break;
            }

            bidders.push({
                bidder: bidderName,
                params: params
            });
        });

        return bidders;
    }

    /**
     * Helper: Ottieni formatId per Smart Ad Server
     */
    function getSmartFormatId(size) {
        const sizeMap = {
            '300x250': 15,
            '728x90': 2,
            '970x250': 43,
            '300x600': 31,
            '320x50': 12,
            '160x600': 9
        };
        const key = size[0] + 'x' + size[1];
        return sizeMap[key] || 15;
    }

    /**
     * Funzione per debug: mostra configurazione completa per un sito
     * @param {string} site - Nome del sito
     */
    function debugConfig(site) {
        console.group('🔧 AdHub SSP Config Debug - ' + site.toUpperCase());

        const enabledBidders = getEnabledBidders(site);
        console.log('✅ Bidder Abilitati:', enabledBidders);

        enabledBidders.forEach(function(bidder) {
            console.group(bidder);
            console.log('Config:', getSSPConfig(site, bidder));
            console.groupEnd();
        });

        console.groupEnd();
    }

    // Esporta API pubblica
    window.AdHubSSPConfig = {
        getSSPConfig: getSSPConfig,
        getAdUnitId: getAdUnitId,
        isBidderEnabled: isBidderEnabled,
        getNexx360TagIdBySize: getNexx360TagIdBySize,
        getNexx360TagIdsBySizes: getNexx360TagIdsBySizes,
        getEvolutionPlacementIdBySize: getEvolutionPlacementIdBySize,
        getEvolutionPlacementIdsBySizes: getEvolutionPlacementIdsBySizes,
        getEnabledBidders: getEnabledBidders,
        generateBidderParams: generateBidderParams,
        debugConfig: debugConfig,

        // Esporta configurazione globale per accesso diretto (opzionale)
        _raw: {
            global: GLOBAL_SSP_CONFIG
        }
    };

    console.log('[AdHub SSP Config] ✅ Configurazione SSP caricata');

})();

// ============================================================================
// PREBID CONFIGURATION (GLOBAL DEFAULTS)
// ============================================================================

/**
 * AdHub - Global Prebid Configuration
 *
 * Configurazione Prebid.js GLOBALE usata da tutti i siti.
 * Ogni sito può sovrascrivere queste impostazioni creando un file:
 * sites/[site]/prebid-config-override.js
 *
 * @version 1.0.0
 * @date 2025-10-30
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__adHubPrebidConfigLoaded) {
    console.warn('[AdHub Prebid] Config globale già caricata - Skip duplicato');
    return;
  }
  window.__adHubPrebidConfigLoaded = true;

  /**
   * Configurazione Prebid.js GLOBALE
   * Può essere sovrascritta dai siti con window.AdHubPrebidOverride
   */
  window.AdHubPrebidConfig = {

    // ========================================
    // AUCTION SETTINGS
    // ========================================

    // Timeout per auction (millisecondi)
    timeout: 2000,

    // Granularità dei prezzi
    priceGranularity: {
      buckets: [
        { max: 5.00, increment: 0.10 },
        { max: 10.00, increment: 0.50 },
        { max: 20.00, increment: 1.00 }
      ]
    },

    // Valuta
    currency: {
      adServerCurrency: 'EUR',
      granularityMultiplier: 1,
      conversionRateFile: 'https://cdn.jsdelivr.net/gh/prebid/currency-file@1/latest.json'
    },

    // Invio di tutte le bid o solo vincitori
    enableSendAllBids: false,

    // Timeout individuale per bidder
    bidderTimeout: 1500,

    // ========================================
    // USER SYNC & USER ID
    // ========================================

    userSync: {
      syncEnabled: true,
      filterSettings: {
        iframe: {
          bidders: '*',
          filter: 'include'
        }
      },
      syncsPerBidder: 5,
      syncDelay: 3000,

      // User ID Modules
      userIds: [
        {
          name: 'id5Id',
          params: {
            partner: 173 // ID5 partner ID generico
          },
          storage: {
            type: 'cookie',
            name: 'id5id',
            expires: 90,
            refreshInSeconds: 8 * 3600
          }
        },
        {
          name: 'unifiedId',
          params: {
            partner: 'prebid'
          },
          storage: {
            type: 'cookie',
            name: 'pbjs-unifiedid',
            expires: 60
          }
        },
        {
          name: 'sharedId',
          params: {
            syncTime: 60
          },
          storage: {
            type: 'cookie',
            name: 'sharedid',
            expires: 30
          }
        }
      ]
    },

    // ========================================
    // CONSENT MANAGEMENT (GDPR/TCF 2.0 + GPP)
    // ========================================

    consentManagement: {
      // GDPR (Europa) - TCF 2.0
      gdpr: {
        cmpApi: 'iab',
        timeout: 10000,
        defaultGdprScope: true,
        rules: [{
          purpose: 'basicAds',
          enforcePurpose: true,
          enforceVendor: true,
          vendorExceptions: []
        }]
      },

      // USP / CCPA (USA - California)
      usp: {
        cmpApi: 'iab',
        timeout: 10000
      },

      // GPP (Global Privacy Platform) - Multi-region support
      // Supporta: GDPR (EU), CCPA/CPRA (US), LGPD (Brazil), etc.
      gpp: {
        cmpApi: 'iab',
        timeout: 10000,
        // Sezioni supportate: tcfeuv2, uspv1, usnat, usca, etc.
        sectionConfig: {
          // Auto-detect sections basate su CMP
        }
      }
    },

    // ========================================
    // PRICE FLOORS
    // Ottimizzati per bilanciare fill rate e revenue (Italia)
    // Aggiornati: 2025-10-31 - Max floor €0.15, min €0.10
    // ========================================

    floors: {
      enforcement: {
        floorDeals: false,
        bidAdjustment: true
      },
      data: {
        currency: 'EUR',
        schema: {
          fields: ['mediaType', 'size']
        },
        values: {
          // Desktop - Above the fold
          'banner|970x250': 0.15,  // Top banner premium (ridotto da 0.25)
          'banner|728x90': 0.15,   // Leaderboard standard (ridotto da 0.20)

          // Desktop/Mobile - Medium formats (più comuni)
          'banner|300x250': 0.15,  // Medium Rectangle - formato più richiesto
          'banner|300x600': 0.15,  // Half Page - alta viewability (ridotto da 0.25)
          'banner|336x280': 0.15,  // Large Rectangle

          // Mobile
          'banner|320x100': 0.10,  // Mobile Large Banner
          'banner|320x50': 0.10,   // Mobile Banner standard (aumentato da 0.08)

          // Fallback minimo
          '*|*': 0.10  // Floor minimo per garantire qualità (aumentato da 0.05)
        }
      }
    },

    // ========================================
    // RESPONSIVE SIZE MAPPING
    // ========================================

    sizeConfig: [
      {
        mediaQuery: '(min-width: 1024px)',
        sizesSupported: [
          [970, 250], [728, 90], [300, 250], [300, 600], [336, 280]
        ],
        labels: ['desktop']
      },
      {
        mediaQuery: '(min-width: 768px) and (max-width: 1023px)',
        sizesSupported: [
          [728, 90], [300, 250], [300, 600]
        ],
        labels: ['tablet']
      },
      {
        mediaQuery: '(max-width: 767px)',
        sizesSupported: [
          [300, 250], [320, 100], [320, 50]
        ],
        labels: ['mobile']
      }
    ],

    // ========================================
    // DEVICE ACCESS (per GDPR)
    // ========================================

    deviceAccess: true,

    // ========================================
    // SUPPLY CHAIN (schain)
    // Trasparenza della supply chain per ads.txt
    // ========================================

    schain: {
      validation: 'strict',
      config: {
        ver: '1.0',
        complete: 1,
        nodes: [
          {
            asi: 'google.com',
            sid: '131207395',  // GAM Network Code
            hp: 1,
            name: 'AdHub Media'
          }
        ]
      }
    },

    // ========================================
    // FIRST PARTY DATA (FPD) - OpenRTB
    // Dati contestuali per aumentare CPM (+15-30%)
    // ========================================

    ortb2: {
      site: {
        name: 'AdHub Media',
        domain: window.location.hostname,
        cat: ['IAB9'],  // Family & Parenting (default - override per sito)
        pagecat: ['IAB9-7'],  // Parenting - K-6 Educators
        publisher: {
          id: '131207395',
          name: 'AdHub Media',
          domain: 'adhubmedia.com'
        },
        content: {
          context: 1,  // 1=Content, 2=Social, 3=Product
          language: 'it',
          title: document.title || '',
          url: window.location.href,
          keywords: ''  // Override per sito
        },
        ext: {
          data: {
            pageType: 'article',  // article, homepage, category, etc.
            category: 'parenting'
          }
        }
      },
      user: {
        keywords: 'family,parents',  // Override per sito
        ext: {
          data: {
            registered: false
          }
        }
      },
      device: {
        w: window.screen.width,
        h: window.screen.height,
        language: navigator.language || 'it'
      }
    },

    // ========================================
    // DEBUG
    // ========================================

    debug: false  // Attivato automaticamente con ?pbjs_debug=true
  };

  console.log('[AdHub Prebid] ✅ Config globale caricata');
  console.log('[AdHub Prebid] 💡 I siti possono sovrascrivere con window.AdHubPrebidOverride');

  /**
   * Helper: Merge config con override
   * Usato dai siti per sovrascrivere parti specifiche
   */
  window.AdHubPrebidConfig.merge = function(override) {
    if (!override) return window.AdHubPrebidConfig;

    // Deep merge degli oggetti
    function deepMerge(target, source) {
      for (var key in source) {
        if (source.hasOwnProperty(key)) {
          if (source[key] && typeof source[key] === 'object' && !Array.isArray(source[key])) {
            target[key] = target[key] || {};
            deepMerge(target[key], source[key]);
          } else {
            target[key] = source[key];
          }
        }
      }
      return target;
    }

    return deepMerge(JSON.parse(JSON.stringify(window.AdHubPrebidConfig)), override);
  };

  /**
   * Helper: Applica config a Prebid.js
   */
  window.AdHubPrebidConfig.apply = function(customConfig) {
    var config = customConfig || window.AdHubPrebidConfig;

    if (typeof pbjs === 'undefined' || !pbjs.setConfig) {
      console.error('[AdHub Prebid] Prebid.js non ancora caricato');
      return false;
    }

    pbjs.setConfig({
      priceGranularity: config.priceGranularity,
      currency: config.currency,
      enableSendAllBids: config.enableSendAllBids,
      bidderTimeout: config.bidderTimeout,
      userSync: config.userSync,
      consentManagement: config.consentManagement,
      floors: config.floors,
      sizeConfig: config.sizeConfig,
      deviceAccess: config.deviceAccess,
      schain: config.schain,
      ortb2: config.ortb2,
      debug: config.debug
    });

    console.log('[AdHub Prebid] ✅ Config applicata a Prebid.js');
    return true;
  };

})();

// ============================================================================
// VIDEO CONFIGURATION (GLOBAL DEFAULTS)
// ============================================================================

/**
 * AdHub Video Configuration
 *
 * Configurazione globale per video ads (VAST/VPAID)
 * Può essere sovrascritta da configurazioni site-specific
 *
 * @version 1.0.0
 * @date 2025-10-30
 */

(function() {
  'use strict';

  // ============================================================================
  // CONFIGURAZIONE GLOBALE VIDEO
  // ============================================================================

  window.AdHubVideoConfig = {

    // ========================================
    // Video Size Presets (Ottimizzati 2025)
    // ========================================

    /**
     * Size presets disponibili per device
     * L'utente può specificare quale preset usare nel placeholder
     * Se non specificato, usa 'standard'
     */
    videoSizes: {
      desktop: {
        // 16:9 HD - Consigliato 2025 (moderno, alta qualità)
        'hd': {
          width: 640,
          height: 360,
          playerSize: [[640, 360]],
          description: '16:9 HD - Consigliato per video moderni'
        },

        // 4:3 Standard - Legacy (alta compatibilità SSP)
        'standard': {
          width: 640,
          height: 480,
          playerSize: [[640, 480]],
          description: '4:3 Standard - Massima compatibilità SSP (default)'
        },

        // 4:3 Compact - Performance (più veloce)
        'compact': {
          width: 400,
          height: 300,
          playerSize: [[400, 300]],
          description: '4:3 Compact - Ottimizzato per performance'
        }
      },

      mobile: {
        // 4:3 Standard - Consigliato mobile
        'standard': {
          width: 400,
          height: 300,
          playerSize: [[400, 300]],
          description: '4:3 Standard - Ottimale per mobile (default)'
        },

        // 4:3 Small - Dispositivi piccoli
        'small': {
          width: 320,
          height: 240,
          playerSize: [[320, 240]],
          description: '4:3 Small - Per dispositivi piccoli'
        },

        // IAB Banner - Max fill rate
        'banner': {
          width: 300,
          height: 250,
          playerSize: [[300, 250]],
          description: 'IAB Medium Rectangle - Massimo fill rate'
        }
      }
    },

    // Default preset se non specificato
    defaultSizePreset: 'standard',

    // Backward compatibility (deprecato - usa videoSizes)
    width: 640,
    height: 480,
    mobileWidth: 400,
    mobileHeight: 300,

    // ========================================
    // Playback Settings
    // ========================================

    autoPlay: true,
    muted: true, // Required per auto-play in Chrome
    loop: false,

    // ========================================
    // UI Settings
    // ========================================

    showCloseButton: true,
    closeDelay: 5, // secondi prima di mostrare close button
    showProgressBar: true,
    showVolumeControl: true,

    // ========================================
    // Sticky Positioning
    // ========================================

    stickyOffset: 20, // px di margine dai bordi dello schermo
    zIndex: 9999,

    // Mobile sticky adjustments
    mobileStickyOffset: 10,
    mobileZIndex: 9998,

    // ========================================
    // Animations
    // ========================================

    animationDuration: 300, // ms
    enableAnimations: true,

    // ========================================
    // VAST Settings
    // ========================================

    vastTimeout: 5000, // ms
    maxVastRedirects: 3,
    skipDelay: 5, // secondi prima di poter skippare

    // ========================================
    // Prebid Video Settings
    // ========================================

    prebidVideo: {
      // Context: instream (pre-roll), outstream (banner-like)
      context: 'outstream',

      // Placement: in-banner, in-article, in-feed
      placement: 2, // in-banner

      // Playback methods
      playbackmethod: [1], // 1 = auto-play sound off (compatibile con browser)

      // API frameworks
      api: [2], // 2 = VPAID 2.0

      // MIME types supportati
      mimes: ['video/mp4'],

      // Protocols
      protocols: [2, 3, 5, 6], // VAST 2.0, 3.0, VAST 2.0 Wrapper, VAST 3.0 Wrapper

      // Linearity
      linearity: 2, // 2 = non-linear/overlay

      // Min/Max duration
      minduration: 5,
      maxduration: 30,

      // Player size (desktop e mobile)
      playerSize: {
        desktop: [[640, 480]],
        mobile: [[400, 300]]
      },

      // Skip settings
      skip: 1, // 0 = no skip, 1 = skip available
      skipafter: 5 // secondi
    },

    // ========================================
    // SSP Video Support (Desktop vs Mobile)
    // ========================================

    ssp: {
      // AppNexus/Xandr Video
      appnexus: {
        enabled: false,  // Disabilitato - Usa solo Nexx360
        // Placement ID diversi per desktop/mobile
        desktop: {
          placementId: 35867983,
          slotCode: '/131207395/adhubmedia_owned_sites_nexx360_video_prebid_desktop'
        },
        mobile: {
          placementId: 35867984,
          slotCode: '/131207395/adhubmedia_owned_sites_nexx360_video_prebid_mobile'
        }
      },

      // Nexx360 Video
      // NOTA: I tagId sono gestiti automaticamente da AdHubSSPConfig
      // Questi valori sono mantenuti per backward compatibility
      nexx360: {
        enabled: true,
        // Tag ID diversi per desktop/mobile (da AdHubSSPConfig)
        desktop: {
          tagId: '7iellh0i',          // adhubmedia_owned_sites_nexx360_video_prebid_desktop
          videoTagId: '7iellh0i'
        },
        mobile: {
          tagId: 'oura2ehq',          // adhubmedia_owned_sites_nexx360_video_prebid_mobile
          videoTagId: 'oura2ehq'
        }
      },

      // Rubicon Video (se abilitato)
      rubicon: {
        enabled: false,
        video: {
          skip: 1,
          skipafter: 5,
          size_id: 201 // Outstream
        }
      },

      // PubMatic Video (se abilitato)
      pubmatic: {
        enabled: false,
        video: {
          mimes: ['video/mp4'],
          minduration: 5,
          maxduration: 30,
          protocols: [2, 3, 5, 6]
        }
      },

      // Index Exchange Video (se abilitato)
      ix: {
        enabled: false,
        video: {
          w: 640,
          h: 480,
          mimes: ['video/mp4']
        }
      }
    },

    // ========================================
    // Price Floors (Video)
    // Ottimizzati per mercato 2025 - Approccio bilanciato revenue/fill rate
    // Aggiornati: 2025-10-31
    // ========================================

    floors: {
      enabled: true,
      values: {
        // Desktop - Formati standard (aumentati per allineamento 2025)
        'video|640x480': 0.35, // Desktop video standard (era €0.30, +17%)
        'video|640x360': 0.35, // Desktop video HD 16:9 (nuovo)

        // Mobile - Formato standard (aumentato per qualità)
        'video|400x300': 0.30, // Mobile video standard (era €0.25, +20%)
        'video|320x240': 0.25, // Mobile video small (nuovo)

        // IAB standard mobile (max fill rate)
        'video|300x250': 0.25, // Mobile banner format (nuovo)

        // Fallback minimo video (aumentato per qualità minima)
        'video|*': 0.25 // Default video floor (era €0.20, +25%)
      }
    },

    // ========================================
    // Debug
    // ========================================

    debug: false, // Attiva con ?debug=video nell'URL

    // ========================================
    // Eventi Custom
    // ========================================

    events: {
      onLoad: null,      // function(adUnitCode) {}
      onPlay: null,      // function(adUnitCode) {}
      onPause: null,     // function(adUnitCode) {}
      onComplete: null,  // function(adUnitCode) {}
      onClose: null,     // function(adUnitCode) {}
      onError: null      // function(adUnitCode, error) {}
    }
  };

  // ============================================================================
  // HELPER FUNCTIONS
  // ============================================================================

  /**
   * Ottieni size config in base a preset e device
   *
   * @param {string} sizePreset - 'standard', 'hd', 'compact', 'small', 'banner'
   * @param {boolean} isMobile - true se mobile
   * @returns {object} Size config con width, height, playerSize
   */
  window.AdHubVideoConfig.getSizeConfig = function(sizePreset, isMobile) {
    const deviceType = isMobile ? 'mobile' : 'desktop';
    const preset = sizePreset || this.defaultSizePreset;

    // Verifica che il preset esista per questo device
    if (this.videoSizes[deviceType][preset]) {
      return this.videoSizes[deviceType][preset];
    }

    // Fallback a standard
    console.warn(`[AdHubVideoConfig] Preset "${preset}" non trovato per ${deviceType}, uso "standard"`);
    return this.videoSizes[deviceType]['standard'];
  };

  /**
   * Genera parametri video per bidder Prebid
   *
   * @param {string} position - Posizione video
   * @param {string} sizePreset - Preset size (opzionale)
   * @param {boolean} isMobile - Se mobile
   * @returns {object} Parametri Prebid video
   */
  window.AdHubVideoConfig.generateVideoParams = function(position, sizePreset, isMobile) {
    const videoConfig = this.prebidVideo;
    const deviceType = isMobile ? 'mobile' : 'desktop';

    // Ottieni size config
    const sizeConfig = this.getSizeConfig(sizePreset, isMobile);

    return {
      context: videoConfig.context,
      placement: videoConfig.placement,
      playbackmethod: videoConfig.playbackmethod,
      api: videoConfig.api,
      mimes: videoConfig.mimes,
      protocols: videoConfig.protocols,
      minduration: videoConfig.minduration,
      maxduration: videoConfig.maxduration,
      playerSize: sizeConfig.playerSize,
      skip: videoConfig.skip,
      skipafter: videoConfig.skipafter,
      linearity: videoConfig.linearity
    };
  };

  /**
   * Ottieni config SSP per video (con supporto desktop/mobile)
   */
  window.AdHubVideoConfig.getSSPVideoConfig = function(bidderName, isMobile) {
    if (!this.ssp[bidderName]) {
      return null;
    }

    const sspConfig = this.ssp[bidderName];

    if (!sspConfig.enabled) {
      return null;
    }

    const deviceType = isMobile ? 'mobile' : 'desktop';

    // Se ha config separata per device, usala
    if (sspConfig[deviceType]) {
      return sspConfig[deviceType];
    }

    // Altrimenti usa video generico (backward compatibility)
    return sspConfig.video || {};
  };

  /**
   * Verifica se un SSP supporta video
   */
  window.AdHubVideoConfig.isVideoEnabled = function(bidderName) {
    const sspConfig = this.ssp[bidderName];
    return sspConfig && sspConfig.enabled;
  };

  /**
   * Ottieni tutti gli SSP abilitati per video
   */
  window.AdHubVideoConfig.getEnabledVideoSSPs = function() {
    return Object.keys(this.ssp).filter(bidderName => {
      return this.isVideoEnabled(bidderName);
    });
  };

  /**
   * Mostra tutti i size presets disponibili
   */
  window.AdHubVideoConfig.listSizePresets = function() {
    console.group('📐 Video Size Presets Disponibili');

    console.group('🖥️  DESKTOP');
    Object.keys(this.videoSizes.desktop).forEach(preset => {
      const config = this.videoSizes.desktop[preset];
      console.log(`  ${preset}:`, `${config.width}x${config.height}`, `-`, config.description);
    });
    console.groupEnd();

    console.group('📱 MOBILE');
    Object.keys(this.videoSizes.mobile).forEach(preset => {
      const config = this.videoSizes.mobile[preset];
      console.log(`  ${preset}:`, `${config.width}x${config.height}`, `-`, config.description);
    });
    console.groupEnd();

    console.log('\n💡 Default preset:', this.defaultSizePreset);
    console.log('📖 Uso: ProfessioneMammaVideo.showStickyVideo("left", { sizePreset: "hd" })');

    console.groupEnd();
  };

  // ============================================================================
  // DEBUG
  // ============================================================================

  window.AdHubVideoConfig.debugConfig = function() {
    console.group('📹 AdHub Video Configuration');
    console.log('Dimensions:', {
      desktop: `${this.width}x${this.height}`,
      mobile: `${this.mobileWidth}x${this.mobileHeight}`
    });
    console.log('Playback:', {
      autoPlay: this.autoPlay,
      muted: this.muted,
      loop: this.loop
    });
    console.log('UI:', {
      closeButton: this.showCloseButton,
      closeDelay: this.closeDelay + 's'
    });
    console.log('Sticky:', {
      offset: this.stickyOffset + 'px',
      zIndex: this.zIndex
    });
    console.log('Prebid Video:', this.prebidVideo);
    console.log('Enabled SSPs:', this.getEnabledVideoSSPs());
    console.log('Price Floors:', this.floors);
    console.groupEnd();
  };

  // ============================================================================
  // AUTO-DETECTION
  // ============================================================================

  // Attiva debug se parametro URL presente
  if (window.location.search.indexOf('debug=video') !== -1) {
    window.AdHubVideoConfig.debug = true;
    window.AdHubVideoConfig.debugConfig();
  }

  console.log('[AdHubVideoConfig] ✅ Configurazione globale video caricata');

})();

// ============================================================================
// DYNAMIC PLACEHOLDERS MODULE (Deve essere prima di auto-init)
// ============================================================================

/**
 * AdHub Dynamic Placeholders Module
 * Inserisce automaticamente placeholder per ads nel contenuto della pagina
 *
 * Configurazione tramite script in pagina:
 * <script>
 * var AdHubDynamicPlaceholders = {
 *   enabled: true,
 *   max_insert: 3,
 *   min_paragraph_words: 70,
 *   target_selector: '.article-content, article, .post-content',
 *   ad_unit_code: 'adhub-in-article'
 * };
 * </script>
 *
 * @version 1.0.0
 * @date 2025-11-05
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__AdHubDynamicPlaceholdersLoaded) {
    console.warn('[AdHub DynamicPlaceholders] Modulo già caricato - Skip duplicato');
    return;
  }
  window.__AdHubDynamicPlaceholdersLoaded = true;

  const AdHubDynamicPlaceholders = {
    // ============================================================================
    // CONFIGURAZIONE DEFAULT
    // ============================================================================
    config: {
      // Abilita/disabilita inserimento dinamico
      enabled: false,

      // Numero massimo di placeholder da inserire
      max_insert: 3,

      // Numero minimo di parole per paragrafo valido
      min_paragraph_words: 70,

      // Selettore CSS del contenitore articolo (provati in ordine)
      target_selector: '.article-content, article, .post-content, .entry-content, main',

      // Template per ID placeholder (verrà aggiunto -1, -2, -3, ecc.)
      ad_unit_code: 'adhub-in-article',

      // Dopo quale paragrafo iniziare (1 = dopo il primo paragrafo)
      insert_after_paragraph: 2,

      // Ogni quanti paragrafi inserire un ad
      paragraph_interval: 3,

      // Distanza minima dall'inizio articolo (paragrafi)
      min_distance_from_start: 2,

      // Distanza minima dalla fine articolo (paragrafi)
      min_distance_from_end: 1,

      // CSS class da aggiungere ai placeholder generati
      placeholder_class: 'adhub-dynamic-placeholder',

      // Stile inline per placeholder (opzionale)
      placeholder_style: 'margin: 20px 0; min-height: 250px;',

      // Debug mode
      debug: false,

      // Selettore paragrafi da considerare
      paragraph_selector: 'p',

      // Escludi paragrafi che matchano questi selettori
      exclude_paragraph_selectors: [
        '.wp-caption-text',
        '.image-caption',
        '.author-bio',
        '.related-posts',
        'blockquote p',
        'aside p',
        'footer p'
      ]
    },

    state: {
      initialized: false,
      placeholdersInserted: [],
      articleContainer: null
    },

    /**
     * Inizializzazione del modulo
     */
    init: function(customConfig = {}) {
      if (this.state.initialized) {
        this.log('⚠️ Modulo già inizializzato');
        return;
      }

      // Merge configurazione da window.AdHubDynamicPlaceholders
      if (window.AdHubDynamicPlaceholders && typeof window.AdHubDynamicPlaceholders === 'object') {
        Object.assign(this.config, window.AdHubDynamicPlaceholders);
      }

      // Merge configurazione passata manualmente
      Object.assign(this.config, customConfig);

      // Se non abilitato, esci
      if (!this.config.enabled) {
        this.log('ℹ️ Modulo disabilitato (enabled: false)');
        return;
      }

      this.log('🚀 Inizializzazione modulo...');
      this.log('📋 Configurazione:', this.config);

      // Trova contenitore articolo
      this.state.articleContainer = this.findArticleContainer();

      if (!this.state.articleContainer) {
        this.log('⚠️ Nessun contenitore articolo trovato - Skip');
        return;
      }

      this.log('✅ Contenitore articolo trovato:', this.state.articleContainer);

      // Inserisci placeholder
      this.insertPlaceholders();

      this.state.initialized = true;
      this.log('✅ Modulo inizializzato');

      // Dispatch evento per altri moduli
      window.dispatchEvent(new CustomEvent('adhub:dynamic-placeholders:ready', {
        detail: {
          placeholders: this.state.placeholdersInserted
        }
      }));
    },

    /**
     * Trova il contenitore principale dell'articolo
     */
    findArticleContainer: function() {
      const selectors = this.config.target_selector.split(',').map(s => s.trim());

      for (const selector of selectors) {
        const container = document.querySelector(selector);
        if (container) {
          this.log(`📍 Contenitore trovato con selettore: "${selector}"`);
          return container;
        }
      }

      return null;
    },

    /**
     * Trova tutti i paragrafi validi nell'articolo
     */
    findValidParagraphs: function() {
      const container = this.state.articleContainer;
      if (!container) return [];

      // Trova tutti i paragrafi
      const allParagraphs = Array.from(container.querySelectorAll(this.config.paragraph_selector));

      // Filtra paragrafi validi
      const validParagraphs = allParagraphs.filter(p => {
        // Escludi paragrafi che matchano selettori di esclusione
        for (const excludeSelector of this.config.exclude_paragraph_selectors) {
          if (p.matches(excludeSelector) || p.closest(excludeSelector.split(' ')[0])) {
            return false;
          }
        }

        // Conta parole nel paragrafo
        const text = p.textContent.trim();
        const wordCount = text.split(/\s+/).filter(w => w.length > 0).length;

        // Escludi paragrafi troppo corti
        if (wordCount < this.config.min_paragraph_words) {
          if (this.config.debug) {
            this.log(`⏭️ Skip paragrafo (${wordCount} parole):`, text.substring(0, 50) + '...');
          }
          return false;
        }

        return true;
      });

      this.log(`📊 Paragrafi totali: ${allParagraphs.length}, validi: ${validParagraphs.length}`);

      return validParagraphs;
    },

    /**
     * Calcola posizioni ottimali per inserimento placeholder
     */
    calculateInsertionPositions: function(paragraphs) {
      const positions = [];
      const totalParagraphs = paragraphs.length;

      // Verifica che ci siano abbastanza paragrafi
      const minParagraphsNeeded = this.config.min_distance_from_start +
                                  this.config.min_distance_from_end + 1;

      if (totalParagraphs < minParagraphsNeeded) {
        this.log(`⚠️ Paragrafi insufficienti (${totalParagraphs} < ${minParagraphsNeeded})`);
        return positions;
      }

      // Calcola range valido
      const startIndex = Math.max(this.config.insert_after_paragraph, this.config.min_distance_from_start);
      const endIndex = totalParagraphs - this.config.min_distance_from_end;

      this.log(`📐 Range valido: paragrafo ${startIndex} → ${endIndex}`);

      // Genera posizioni con intervallo
      let currentIndex = startIndex;
      let insertCount = 0;

      while (currentIndex < endIndex && insertCount < this.config.max_insert) {
        positions.push(currentIndex);
        insertCount++;
        currentIndex += this.config.paragraph_interval;
      }

      this.log(`📍 Posizioni calcolate: ${positions.join(', ')}`);

      return positions;
    },

    /**
     * Crea un elemento placeholder
     */
    createPlaceholder: function(index) {
      const div = document.createElement('div');
      const placeholderId = `${this.config.ad_unit_code}-${index}`;

      div.id = placeholderId;
      div.className = this.config.placeholder_class;

      if (this.config.placeholder_style) {
        div.setAttribute('style', this.config.placeholder_style);
      }

      // Aggiungi data attribute per tracciamento
      div.setAttribute('data-adhub-dynamic', 'true');
      div.setAttribute('data-adhub-position', index);

      this.log(`✨ Placeholder creato: #${placeholderId}`);

      return div;
    },

    /**
     * Inserisce i placeholder nel contenuto
     */
    insertPlaceholders: function() {
      // Trova paragrafi validi
      const paragraphs = this.findValidParagraphs();

      if (paragraphs.length === 0) {
        this.log('⚠️ Nessun paragrafo valido trovato');
        return;
      }

      // Calcola posizioni
      const positions = this.calculateInsertionPositions(paragraphs);

      if (positions.length === 0) {
        this.log('⚠️ Nessuna posizione valida per inserimento');
        return;
      }

      // Inserisci placeholder
      this.log(`📍 Inserimento ${positions.length} placeholder...`);

      positions.forEach((position, index) => {
        const paragraph = paragraphs[position];
        const placeholder = this.createPlaceholder(index + 1);

        // Inserisci dopo il paragrafo
        if (paragraph.nextSibling) {
          paragraph.parentNode.insertBefore(placeholder, paragraph.nextSibling);
        } else {
          paragraph.parentNode.appendChild(placeholder);
        }

        // Traccia placeholder inserito
        this.state.placeholdersInserted.push({
          id: placeholder.id,
          element: placeholder,
          afterParagraph: position,
          paragraphText: paragraph.textContent.substring(0, 100) + '...'
        });

        this.log(`✅ Inserito #${placeholder.id} dopo paragrafo ${position}`);
      });

      this.log(`✅ Inseriti ${this.state.placeholdersInserted.length} placeholder`);

      // Log riepilogo in debug mode
      if (this.config.debug) {
        console.group('📊 Riepilogo Placeholder Inseriti');
        this.state.placeholdersInserted.forEach(p => {
          console.log(`#${p.id} → dopo paragrafo ${p.afterParagraph}`);
          console.log(`  Testo: ${p.paragraphText}`);
        });
        console.groupEnd();
      }
    },

    /**
     * Ottieni stato corrente
     */
    getState: function() {
      return {
        initialized: this.state.initialized,
        placeholdersInserted: this.state.placeholdersInserted.map(p => ({
          id: p.id,
          afterParagraph: p.afterParagraph
        })),
        config: this.config
      };
    },

    /**
     * Rimuovi tutti i placeholder dinamici
     */
    removePlaceholders: function() {
      this.log('🗑️ Rimozione placeholder dinamici...');

      this.state.placeholdersInserted.forEach(p => {
        if (p.element && p.element.parentNode) {
          p.element.parentNode.removeChild(p.element);
          this.log(`❌ Rimosso #${p.id}`);
        }
      });

      this.state.placeholdersInserted = [];
      this.log('✅ Tutti i placeholder rimossi');
    },

    /**
     * Reinizializza con nuova configurazione
     */
    reinit: function(newConfig = {}) {
      this.log('🔄 Reinizializzazione...');

      // Rimuovi placeholder esistenti
      this.removePlaceholders();

      // Reset stato
      this.state.initialized = false;

      // Reinizializza con nuova config
      this.init(newConfig);
    },

    /**
     * Helper per logging
     */
    log: function(...args) {
      if (this.config.debug) {
        console.log('[AdHub DynamicPlaceholders]', ...args);
      }
    }
  };

  // Esporta globalmente
  window.AdHubDynamicPlaceholders = AdHubDynamicPlaceholders;

  // Auto-init quando DOM è pronto
  // IMPORTANTE: Deve eseguire PRIMA di adhub-auto-init.js
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function() {
      AdHubDynamicPlaceholders.init();
    });
  } else {
    // DOM già pronto, inizializza immediatamente
    AdHubDynamicPlaceholders.init();
  }

  console.log('[AdHub DynamicPlaceholders] ✅ Modulo caricato');

})();

// ============================================================================
// AUTO-INIT ORCHESTRATOR (Deve essere dopo dynamic-placeholders)
// ============================================================================

/**
 * AdHub Auto-Init Module
 * Orchestratore che gestisce l'inizializzazione automatica completa del sistema
 *
 * Flusso:
 * 1. Attende consenso CMP
 * 2. Inizializza Prebid con ad units
 * 3. Avvia auction Prebid
 * 4. Passa targeting a GAM
 * 5. Richiede ads da GAM
 *
 * @version 1.0.0
 * @date 2025-10-30
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__AdHubAutoInitLoaded) {
    console.warn('[AdHub AutoInit] Modulo già caricato - Skip duplicato');
    return;
  }
  window.__AdHubAutoInitLoaded = true;

  const AdHubAutoInit = {
    config: {
      // Timeout per inizializzazione (ms)
      initTimeout: 15000,

      // Debug mode
      debug: false,

      // Auto-start dopo consenso
      autoStart: true,

      // Prebid auction timeout
      auctionTimeout: 2000,

      // Refresh automatico degli slot (0 = disabled)
      autoRefreshInterval: 0,

      // Analytics module (opzionale)
      analytics: {
        enabled: false,       // Abilita analytics
        ga4Enabled: true,     // Usa GA4 del sito
        debug: false,         // Debug analytics
        samplingRate: 1.0     // 100% tracking
      }
    },

    state: {
      consentReceived: false,
      prebidInitialized: false,
      gamInitialized: false,
      auctionCompleted: false,
      adsRequested: false,
      initialized: false
    },

    /**
     * Inizializzazione del sistema
     */
    init: function(customConfig = {}) {
      if (this.state.initialized) {
        console.warn('[AdHub AutoInit] Sistema già inizializzato');
        return;
      }

      // Merge config da window.AdHubAutoInitConfig (se presente)
      if (window.AdHubAutoInitConfig) {
        if (window.AdHubAutoInitConfig.analytics) {
          Object.assign(this.config.analytics, window.AdHubAutoInitConfig.analytics);
        }
        // Merge altre proprietà
        Object.keys(window.AdHubAutoInitConfig).forEach(key => {
          if (key !== 'analytics' && this.config.hasOwnProperty(key)) {
            this.config[key] = window.AdHubAutoInitConfig[key];
          }
        });
      }

      // Merge config passata manualmente
      if (customConfig.analytics) {
        Object.assign(this.config.analytics, customConfig.analytics);
      }
      Object.assign(this.config, customConfig);

      this.log('🚀 Inizializzazione sistema AdHub...');

      // Aspetta che tutti i moduli siano caricati
      this.waitForModules(() => {
        this.log('✅ Moduli caricati');

        // Ascolta eventi di consenso
        this.setupConsentListeners();

        this.state.initialized = true;
      });
    },

    /**
     * Aspetta che tutti i moduli necessari siano caricati
     */
    waitForModules: function(callback) {
      const checkModules = () => {
        const modulesReady = (
          window.AdHubCMP &&
          window.AdHubGAM &&
          typeof pbjs !== 'undefined'
        );

        if (modulesReady) {
          callback();
        } else {
          setTimeout(checkModules, 100);
        }
      };

      checkModules();
    },

    /**
     * Setup listeners per eventi di consenso e Prebid
     */
    setupConsentListeners: function() {
      this.log('👂 Ascolto eventi di consenso...');

      // Ascolta anche evento Prebid ready (se il sito configura Prebid manualmente)
      window.addEventListener('adhub:prebid:ready', (event) => {
        this.log('📊 Prebid configurato dal sito');
        this.prebidConfiguredBySite = true;
        this.siteAdUnits = event.detail?.adUnits || [];
      });

      // Consenso ricevuto
      window.addEventListener('adhub:consent:ready', (event) => {
        this.log('✅ Consenso ricevuto');
        this.state.consentReceived = true;

        if (event.detail && event.detail.consentGiven) {
          this.startAdSystem();
        } else {
          this.log('⚠️ Consenso negato - Sistema bloccato');
        }
      });

      // Nessuna CMP rilevata (procedi comunque se strict mode disabled)
      window.addEventListener('adhub:consent:nocmp', () => {
        const cmpConfig = window.AdHubCMP.getConfig();
        if (!cmpConfig.STRICT_MODE) {
          this.log('⚠️ Nessuna CMP - Procedo (strict mode disabled)');
          this.state.consentReceived = true;
          this.startAdSystem();
        } else {
          this.log('❌ Nessuna CMP - Sistema bloccato (strict mode enabled)');
        }
      });

      // Consenso negato
      window.addEventListener('adhub:consent:denied', () => {
        this.log('❌ Consenso negato - Annunci disabilitati');
      });
    },

    /**
     * Avvia il sistema pubblicitario completo
     */
    startAdSystem: function() {
      this.log('🎯 Avvio sistema pubblicitario...');

      // Step 0: Inizializza Analytics se abilitato
      this.initAnalyticsIfEnabled();

      // Step 1: Verifica che ci siano placeholder in pagina
      const placeholders = this.findAdPlaceholders();
      if (placeholders.length === 0) {
        this.log('⚠️ Nessun placeholder trovato in pagina - Skip inizializzazione');
        return;
      }

      this.log(`📍 Trovati ${placeholders.length} placeholder:`, placeholders.map(p => p.id));

      // Step 2: Inizializza Prebid con auction automatica
      this.initPrebidAndRunAuction(placeholders, () => {
        // Step 3: Dopo auction, inizializza GAM e richiedi ads
        this.initGAMAndRequestAds(placeholders);
      });
    },

    /**
     * Inizializza modulo Analytics se abilitato
     */
    initAnalyticsIfEnabled: function() {
      if (!this.config.analytics.enabled) {
        this.log('📊 Analytics disabilitato');
        return;
      }

      if (!window.AdHubAnalytics) {
        this.log('⚠️ Modulo AdHubAnalytics non trovato - Skip');
        return;
      }

      this.log('📊 Inizializzazione Analytics...');

      try {
        window.AdHubAnalytics.init({
          enabled: true,
          ga4Enabled: this.config.analytics.ga4Enabled,
          debug: this.config.analytics.debug,
          samplingRate: this.config.analytics.samplingRate,
          events: {
            bidWon: true,
            bidTimeout: true,
            auctionEnd: true,
            bidResponse: false,
            adRenderFailed: true
          }
        });

        this.log('✅ Analytics inizializzato');
      } catch (error) {
        this.log('❌ Errore inizializzazione Analytics:', error);
      }
    },

    /**
     * Trova tutti i placeholder per ads in pagina
     */
    findAdPlaceholders: function() {
      const placeholders = [];

      // Cerca tutti i div con id che inizia con 'adhub-' o 'ad-'
      const divs = document.querySelectorAll('div[id^="adhub-"], div[id^="ad-"]');

      divs.forEach(div => {
        // Aggiungi tutti i placeholder trovati (anche se nascosti)
        if (div.id) {
          placeholders.push({
            id: div.id,
            element: div
          });
        }
      });

      return placeholders;
    },

    /**
     * Inizializza Prebid e avvia auction automaticamente
     */
    initPrebidAndRunAuction: function(placeholders, callback) {
      this.log('📊 Inizializzazione Prebid...');

      if (typeof pbjs === 'undefined') {
        this.log('❌ Prebid.js non caricato');
        if (callback) callback();
        return;
      }

      // Aspetta che Prebid sia configurato (dal sito o già caricato)
      const waitForPrebidConfig = () => {
        pbjs.que.push(() => {
          // Verifica se il sito ha configurato Prebid
          if (this.prebidConfiguredBySite && this.siteAdUnits && this.siteAdUnits.length > 0) {
            this.log(`✅ Prebid configurato dal sito con ${this.siteAdUnits.length} ad units`);
          } else {
            this.log('⚠️ Nessun ad unit Prebid configurato - Procedo solo con GAM');
            if (callback) callback();
            return;
          }

          this.state.prebidInitialized = true;

          // Avvia auction
          this.log('🎲 Avvio auction Prebid...');

          const adUnitCodes = placeholders.map(p => p.id);

          pbjs.requestBids({
            adUnitCodes: adUnitCodes,
            timeout: this.config.auctionTimeout,
            bidsBackHandler: (bids) => {
              this.log('✅ Auction Prebid completata');
              this.state.auctionCompleted = true;

              // Log bids ricevute
              const bidCount = Object.keys(bids).length;
              this.log(`📥 Ricevute ${bidCount} risposte dai bidder`);

              if (this.config.debug) {
                console.log('[AdHub AutoInit] Bids:', bids);
              }

              // Chiama callback per procedere con GAM
              if (callback) callback();
            }
          });
        });
      };

      // Se Prebid è già configurato dal sito, avvia subito
      // Altrimenti aspetta un attimo che si configuri
      if (this.prebidConfiguredBySite) {
        waitForPrebidConfig();
      } else {
        // Aspetta 500ms per dare tempo al config del sito di configurare Prebid
        setTimeout(() => {
          waitForPrebidConfig();
        }, 500);
      }
    },

    /**
     * Inizializza GAM e richiede ads
     */
    initGAMAndRequestAds: function(placeholders) {
      this.log('📢 Inizializzazione GAM...');

      if (!window.AdHubGAM) {
        this.log('❌ AdHubGAM non caricato');
        return;
      }

      // Se GAM non è inizializzato E autoInit è disabilitato, inizializzalo manualmente
      if (!window.AdHubGAM.isInitialized || !window.AdHubGAM.isInitialized()) {
        // Controlla se autoInit è disabilitato nella configurazione
        const gamConfig = window.AdHubGAMConfig;
        if (gamConfig && gamConfig.autoInit === false) {
          this.log('🔧 AutoInit disabilitato in GAM config - Inizializzazione manuale...');
          try {
            window.AdHubGAM.init();
            // Attendi che l'inizializzazione completi
            setTimeout(() => {
              this.initGAMAndRequestAds(placeholders);
            }, 100);
            return;
          } catch (e) {
            this.log('❌ Errore inizializzazione GAM:', e);
          }
        }

        this.log('⚠️ GAM non ancora inizializzato - Attesa...');
        setTimeout(() => {
          this.initGAMAndRequestAds(placeholders);
        }, 500);
        return;
      }

      this.log('✅ GAM inizializzato');
      this.state.gamInitialized = true;

      // Imposta targeting Prebid su GAM
      if (typeof pbjs !== 'undefined' && this.state.auctionCompleted) {
        this.log('🎯 Applicazione targeting Prebid a GAM...');

        pbjs.que.push(() => {
          pbjs.setTargetingForGPTAsync();
          this.log('✅ Targeting Prebid applicato a GAM');
        });
      }

      // Richiedi ads per tutti gli slot
      this.log('📞 Richiesta ads a GAM...');

      try {
        window.AdHubGAM.requestAds();
        this.state.adsRequested = true;
        this.log('✅ Ads richieste a GAM');

        // Setup auto-refresh se configurato
        if (this.config.autoRefreshInterval > 0) {
          this.setupAutoRefresh(placeholders);
        }
      } catch (error) {
        this.log('❌ Errore richiesta ads:', error);
      }
    },

    /**
     * Setup auto-refresh degli slot
     */
    setupAutoRefresh: function(placeholders) {
      this.log(`🔄 Auto-refresh abilitato (${this.config.autoRefreshInterval}ms)`);

      setInterval(() => {
        this.log('🔄 Refresh automatico degli slot...');

        // Ri-avvia auction Prebid
        this.initPrebidAndRunAuction(placeholders, () => {
          // Refresh GAM slots
          window.AdHubGAM.refreshAllSlots();
        });
      }, this.config.autoRefreshInterval);
    },

    /**
     * Helper per logging
     */
    log: function(...args) {
      console.log('[AdHub AutoInit]', ...args);
    },

    /**
     * Get stato corrente
     */
    getState: function() {
      return {
        ...this.state,
        config: this.config
      };
    }
  };

  // Esporta globalmente
  window.AdHubAutoInit = AdHubAutoInit;

  // Auto-init solo se non esplicitamente disabilitato
  // Per disabilitarlo, impostare window.AdHubAutoInitConfig = { autoStart: false }
  const shouldAutoStart = !window.AdHubAutoInitConfig ||
                          window.AdHubAutoInitConfig.autoStart !== false;

  if (shouldAutoStart) {
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', () => {
        AdHubAutoInit.init();
      });
    } else {
      AdHubAutoInit.init();
    }
    console.log('[AdHub AutoInit] ✅ Modulo caricato (auto-start abilitato)');
  } else {
    console.log('[AdHub AutoInit] ✅ Modulo caricato (auto-start disabilitato)');
  }

})();

// ============================================================================
// SITE CONFIGURATION
// ============================================================================

/**
 * AdHubMedia.com - Site Configuration
 *
 * Questo file contiene SOLO la configurazione specifica del sito:
 * - Ad Units
 * - Targeting personalizzato
 *
 * La config Prebid globale è in /config/prebid-config.js
 * Le credenziali SSP sono in /config/ssp-credentials.js (con override opzionale)
 *
 * @version 1.0.0
 * @date 2024-11-04
 */

(function() {
  'use strict';

  // PROTEZIONE CONTRO DOPPIO CARICAMENTO
  if (window.__adHubMediaConfigLoaded) {
    console.warn('[AdHubMedia] Config già caricata - Skip duplicato');
    return;
  }
  window.__adHubMediaConfigLoaded = true;

  // Verifica che i moduli siano caricati
  if (!window.AdHubSSPConfig) {
    console.warn('[AdHubMedia] SSP Config module not yet loaded - config will initialize when available');
  }

  if (!window.AdHubPrebidConfig) {
    console.warn('[AdHubMedia] Prebid Config globale non caricata - verrà caricata dal bundle');
  }

  // Nome del sito per il sistema di configurazione
  const SITE_NAME = 'adhubmedia';

  // Debug: mostra configurazione SSP per questo sito
  if (window.location.search.indexOf('debug=ssp') !== -1) {
    AdHubSSPConfig.debugConfig(SITE_NAME);
  }

  // ============================================================================
  // AD UNITS (SPECIFICHE DEL SITO)
  // ============================================================================

  /**
   * Definizione Ad Units per AdHubMedia.com
   */
  const adHubMediaAdUnits = [
    {
      code: 'adhub-top-banner',
      mediaTypes: {
        banner: {
          sizes: [[970, 250], [728, 90], [320, 100], [320, 50]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [970, 0],
          sizes: [[970, 250], [728, 90]]
        },
        {
          minViewPort: [728, 0],
          sizes: [[728, 90]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[320, 100], [320, 50]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'top-banner', [[970, 250], [728, 90], [320, 100], [320, 50]])
    },

    {
      code: 'adhub-sidebar',
      mediaTypes: {
        banner: {
          sizes: [[300, 250], [300, 600]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [768, 0],
          sizes: [[300, 250], [300, 600]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[300, 250]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'sidebar', [[300, 250], [300, 600]])
    },

    {
      code: 'adhub-in-article',
      mediaTypes: {
        banner: {
          sizes: [[300, 250], [336, 280]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [375, 0],
          sizes: [[300, 250], [336, 280]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[300, 250]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'in-article', [[300, 250], [336, 280]])
    },

    {
      code: 'adhub-sticky-bottom',
      mediaTypes: {
        banner: {
          sizes: [[728, 90], [320, 50]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [728, 0],
          sizes: [[728, 90]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[320, 50]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'sticky-bottom', [[728, 90], [320, 50]])
    },

    {
      code: 'adhub-728x90-banner',
      mediaTypes: {
        banner: {
          sizes: [[728, 90], [300, 250]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [768, 0],
          sizes: [[728, 90]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[300, 250]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, '728x90-banner', [[728, 90], [300, 250]])
    },

    {
      code: 'adhub-300x250-top',
      mediaTypes: {
        banner: {
          sizes: [[300, 250]]
        }
      },
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'article-top', [[300, 250]])
    },

    {
      code: 'adhub-300x250-mid',
      mediaTypes: {
        banner: {
          sizes: [[300, 250]]
        }
      },
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'article-mid', [[300, 250]])
    },

    {
      code: 'adhub-300x250-bottom',
      mediaTypes: {
        banner: {
          sizes: [[300, 250]]
        }
      },
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'article-bottom', [[300, 250]])
    },

    // ========================================
    // Additional In-Article Positions (same GAM tag)
    // ========================================
    {
      code: 'adhub-in-article-1',
      mediaTypes: {
        banner: {
          sizes: [[300, 250], [336, 280]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [375, 0],
          sizes: [[300, 250], [336, 280]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[300, 250]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'in-article-1', [[300, 250], [336, 280]])
    },

    {
      code: 'adhub-in-article-2',
      mediaTypes: {
        banner: {
          sizes: [[300, 250], [336, 280]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [375, 0],
          sizes: [[300, 250], [336, 280]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[300, 250]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'in-article-2', [[300, 250], [336, 280]])
    },

    {
      code: 'adhub-in-article-3',
      mediaTypes: {
        banner: {
          sizes: [[300, 250], [336, 280]]
        }
      },
      sizeConfig: [
        {
          minViewPort: [375, 0],
          sizes: [[300, 250], [336, 280]]
        },
        {
          minViewPort: [0, 0],
          sizes: [[300, 250]]
        }
      ],
      bids: AdHubSSPConfig.generateBidderParams(SITE_NAME, 'in-article-3', [[300, 250], [336, 280]])
    }
  ];



  // ============================================================================
  // DYNAMIC TAGS (OPZIONALE)
  // ============================================================================

  /**
   * Configurazione Tag Dinamici
   * Questi tag vengono iniettati nel DOM prima del caricamento di GAM
   * per supportare formati speciali come video sticky, skin, interstitial, ecc.
   *
   * Se questa configurazione è presente, il modulo adhub-dynamic-tags.js
   * la utilizzerà per iniettare i container necessari.
   */
  window.AdHubDynamicTagsConfig = {
    enabled: true,
    debug: false,  // Metti true per vedere log dettagliati

    tags: [
      // Esempio: Video Sticky
      {
        type: 'video-sticky',
        enabled: true,
        targetSelector: 'body',
        position: 'beforeend',
        html: '<div id="player3" data-adhub-video="sticky-right" data-width="300px"></div>'
        // condition: function() {
        //   // Solo desktop
        //   return window.innerWidth >= 1024;
        // }
      }

      // Esempio: Skin/Wallpaper (commentato - decommentare per attivare)
      // {
      //   type: 'skin',
      //   enabled: true,
      //   targetSelector: 'body',
      //   position: 'afterbegin',
      //   html: '<div id="adhub-skin-left" style="position: fixed; left: 0; top: 0; width: 160px; height: 600px; z-index: 1;"></div>' +
      //         '<div id="adhub-skin-right" style="position: fixed; right: 0; top: 0; width: 160px; height: 600px; z-index: 1;"></div>',
      //   condition: function() {
      //     // Solo desktop large (>= 1440px)
      //     return window.innerWidth >= 1440;
      //   }
      // },

      // Esempio: Interstitial (commentato - decommentare per attivare)
      // {
      //   type: 'interstitial',
      //   enabled: true,
      //   targetSelector: 'body',
      //   position: 'beforeend',
      //   html: '<div id="adhub-interstitial" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 99999;">' +
      //         '  <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px;">' +
      //         '    <div id="adhub-interstitial-content"></div>' +
      //         '    <button onclick="document.getElementById(\'adhub-interstitial\').style.display=\'none\'" style="position: absolute; top: 10px; right: 10px;">✕</button>' +
      //         '  </div>' +
      //         '</div>',
      //   condition: function() {
      //     // Solo su alcune pagine o dopo tot secondi
      //     return document.querySelector('article') !== null;
      //   }
      // },

      // Esempio: Native In-Feed multipli
      // {
      //   type: 'native-in-feed',
      //   enabled: true,
      //   targetSelector: 'article .entry-content p',  // Trova tutti i paragrafi
      //   position: 'afterend',
      //   html: '<div class="adhub-native-feed" style="margin: 20px 0;"></div>',
      //   condition: function() {
      //     // Inserisci solo se ci sono abbastanza paragrafi
      //     return document.querySelectorAll('article .entry-content p').length >= 5;
      //   }
      // }
    ]
  };

  // ============================================================================
  // TARGETING PERSONALIZZATO (OPZIONALE)
  // ============================================================================

  /**
   * Targeting personalizzato per AdHubMedia.com
   * Questi valori saranno inviati a GAM e ai bidder
   */
  function getAdHubMediaTargeting() {
    const targeting = {};

    // Categoria dalla pagina
    const metaCategory = document.querySelector('meta[name="category"]');
    if (metaCategory) {
      targeting.category = metaCategory.content;
    }

    // Sezione dalla pagina
    const metaSection = document.querySelector('meta[name="section"]');
    if (metaSection) {
      targeting.section = metaSection.content;
    }

    // URL path
    targeting.path = window.location.pathname.split('/').filter(Boolean)[0] || 'home';

    return targeting;
  }

  // ============================================================================
  // INIZIALIZZAZIONE PREBID
  // ============================================================================

  /**
   * Inizializza Prebid.js per AdHubMedia
   * Usa la configurazione globale da /config/prebid-config.js
   */
  function initAdHubMediaPrebid() {
    if (!window.AdHubPrebidConfig) {
      console.error('[AdHubMedia] AdHubPrebidConfig non caricato!');
      return;
    }

    console.log('[AdHubMedia] 🚀 Inizializzazione Prebid...');

    // Applica la config Prebid globale
    // (già configurata con timeout, floors, user IDs, consent, etc.)
    if (window.AdHubPrebidConfig.apply) {
      window.AdHubPrebidConfig.apply();
      console.log('[AdHubMedia] ✅ Config Prebid globale applicata');
    }

    // Aggiungi ad units al sistema
    if (window.AdHubPrebid && window.AdHubPrebid.registerAdUnits) {
      window.AdHubPrebid.registerAdUnits(adHubMediaAdUnits);
      console.log('[AdHubMedia] ✅ Ad units registrate:', adHubMediaAdUnits.length);
    } else {
      console.warn('[AdHubMedia] ⚠️ AdHubPrebid.registerAdUnits non disponibile');
    }

    // Rileva e registra ad units per placeholder legacy
    if (window.AdHubPrebid && window.AdHubPrebid.detectAndCreateLegacyAdUnits) {
      window.AdHubPrebid.detectAndCreateLegacyAdUnits();
      console.log('[AdHubMedia] ✅ Rilevamento placeholder legacy completato');
    }

    // Applica targeting personalizzato
    const customTargeting = getAdHubMediaTargeting();
    if (Object.keys(customTargeting).length > 0) {
      console.log('[AdHubMedia] 🎯 Targeting personalizzato:', customTargeting);

      // Il targeting verrà applicato da AdHubGAM quando inizializza
      window.adHubMediaTargeting = customTargeting;
    }

    // Emetti evento per notificare che Prebid è pronto
    const event = new CustomEvent('adhub:prebid:ready', {
      detail: {
        site: SITE_NAME,
        adUnits: adHubMediaAdUnits.length,
        targeting: customTargeting
      }
    });
    window.dispatchEvent(event);

    console.log('[AdHubMedia] ✅ Prebid ready - Evento emesso');
  }

  // ============================================================================
  // AUTO-INIT
  // ============================================================================

  /**
   * Inizializza automaticamente quando il DOM è pronto
   * L'orchestrator AutoInit gestirà il consenso e l'ordine di caricamento
   */
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initAdHubMediaPrebid);
  } else {
    initAdHubMediaPrebid();
  }

  console.log('[AdHubMedia] ✅ Config caricata');

  // ============================================================================
  // PLAYLIST MIGRATION (LEGACY → NEW FORMAT)
  // ============================================================================

  /**
   * Migra i vecchi placeholder playlist al nuovo formato
   * Cerca: <div id="adhub-player" playlist="CODICE"></div>
   * Trasforma in: <div id="my-playlist-X" data-adhub-playlist="in-content" data-playlist-code="CODICE" data-enable-ads="true" data-width="350px"></div>
   */
  function migratePlaylistPlaceholders() {
    // Trova tutti i div con id="adhub-player" E attributo playlist
    const oldPlaylists = document.querySelectorAll('div[id="adhub-player"][playlist]');

    if (oldPlaylists.length === 0) {
      return;
    }

    console.log('[AdHubMedia] 🔄 Trovati ' + oldPlaylists.length + ' playlist da migrare');

    oldPlaylists.forEach(function(oldDiv, index) {
      const playlistCode = oldDiv.getAttribute('playlist');

      if (!playlistCode) {
        console.warn('[AdHubMedia] ⚠️ Playlist senza codice, skip');
        return;
      }

      // Crea nuovo div con formato aggiornato
      const newDiv = document.createElement('div');
      newDiv.id = 'my-playlist-' + (index + 1);
      newDiv.setAttribute('data-adhub-playlist', 'in-content');
      newDiv.setAttribute('data-playlist-code', playlistCode);
      newDiv.setAttribute('data-enable-ads', 'true');
      newDiv.setAttribute('data-width', '350px');

      // Copia classi CSS se presenti
      if (oldDiv.className) {
        newDiv.className = oldDiv.className;
      }

      // Sostituisci il vecchio div con il nuovo
      oldDiv.parentNode.replaceChild(newDiv, oldDiv);

      console.log('[AdHubMedia] ✅ Playlist migrata: ' + playlistCode + ' → ' + newDiv.id);
    });

    console.log('[AdHubMedia] 🎉 Migrazione playlist completata');
  }

  // Esegui migrazione quando il DOM è pronto
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', migratePlaylistPlaceholders);
  } else {
    migratePlaylistPlaceholders();
  }

  // ============================================================================
  // DEBUG UTILITIES (OPZIONALI)
  // ============================================================================

  /**
   * Utility per debug in console
   * Uso: AdHubMediaDebug.getBids()
   */
  window.AdHubMediaDebug = {
    getConfig: function() {
      return {
        site: SITE_NAME,
        adUnits: adHubMediaAdUnits,
        targeting: getAdHubMediaTargeting()
      };
    },

    showSSPConfig: function() {
      if (window.AdHubSSPConfig) {
        AdHubSSPConfig.debugConfig(SITE_NAME);
      }
    },

    getBids: function() {
      if (window.pbjs && window.pbjs.getBidResponses) {
        return window.pbjs.getBidResponses();
      }
      console.warn('Prebid.js not loaded yet');
      return null;
    },

    getTargeting: function() {
      return getAdHubMediaTargeting();
    },

    testBidder: function(bidderName) {
      console.log('[AdHubMedia Debug] Testing bidder:', bidderName);
      const testUnit = adHubMediaAdUnits[0];
      const bidderConfig = testUnit.bids.find(b => b.bidder === bidderName);

      if (bidderConfig) {
        console.log('✅ Bidder configurato:', bidderConfig);
      } else {
        console.warn('❌ Bidder non trovato:', bidderName);
      }
    }
  };

  // ============================================================================
  // ANALYTICS CONFIGURATION
  // ============================================================================

  /**
   * Configurazione modulo Analytics (opzionale)
   * Abilita tracking eventi Prebid verso Google Analytics 4
   */
  window.AdHubAutoInitConfig = window.AdHubAutoInitConfig || {};
  window.AdHubAutoInitConfig.analytics = {
    enabled: true,        // ✅ ABILITATO per AdHubMedia
    ga4Enabled: true,     // Usa GA4 del sito
    debug: false,         // Metti true per vedere log dettagliati
    samplingRate: 1.0     // 100% tracking (usa 0.1 per 10% se molto traffico)
  };

  console.log('[AdHubMedia] 📊 Analytics: ABILITATO');

})();

// ============================================================================
// VIDEO PLAYLISTS DATA (Static)
// ============================================================================

/**
 * Video Playlists Data - Static Configuration
 *
 * Dati playlist hardcoded internamente al progetto.
 * Non richiede chiamate API esterne.
 *
 * @version 1.0.0
 * @date 2025-11-03
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.__AdHubVideoPlaylistsData) {
    console.warn('[AdHub Playlists Data] Già caricato');
    return;
  }

  /**
   * Playlists statiche con video S3
   */
  const PLAYLISTS_DATA = {

    // ========================================
    // VIRAL - Lifestyle
    // ========================================
    viral: {
      name: 'Lifestyle Viral',
      videos: [
        {
          name: 'Acne, parliamone!',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/lifestyle_farmacista_acne_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/lifestyle_farmacista_acne_notizie.jpg',
          duration: 267
        },
        {
          name: 'Che ansia!',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/lifestyle_farmacista_ansia_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/lifestyle_farmacista_ansia_notizie.jpg',
          duration: 189
        },
        {
          name: 'Ti cadono i capelli?',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/lifestyle_farmacista_caduta_capelli_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/lifestyle_farmacista_caduta_capelli_notizie.jpg',
          duration: 235
        },
        {
          name: 'Dormire, che lusso!',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/lifestyle_farmacista_dormire_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/lifestyle_farmacista_dormire_notizie.jpg',
          duration: 199
        }
      ]
    },

    // ========================================
    // NEWS - Avvocato
    // ========================================
    news: {
      name: 'News Legali',
      videos: [
        {
          name: 'Cosa fare in caso di incidente',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/news_avvocato_incidente_macchina_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/news_avvocato_incidente_macchina_notizie.jpg',
          duration: 83
        },
        {
          name: 'Legittima difesa, chiarimenti',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/news_avvocato_legittima_difesa_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/news_avvocato_legittima_difesa_notizie.jpg',
          duration: 110
        },
        {
          name: 'Multe su autobus',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/news_avvocato_multe_mezzi_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/news_avvocato_multe_mezzi_notizie.jpg',
          duration: 80
        },
        {
          name: 'Disturbo quiete pubblica',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/news_disturbo_quiete_pubblica_notizie.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/news_disturbo_quiete_pubblica_notizie.jpg',
          duration: 81
        }
      ]
    },

    // ========================================
    // GOSSIP - Off Camera
    // ========================================
    gossip: {
      name: 'Off Camera Interviste',
      videos: [
        {
          name: 'Off camera: Carlo Amleto',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/spettacolo_off_camera_carlo_amleto_corto.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/spettacolo_off_camera_carlo_amleto_corto.jpg',
          duration: 196
        },
        {
          name: 'Off camera: Gordon',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/spettacolo_off_camera_gordon_corto.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/spettacolo_off_camera_gordon_corto.jpg',
          duration: 122
        },
        {
          name: 'Off camera: Luca Gervasi',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/spettacolo_off_camera_luca_gervasi_corto.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/spettacolo_off_camera_luca_gervasi_corto.jpg',
          duration: 107
        },
        {
          name: 'Off camera: Mark the Hammer',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/spettacolo_off_camera_mark_the_hammer_corto.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/spettacolo_off_camera_mark_the_hammer_corto.jpg',
          duration: 196
        }
      ]
    },

    // ========================================
    // DONNEMAGAZINE - Donna
    // ========================================
    donnemagazine: {
      name: 'Donna Magazine',
      videos: [
        {
          name: 'Chirurgo indicazioni botox donna',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/donnemagazine/chirurgo_indicazioni_botox_donna.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/thumb_generics.jpg',
          duration: 90
        },
        {
          name: 'Chirurgo indicazioni botox donna 2',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/donnemagazine/chirurgo_indicazioni_botox_donna_2.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/thumb_generics.jpg',
          duration: 108
        },
        {
          name: 'Mi ama o non mi ama donna',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/donnemagazine/mi_ama_o_non_mi_ama_donna.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/thumb_generics.jpg',
          duration: 296
        },
        {
          name: 'Tabu psicologa donna',
          url: 'https://d1b00xz8obnero.cloudfront.net/video/media/donnemagazine/tabu_psicologa_donna.mp4',
          thumbnail: 'https://d1b00xz8obnero.cloudfront.net/video/thumbs/thumb_generics.jpg',
          duration: 182
        }
      ]
    },

    // ========================================
    // ACTUALIDAD - Vari (ES)
    // ========================================
    actualidad: {
      name: 'Actualidad',
      videos: [
        {
          name: '8 alimentos antidepresivos',
          url: 'https://static.4wnetwork.com/asset/video/media/actualidad_8_cibi_antidepressivi_es_640x480.mp4',
          thumbnail: 'https://static.4wnetwork.com/asset/video/thumbs/actualidad_8_cibi_antidepressivi_es_640x480.jpg',
          duration: 90
        },
        {
          name: 'Los tres baby killers mas despiadados de todos los tiempos',
          url: 'https://static.4wnetwork.com/asset/video/media/actualidad_Baby_Killer_crime_es_640x480.mp4',
          thumbnail: 'https://static.4wnetwork.com/asset/video/thumbs/actualidad_Baby_Killer_crime_es_640x480.jpg',
          duration: 108
        },
        {
          name: 'Bronceado: falsos mitos',
          url: 'https://static.4wnetwork.com/asset/video/media/actualidad_farmacista_abbronzatura_es640x480.mp4',
          thumbnail: 'https://static.4wnetwork.com/asset/video/thumbs/actualidad_farmacista_abbronzatura_es640x480.jpg',
          duration: 296
        },
        {
          name: 'La alergia: la primavera una autentica pesadilla',
          url: 'https://static.4wnetwork.com/asset/video/media/actualidad_farmacista_allergia_es640x480.mp4',
          thumbnail: 'https://static.4wnetwork.com/asset/video/thumbs/actualidad_farmacista_allergia_es640x480.jpg',
          duration: 182
        },
        {
          name: 'Pedro Alonso Lopez: uno de los asesinos mas brutales',
          url: 'https://static.4wnetwork.com/asset/video/media/actualidad_Pedro_Alonso_crime_Es640x480.mp4',
          thumbnail: 'https://static.4wnetwork.com/asset/video/thumbs/actualidad_Pedro_Alonso_crime_Es640x480.jpg',
          duration: 203
        },
        {
          name: 'Los pitbulls: falsos mitos',
          url: 'https://static.4wnetwork.com/asset/video/media/actualidad_pet_ai_es_def640x480.mp4',
          thumbnail: 'https://static.4wnetwork.com/asset/video/thumbs/actualidad_pet_ai_es_def640x480.jpg',
          duration: 199
        }
      ]
    }

  };

  /**
   * API Pubblica
   */
  window.AdHubVideoPlaylistsData = {

    /**
     * Ottieni tutte le playlist disponibili
     */
    getAllPlaylists: function() {
      return Object.keys(PLAYLISTS_DATA);
    },

    /**
     * Ottieni una playlist specifica
     * @param {string} playlistName - Nome della playlist
     * @returns {object|null} Playlist data o null se non trovata
     */
    getPlaylist: function(playlistName) {
      if (!PLAYLISTS_DATA[playlistName]) {
        console.warn('[Playlists Data] Playlist non trovata:', playlistName);
        return null;
      }

      // Return copy con shuffle casuale
      const playlist = PLAYLISTS_DATA[playlistName];
      const videos = [...playlist.videos];

      // Shuffle Fisher-Yates
      for (let i = videos.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [videos[i], videos[j]] = [videos[j], videos[i]];
      }

      return {
        name: playlist.name,
        videos: videos
      };
    },

    /**
     * Ottieni video casuali da una playlist
     * @param {string} playlistName - Nome della playlist
     * @param {number} count - Numero di video da ottenere
     * @returns {array} Array di video
     */
    getRandomVideos: function(playlistName, count) {
      const playlist = this.getPlaylist(playlistName);
      if (!playlist) return [];

      return playlist.videos.slice(0, count);
    },

    /**
     * Verifica se una playlist esiste
     * @param {string} playlistName - Nome della playlist
     * @returns {boolean}
     */
    hasPlaylist: function(playlistName) {
      return !!PLAYLISTS_DATA[playlistName];
    }

  };

  console.log('[AdHub Playlists Data] ✅ Caricato');
  console.log('[AdHub Playlists Data] 📊 Playlist disponibili:', Object.keys(PLAYLISTS_DATA).length);

  window.__AdHubVideoPlaylistsData = true;

})();

// ============================================================================
// VIDEO PLAYLIST MODULE (con Google IMA SDK per VAST)
// ============================================================================

/**
 * AdHub Video Playlist Module
 *
 * Gestisce playlist di video content con integrazione ads VAST/VPAID:
 * - Caricamento playlist da API XML o URL video diretto
 * - Riproduzione sequenziale/casuale
 * - Inserimento ads tra i video content (pre-roll, mid-roll)
 * - Supporto per sticky e in-content positioning
 * - Gestione coda video e transizioni
 *
 * USO CON URL VIDEO DIRETTO:
 * HTML: <div id="my-video" data-video-url="https://example.com/video.mp4"></div>
 * JS: AdHubVideoPlaylist.createPlaylist('my-video', { videoUrl: 'https://example.com/video.mp4' })
 *
 * @version 1.1.0
 * @date 2025-11-13
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.AdHubVideoPlaylist) {
    console.warn('[AdHubVideoPlaylist] Modulo già caricato');
    return;
  }

  // ============================================================================
  // CONFIGURAZIONE
  // ============================================================================

  const DEFAULT_CONFIG = {
    // API endpoint
    apiEndpoint: 'https://static.4wnetwork.com/asset/api/playlist.php',
    apiKey: 'Y2Q0MjgyYTZhNzgxM2E1ODRlN2MxNTE',

    // Playlist settings
    defaultPlaylist: 'viral', // actualidad, gossip, viral, news, donnemagazine
    shuffle: true, // Ordine casuale (già fatto dal server)
    autoPlay: true,
    loop: true, // Riparti dall'inizio quando finiscono i video

    // Ads integration
    enableAds: true,
    preRoll: true, // Ad prima del primo video
    midRoll: true, // Ad tra i video
    midRollFrequency: 1, // Un ad ogni X video content (1 = tra ogni video)
    postRoll: false, // Ad finale (opzionale)
    skipAdIfNoBid: false, // Se true, skip ad se Prebid non ritorna bid

    // Audio strategy - prova prima con audio on (CPM più alto)
    preferUnmutedAds: true, // Prova prima a richiedere ads con audio attivo
    fallbackToMutedAds: true, // Se no bid, riprova con audio mutato
    startMuted: 'auto', // 'auto' | true | false - 'auto' = basato sul bid ricevuto

    // VAST fallback URL (GAM) quando Prebid non ritorna bid
    // Default: AdhubMedia_RON (multi-size, tutti i siti)
    // Può essere sovrascritto da config site-specific
    vastFallbackUrl: 'https://pubads.g.doubleclick.net/gampad/ads?' +
      'sz=300x250|400x300|728x90|120x600|320x100|320x50|336x280|640x480|300x600|970x250' +
      '&iu=/131207395/AdhubMedia_RON' +
      '&env=vp&impl=s&gdfp_req=1&output=vast&unviewed_position_start=1' +
      '&url=[referrer_url]&description_url=[description_url]&correlator=[timestamp]',

    // Player settings
    controls: false,  // Disabilita controlli nativi HTML5
    showProgress: true,
    showPlaylist: false, // Mostra lista video (opzionale)
    showMuteButton: true,  // Mostra solo bottone mute/unmute

    // UI
    showTitle: true,
    showNextButton: true,
    closeDelay: 5, // secondi prima di mostrare close button

    // Auto-init from DOM
    autoInitFromDOM: true, // Inizializza automaticamente dai div con data-adhub-playlist

    // Debug
    debug: false
  };

  // ============================================================================
  // STATE MANAGEMENT
  // ============================================================================

  const state = {
    playlists: new Map(), // Map<playerId, playlistInstance>
    config: {...DEFAULT_CONFIG},
    initialized: false
  };

  // ============================================================================
  // UTILITY FUNCTIONS
  // ============================================================================

  function log(...args) {
    if (state.config.debug) {
      console.log('[AdHubVideoPlaylist]', ...args);
    }
  }

  function error(...args) {
    console.error('[AdHubVideoPlaylist]', ...args);
  }

  function isMobile() {
    return window.innerWidth < 768;
  }

  /**
   * Carica Google IMA SDK
   */
  function loadImaSDK() {
    return new Promise((resolve, reject) => {
      // Se già caricato, return
      if (typeof google !== 'undefined' && google.ima) {
        log('IMA SDK già caricato');
        resolve();
        return;
      }

      // Se già in loading, aspetta
      if (window.__imaSDKLoading) {
        log('IMA SDK già in loading...');
        const checkInterval = setInterval(() => {
          if (typeof google !== 'undefined' && google.ima) {
            clearInterval(checkInterval);
            resolve();
          }
        }, 100);
        return;
      }

      window.__imaSDKLoading = true;
      log('Caricamento IMA SDK...');

      const script = document.createElement('script');
      script.src = 'https://imasdk.googleapis.com/js/sdkloader/ima3.js';
      script.async = true;

      script.onload = () => {
        log('✅ IMA SDK caricato');
        window.__imaSDKLoading = false;
        resolve();
      };

      script.onerror = () => {
        error('❌ Errore caricamento IMA SDK');
        window.__imaSDKLoading = false;
        reject(new Error('Failed to load IMA SDK'));
      };

      document.head.appendChild(script);
    });
  }

  // ============================================================================
  // API FUNCTIONS
  // ============================================================================

  /**
   * Carica playlist dall'API PHP o da URL diretto
   */
  async function loadPlaylistFromAPI(playlistCode, videoUrl = null) {
    // Se è stato passato un videoUrl diretto, crea una playlist con quel singolo video
    if (videoUrl) {
      log('Caricamento video diretto da URL:', videoUrl);

      // Estrai nome file dall'URL per usarlo come titolo
      const videoName = videoUrl.split('/').pop().split('?')[0].replace(/\.[^/.]+$/, "");

      return [{
        id: 'direct-video-0',
        name: videoName || 'Video',
        description: '',
        thumbnail: '',
        videoUrl: videoUrl,
        dataUrl: '',
        duration: 60,
        width: 640,
        height: 480,
        updatedAt: new Date().toISOString()
      }];
    }

    log('Caricamento playlist da dati statici:', playlistCode);

    try {
      // Usa dati statici invece di chiamare API esterna
      if (!window.AdHubVideoPlaylistsData) {
        throw new Error('AdHubVideoPlaylistsData non caricato');
      }

      const playlistData = window.AdHubVideoPlaylistsData.getPlaylist(playlistCode);

      if (!playlistData) {
        throw new Error(`Playlist "${playlistCode}" non trovata`);
      }

      // Converti formato dati statici in formato playlist interno
      const videos = playlistData.videos.map((video, index) => ({
        id: `${playlistCode}-${index}`,
        name: video.name,
        description: video.description || '',
        thumbnail: video.thumbnail || '',
        videoUrl: video.url,
        dataUrl: '',
        duration: video.duration || 60,
        width: 640,
        height: 480,
        updatedAt: new Date().toISOString()
      }));

      log(`Playlist caricata: ${videos.length} video`);
      return videos;

    } catch (err) {
      error('Errore caricamento playlist:', err);
      throw err;
    }
  }

  // ============================================================================
  // PLAYLIST CREATION
  // ============================================================================

  /**
   * Crea container per playlist player
   */
  function createPlaylistContainer(playerId, position, config) {
    const container = document.createElement('div');
    container.id = `adhub-playlist-${playerId}`;
    container.className = 'adhub-playlist-container';
    container.setAttribute('data-position', position);
    container.setAttribute('data-player-id', playerId);

    const stickyStyles = position.startsWith('sticky-')
      ? getPositionStyles(position)
      : 'position: relative; margin: 20px auto;';

    let sizeStyles;
    if (config && config.width) {
      const widthValue = /^\d+$/.test(config.width) ? `${config.width}px` : config.width;
      sizeStyles = `
        max-width: ${widthValue};
        width: 100%;
        aspect-ratio: 16 / 9;
        height: auto;
      `;
    } else {
      const size = isMobile()
        ? { width: 400, height: 300 }
        : { width: 640, height: 480 };
      sizeStyles = `
        width: ${size.width}px;
        height: ${size.height}px;
      `;
    }

    container.style.cssText = `
      ${sizeStyles}
      background: #000;
      overflow: hidden;
      border-radius: 8px;
      ${stickyStyles}
    `;

    return container;
  }

  /**
   * Ottieni stili CSS in base alla posizione
   */
  function getPositionStyles(position) {
    const offset = 20;

    switch(position) {
      case 'sticky-bottom-left':
        return `
          position: fixed;
          bottom: ${offset}px;
          left: ${offset}px;
          z-index: 9999;
          box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        `;

      case 'sticky-bottom-right':
        return `
          position: fixed;
          bottom: ${offset}px;
          right: ${offset}px;
          z-index: 9999;
          box-shadow: 0 4px 12px rgba(0,0,0,0.3);
        `;

      default:
        return 'position: relative;';
    }
  }

  /**
   * Crea video element HTML5
   */
  function createVideoElement(container, playerId) {
    const videoEl = document.createElement('video');
    videoEl.id = `adhub-playlist-video-${playerId}`;
    videoEl.className = 'adhub-playlist-video';
    videoEl.style.cssText = `
      width: 100%;
      height: 100%;
      object-fit: contain;
      background: #000;
    `;

    if (state.config.controls) {
      videoEl.controls = true;
    }

    if (state.config.autoPlay) {
      videoEl.autoplay = true;

      // Determina stato mute iniziale basato su config
      if (state.config.startMuted === 'auto') {
        // Auto: parte muted, poi si attiva in base al bid ricevuto
        videoEl.muted = true;
      } else {
        videoEl.muted = state.config.startMuted === true;
      }
    }

    container.appendChild(videoEl);
    return videoEl;
  }

  /**
   * Crea overlay per ads
   */
  function createAdsOverlay(container, playerId) {
    const overlay = document.createElement('div');
    overlay.id = `adhub-playlist-ads-${playerId}`;
    overlay.className = 'adhub-playlist-ads-overlay';
    overlay.style.cssText = `
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: #000;
      display: none;
      z-index: 10;
    `;

    container.appendChild(overlay);
    return overlay;
  }

  /**
   * Crea UI overlay (titolo, controlli, progress)
   */
  function createUIOverlay(container, playerId, adOnly = false) {
    const overlay = document.createElement('div');
    overlay.className = 'adhub-playlist-ui-overlay';
    overlay.style.cssText = `
      position: absolute;
      bottom: 0;
      left: 0;
      width: 100%;
      background: linear-gradient(transparent, rgba(0,0,0,0.8));
      padding: 15px;
      box-sizing: border-box;
      z-index: 20;
      display: flex;
      flex-direction: column;
      gap: 10px;
    `;

    // Titolo video (solo se non in modalità ad-only)
    if (state.config.showTitle && !adOnly) {
      const title = document.createElement('div');
      title.className = 'adhub-playlist-title';
      title.style.cssText = `
        color: #fff;
        font-size: 14px;
        font-weight: 500;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      `;
      overlay.appendChild(title);
    }

    // Progress bar (solo se non in modalità ad-only)
    if (state.config.showProgress && !adOnly) {
      const progressContainer = document.createElement('div');
      progressContainer.style.cssText = `
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 12px;
        color: #fff;
      `;

      const currentText = document.createElement('span');
      currentText.className = 'adhub-playlist-current';
      currentText.textContent = '1';

      const separator = document.createElement('span');
      separator.textContent = '/';

      const totalText = document.createElement('span');
      totalText.className = 'adhub-playlist-total';
      totalText.textContent = '0';

      progressContainer.appendChild(currentText);
      progressContainer.appendChild(separator);
      progressContainer.appendChild(totalText);

      overlay.appendChild(progressContainer);
    }

    // Next button (solo se non in modalità ad-only)
    if (state.config.showNextButton && !adOnly) {
      const nextBtn = document.createElement('button');
      nextBtn.className = 'adhub-playlist-next-btn';
      nextBtn.textContent = 'Next →';
      nextBtn.style.cssText = `
        background: rgba(255,255,255,0.2);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        padding: 8px 16px;
        border-radius: 4px;
        cursor: pointer;
        font-size: 12px;
        transition: background 0.2s;
        align-self: flex-start;
      `;

      // Gli event listener saranno aggiunti in setupVideoEventListeners()

      overlay.appendChild(nextBtn);
    }

    // Mute/Unmute button
    if (state.config.showMuteButton) {
      const muteBtn = document.createElement('button');
      muteBtn.className = 'adhub-playlist-mute-btn';
      muteBtn.innerHTML = '🔊'; // Speaker icon (unmuted by default)
      muteBtn.setAttribute('aria-label', 'Mute/Unmute');
      muteBtn.style.cssText = `
        position: absolute;
        top: 15px;
        right: 50px;
        background: rgba(0,0,0,0.6);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        width: 36px;
        height: 36px;
        border-radius: 50%;
        cursor: pointer;
        font-size: 16px;
        transition: all 0.2s;
        z-index: 30;
        display: flex;
        align-items: center;
        justify-content: center;
      `;

      // Gli event listener saranno aggiunti in setupVideoEventListeners()

      container.appendChild(muteBtn);
    }

    container.appendChild(overlay);
    return overlay;
  }

  /**
   * Crea close button
   */
  function createCloseButton(container, playerId) {
    const button = document.createElement('button');
    button.className = 'adhub-playlist-close';
    button.innerHTML = '&times;';
    button.setAttribute('aria-label', 'Chiudi playlist');

    button.style.cssText = `
      position: absolute;
      top: 8px;
      right: 8px;
      width: 32px;
      height: 32px;
      border: none;
      border-radius: 50%;
      background: rgba(0,0,0,0.7);
      color: #fff;
      font-size: 24px;
      line-height: 1;
      cursor: pointer;
      z-index: 30;
      transition: background 0.2s;
      display: none;
    `;

    // Salva riferimenti agli handler per cleanup
    button._handlers = {};

    button._handlers.mouseenter = () => {
      button.style.background = 'rgba(0,0,0,0.9)';
    };
    button.addEventListener('mouseenter', button._handlers.mouseenter);

    button._handlers.mouseleave = () => {
      button.style.background = 'rgba(0,0,0,0.7)';
    };
    button.addEventListener('mouseleave', button._handlers.mouseleave);

    button._handlers.click = () => {
      closePlaylist(playerId);
    };
    button.addEventListener('click', button._handlers.click);

    container.appendChild(button);

    // Mostra dopo delay
    setTimeout(() => {
      button.style.display = 'block';
    }, state.config.closeDelay * 1000);

    return button;
  }

  // ============================================================================
  // PLAYLIST MANAGEMENT
  // ============================================================================

  /**
   * Crea e inizializza playlist player
   */
  async function createPlaylist(playerId, options = {}) {
    log('Creazione playlist:', playerId, options);

    // Merge config
    const config = {
      ...state.config,
      ...options
    };

    // Se in modalità solo-ad, non caricare video content
    let videos = [];
    if (!config.adOnly) {
      // Carica playlist dall'API o da URL diretto
      const playlistCode = config.playlist || config.defaultPlaylist;
      const videoUrl = config.videoUrl || null; // Nuovo parametro per URL diretto
      videos = await loadPlaylistFromAPI(playlistCode, videoUrl);

      if (videos.length === 0) {
        error('Nessun video nella playlist');
        return null;
      }
    } else {
      log('Creazione player in modalità "ad-only"');
    }

    // Crea container
    const position = config.position || 'in-content';
    const container = createPlaylistContainer(playerId, position, config);

    // Per sticky, aggiungi al body; per in-content, cerca elemento target
    if (position.startsWith('sticky-')) {
      document.body.appendChild(container);
    } else {
      const targetElement = document.getElementById(playerId);
      if (targetElement) {
        targetElement.appendChild(container);
      } else {
        document.body.appendChild(container);
      }
    }

    // Crea elementi UI
    const videoElement = createVideoElement(container, playerId);
    const adsOverlay = createAdsOverlay(container, playerId);
    const uiOverlay = createUIOverlay(container, playerId, config.adOnly);
    const closeButton = createCloseButton(container, playerId);

    // Crea playlist instance
    const playlist = {
      playerId,
      container,
      videoElement,
      adsOverlay,
      uiOverlay,
      closeButton,
      position,
      config,

      // Playlist data
      playlistCode: config.adOnly ? 'ad-only' : (config.playlist || config.defaultPlaylist),
      videos,
      currentIndex: 0,
      videosPlayed: 0,

      // State
      isPlaying: false,
      isPlayingAd: false,
      isClosed: false,

      // Error handling
      errorCount: 0,
      maxErrors: 5,  // Massimo 5 tentativi prima di stop

      // Ad units
      adUnitCode: null,
      nextAdIndex: config.preRoll ? 0 : config.midRollFrequency
    };

    // Salva playlist
    state.playlists.set(playerId, playlist);

    // Setup event listeners
    setupVideoEventListeners(playlist);

    // Update UI
    updatePlaylistUI(playlist);

    // Animazione entrata
    container.style.opacity = '0';
    container.style.transform = position.startsWith('sticky-')
      ? 'translateY(20px)'
      : 'scale(0.95)';

    setTimeout(() => {
      container.style.transition = 'all 300ms ease-out';
      container.style.opacity = '1';
      container.style.transform = 'translateY(0) scale(1)';
    }, 10);

    log('Playlist creata:', playerId, `${videos.length} video`);

    // Start playback
    if (config.adOnly) {
      // Modalità solo-ad: riproduci subito un annuncio
      await playAd(playlist);
    } else if (config.enableAds && config.preRoll) {
      // Pre-roll ad prima del primo video
      await playAd(playlist);
    } else {
      // Carica primo video
      playVideoAtIndex(playlist, 0);
    }

    return playlist;
  }

  /**
   * Setup event listeners per video element
   */
  function setupVideoEventListeners(playlist) {
    const { videoElement, uiOverlay, playerId } = playlist;

    // Crea oggetto per salvare i riferimenti agli handler (per cleanup)
    playlist.eventHandlers = {};

    // Video ended - passa al prossimo
    playlist.eventHandlers.videoEnded = () => {
      log('Video terminato:', playlist.currentIndex);
      playlist.videosPlayed++;

      // Verifica se mostrare mid-roll ad
      if (playlist.config.enableAds &&
          playlist.config.midRoll &&
          playlist.videosPlayed >= playlist.nextAdIndex) {

        log('Mid-roll ad');
        playlist.nextAdIndex = playlist.videosPlayed + playlist.config.midRollFrequency;
        playAd(playlist);
      } else {
        // Prossimo video
        playNextVideo(playlist);
      }
    };
    videoElement.addEventListener('ended', playlist.eventHandlers.videoEnded);

    // Video error - Con limite di tentativi
    playlist.eventHandlers.videoError = (e) => {
      error('Errore riproduzione video:', e);
      playlist.errorCount++;

      // Check se raggiunto limite errori
      if (playlist.errorCount >= playlist.maxErrors) {
        error(`Raggiunto limite errori (${playlist.maxErrors}). Stop playlist.`);
        firePlaylistEvent(playlist.playerId, 'playlist:error:max-retries', {
          errorCount: playlist.errorCount,
          currentIndex: playlist.currentIndex
        });

        // Mostra messaggio di errore all'utente
        showErrorMessage(playlist, 'Impossibile caricare i video. Playlist interrotta.');

        // Stop playlist
        return;
      }

      // Altrimenti skip al prossimo video
      log(`Errore video (${playlist.errorCount}/${playlist.maxErrors}), skip al prossimo`);
      playNextVideo(playlist);
    };
    videoElement.addEventListener('error', playlist.eventHandlers.videoError);

    // Next button click + hover
    const nextBtn = uiOverlay.querySelector('.adhub-playlist-next-btn');
    if (nextBtn) {
      playlist.eventHandlers.nextBtnClick = () => {
        log('Next button clicked');
        playNextVideo(playlist);
      };
      playlist.eventHandlers.nextBtnMouseenter = () => {
        nextBtn.style.background = 'rgba(255,255,255,0.3)';
      };
      playlist.eventHandlers.nextBtnMouseleave = () => {
        nextBtn.style.background = 'rgba(255,255,255,0.2)';
      };

      nextBtn.addEventListener('click', playlist.eventHandlers.nextBtnClick);
      nextBtn.addEventListener('mouseenter', playlist.eventHandlers.nextBtnMouseenter);
      nextBtn.addEventListener('mouseleave', playlist.eventHandlers.nextBtnMouseleave);
      playlist.nextBtn = nextBtn; // Salva riferimento per cleanup
    }

    // Mute/Unmute button click + hover
    const muteBtn = playlist.container.querySelector('.adhub-playlist-mute-btn');
    if (muteBtn) {
      playlist.eventHandlers.muteBtnClick = () => {
        videoElement.muted = !videoElement.muted;
        muteBtn.innerHTML = videoElement.muted ? '🔇' : '🔊';
        log('Mute toggled:', videoElement.muted);
        firePlaylistEvent(playerId, videoElement.muted ? 'video:muted' : 'video:unmuted');
      };
      playlist.eventHandlers.muteBtnMouseenter = () => {
        muteBtn.style.background = 'rgba(0,0,0,0.8)';
        muteBtn.style.transform = 'scale(1.1)';
      };
      playlist.eventHandlers.muteBtnMouseleave = () => {
        muteBtn.style.background = 'rgba(0,0,0,0.6)';
        muteBtn.style.transform = 'scale(1)';
      };

      muteBtn.addEventListener('click', playlist.eventHandlers.muteBtnClick);
      muteBtn.addEventListener('mouseenter', playlist.eventHandlers.muteBtnMouseenter);
      muteBtn.addEventListener('mouseleave', playlist.eventHandlers.muteBtnMouseleave);
      playlist.muteBtn = muteBtn; // Salva riferimento per cleanup
    }

    // Video started - Reset error count on success
    playlist.eventHandlers.videoPlay = () => {
      playlist.isPlaying = true;
      playlist.errorCount = 0;  // Reset errori dopo successo
      firePlaylistEvent(playerId, 'video:play', {
        index: playlist.currentIndex,
        video: playlist.videos[playlist.currentIndex]
      });
    };
    videoElement.addEventListener('play', playlist.eventHandlers.videoPlay);

    // Video paused
    playlist.eventHandlers.videoPause = () => {
      playlist.isPlaying = false;
    };
    videoElement.addEventListener('pause', playlist.eventHandlers.videoPause);
  }

  /**
   * Play video a un indice specifico
   */
  function playVideoAtIndex(playlist, index) {
    if (index >= playlist.videos.length) {
      // Fine playlist
      if (playlist.config.loop) {
        log('Loop playlist - ripartenza');
        // Usa setTimeout per spezzare lo stack di ricorsione
        setTimeout(function() {
          playlist.currentIndex = 0;
          playlist.videosPlayed = 0;
          playVideoAtIndex(playlist, 0);
        }, 100);
      } else {
        log('Playlist terminata');
        if (playlist.config.enableAds && playlist.config.postRoll) {
          playAd(playlist);
        }
        firePlaylistEvent(playlist.playerId, 'playlist:complete');
      }
      return;
    }

    const video = playlist.videos[index];
    playlist.currentIndex = index;

    log('Riproduzione video:', index, video.name);

    // Update UI
    updatePlaylistUI(playlist);

    // Load video
    playlist.videoElement.src = video.videoUrl;
    playlist.videoElement.load();

    if (playlist.config.autoPlay) {
      playlist.videoElement.play().catch(err => {
        error('Errore autoplay:', err);
      });
    }

    // Hide ads overlay
    playlist.adsOverlay.style.display = 'none';

    firePlaylistEvent(playlist.playerId, 'video:load', { index, video });
  }

  /**
   * Play prossimo video
   */
  function playNextVideo(playlist) {
    playVideoAtIndex(playlist, playlist.currentIndex + 1);
  }

  /**
   * Play ad VAST tramite Google IMA SDK
   */
  async function playAd(playlist) {
    log('Riproduzione ad...');

    playlist.isPlayingAd = true;

    // Pause video content
    playlist.videoElement.pause();

    // Show ads overlay
    playlist.adsOverlay.style.display = 'block';
    playlist.adsOverlay.innerHTML = `
      <div style="
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
        font-size: 14px;
      ">
        <div>Loading ad...</div>
      </div>
    `;

    firePlaylistEvent(playlist.playerId, 'ad:request');

    try {
      // Request VAST ad via Prebid (se integrazione disponibile)
      let vastUrl = null;
      let unmutedBidReceived = false;

      if (playlist.config.adRequestCallback && typeof playlist.config.adRequestCallback === 'function') {
        // STRATEGIA AUDIO: Prova prima con audio unmuted (CPM più alto)
        if (playlist.config.preferUnmutedAds) {
          log('🔊 Tentativo 1: Richiesta bid con AUDIO ATTIVO (unmuted, CPM più alto)');

          try {
            const adResponse = await playlist.config.adRequestCallback(
              `adhub-playlist-ad-${playlist.playerId}`,
              playlist.position,
              { startMuted: false } // Richiede ads con audio attivo
            );

            if (adResponse && adResponse.vastUrl) {
              vastUrl = adResponse.vastUrl;
              unmutedBidReceived = true;
              log('✅ Bid UNMUTED ricevuto! CPM:', adResponse.cpm || 'N/A');
              log('VAST URL:', vastUrl);
            }
          } catch (err) {
            log('❌ Nessun bid per ads unmuted:', err.message);
          }
        }

        // FALLBACK: Se nessun bid unmuted, prova con muted
        if (!vastUrl && playlist.config.fallbackToMutedAds) {
          log('🔇 Tentativo 2: Richiesta bid con AUDIO MUTATO (muted, CPM standard)');

          try {
            const adResponse = await playlist.config.adRequestCallback(
              `adhub-playlist-ad-${playlist.playerId}`,
              playlist.position,
              { startMuted: true } // Richiede ads con audio mutato
            );

            if (adResponse && adResponse.vastUrl) {
              vastUrl = adResponse.vastUrl;
              unmutedBidReceived = false;
              log('✅ Bid MUTED ricevuto! CPM:', adResponse.cpm || 'N/A');
              log('VAST URL:', vastUrl);
            }
          } catch (err) {
            log('❌ Nessun bid anche per ads muted:', err.message);
          }
        }
      }

      // Se nessun VAST URL da Prebid, usa fallback GAM
      if (!vastUrl) {
        // Fallback: usa VAST tag GAM (o skip ad)
        if (playlist.config.skipAdIfNoBid) {
          log('Nessun bid, skip ad');
          onAdComplete(playlist);
          return;
        }

        // VAST fallback URL - Da config (default: AdhubMedia_RON)
        const referrerUrl = encodeURIComponent(window.location.href);
        const timestamp = Date.now();

        vastUrl = playlist.config.vastFallbackUrl
          .replace('[referrer_url]', referrerUrl)
          .replace('[description_url]', referrerUrl)
          .replace('[timestamp]', timestamp);

        log('Uso VAST fallback GAM:', vastUrl.match(/iu=([^&]+)/)?.[1] || 'AdhubMedia_RON');
      }

      // Load VAST ad usando Google IMA SDK
      await loadVastAd(playlist, vastUrl, unmutedBidReceived);

      // Imposta audio del video content in base al bid ricevuto
      if (playlist.config.startMuted === 'auto') {
        // Se abbiamo ricevuto bid unmuted, attiva audio anche per il video content
        playlist.videoElement.muted = !unmutedBidReceived;

        // Aggiorna icona bottone mute
        const muteBtn = playlist.container.querySelector('.adhub-playlist-mute-btn');
        if (muteBtn) {
          muteBtn.innerHTML = playlist.videoElement.muted ? '🔇' : '🔊';
        }

        log(`Audio video content impostato: ${playlist.videoElement.muted ? 'MUTED' : 'UNMUTED'} (basato su bid)`);
      }

    } catch (err) {
      error('Errore caricamento ad:', err);
      onAdComplete(playlist);
    }
  }

  /**
   * Carica e riproduce VAST ad usando Google IMA SDK
   * @param {boolean} unmutedBid - true se abbiamo ricevuto bid per ad unmuted
   */
  async function loadVastAd(playlist, vastUrl, unmutedBid = false) {
    return new Promise((resolve, reject) => {
      // Verifica che IMA SDK sia caricato
      if (typeof google === 'undefined' || !google.ima) {
        error('Google IMA SDK non caricato');
        onAdComplete(playlist);
        resolve();
        return;
      }

      // Crea video element per l'ad
      const adVideoEl = document.createElement('video');
      adVideoEl.style.cssText = 'width: 100%; height: 100%; object-fit: contain;';
      adVideoEl.setAttribute('playsinline', '');

      // Imposta mute in base al bid ricevuto
      adVideoEl.muted = !unmutedBid;
      log(`Ad video impostato: ${adVideoEl.muted ? 'MUTED' : 'UNMUTED'}`);

      // Crea ad container
      const adContainer = document.createElement('div');
      adContainer.style.cssText = 'width: 100%; height: 100%; position: relative;';
      adContainer.appendChild(adVideoEl);

      playlist.adsOverlay.innerHTML = '';
      playlist.adsOverlay.appendChild(adContainer);

      // Crea IMA container
      const imaContainer = document.createElement('div');
      imaContainer.style.cssText = 'position: absolute; top: 0; left: 0; width: 100%; height: 100%;';
      adContainer.appendChild(imaContainer);

      // Setup IMA
      const adDisplayContainer = new google.ima.AdDisplayContainer(imaContainer, adVideoEl);
      const adsLoader = new google.ima.AdsLoader(adDisplayContainer);
      let adsManager = null;

      // Ads Loader events
      adsLoader.addEventListener(
        google.ima.AdsManagerLoadedEvent.Type.ADS_MANAGER_LOADED,
        (event) => {
          log('IMA: AdsManager loaded');

          adsManager = event.getAdsManager(adVideoEl);

          // Setup ads manager events
          adsManager.addEventListener(
            google.ima.AdErrorEvent.Type.AD_ERROR,
            (adErrorEvent) => {
              error('IMA Ad Error:', adErrorEvent.getError());
              firePlaylistEvent(playlist.playerId, 'ad:error', {
                error: adErrorEvent.getError().getMessage()
              });
              adsManager.destroy();
              onAdComplete(playlist);
              resolve();
            }
          );

          adsManager.addEventListener(
            google.ima.AdEvent.Type.CONTENT_PAUSE_REQUESTED,
            () => {
              log('IMA: Content pause requested');
              playlist.videoElement.pause();
            }
          );

          adsManager.addEventListener(
            google.ima.AdEvent.Type.CONTENT_RESUME_REQUESTED,
            () => {
              log('IMA: Content resume requested');
              adsManager.destroy();
              onAdComplete(playlist);
              resolve();
            }
          );

          // Track ad events
          adsManager.addEventListener(google.ima.AdEvent.Type.STARTED, () => {
            log('IMA: Ad started');
            firePlaylistEvent(playlist.playerId, 'ad:start');
          });

          adsManager.addEventListener(google.ima.AdEvent.Type.IMPRESSION, () => {
            log('IMA: Ad impression');
            firePlaylistEvent(playlist.playerId, 'ad:impression');
          });

          adsManager.addEventListener(google.ima.AdEvent.Type.COMPLETE, () => {
            log('IMA: Ad complete');
            firePlaylistEvent(playlist.playerId, 'ad:complete');
          });

          adsManager.addEventListener(google.ima.AdEvent.Type.SKIPPED, () => {
            log('IMA: Ad skipped');
            firePlaylistEvent(playlist.playerId, 'ad:skipped');
          });

          try {
            adDisplayContainer.initialize();

            // Get container dimensions
            const width = playlist.container.offsetWidth;
            const height = playlist.container.offsetHeight;

            adsManager.init(width, height, google.ima.ViewMode.NORMAL);
            adsManager.start();
          } catch (adError) {
            error('IMA: Error starting ads manager:', adError);
            adsManager.destroy();
            onAdComplete(playlist);
            resolve();
          }
        },
        false
      );

      adsLoader.addEventListener(
        google.ima.AdErrorEvent.Type.AD_ERROR,
        (adErrorEvent) => {
          error('IMA Ads Loader Error:', adErrorEvent.getError());
          firePlaylistEvent(playlist.playerId, 'ad:error', {
            error: adErrorEvent.getError().getMessage()
          });
          onAdComplete(playlist);
          resolve();
        },
        false
      );

      // Request ads
      const adsRequest = new google.ima.AdsRequest();
      adsRequest.adTagUrl = vastUrl;
      adsRequest.linearAdSlotWidth = playlist.container.offsetWidth;
      adsRequest.linearAdSlotHeight = playlist.container.offsetHeight;
      adsRequest.nonLinearAdSlotWidth = playlist.container.offsetWidth;
      adsRequest.nonLinearAdSlotHeight = playlist.container.offsetHeight;

      log('IMA: Requesting ads from:', vastUrl);
      adsLoader.requestAds(adsRequest);

      // Timeout safety
      const adTimeout = setTimeout(() => {
        error('IMA: Ad timeout');
        if (adsManager) {
          adsManager.destroy();
        }
        onAdComplete(playlist);
        resolve();
      }, 30000); // 30 secondi timeout

      // Clear timeout on completion (wrappa sia resolve che reject per evitare race condition)
      const cleanup = () => clearTimeout(adTimeout);

      const originalResolve = resolve;
      const originalReject = reject;

      resolve = function() {
        cleanup();
        originalResolve.apply(this, arguments);
      };

      reject = function() {
        cleanup();
        originalReject.apply(this, arguments);
      };
    });
  }

  /**
   * Callback quando ad è completato
   */
  function onAdComplete(playlist) {
    log('Ad completato');

    playlist.isPlayingAd = false;
    playlist.adsOverlay.style.display = 'none';

    firePlaylistEvent(playlist.playerId, 'ad:complete');

    // Se in modalità solo-ad, chiudi il player. Altrimenti, continua con il video.
    if (playlist.config.adOnly) {
      log('Modalità ad-only, chiusura player dopo ad.');
      closePlaylist(playlist.playerId);
    } else {
      // Continua con il prossimo video content
      playVideoAtIndex(playlist, playlist.currentIndex);
    }
  }

  /**
   * Mostra messaggio di errore nella playlist
   */
  function showErrorMessage(playlist, message) {
    // Nascondi video element
    playlist.videoElement.style.display = 'none';
    playlist.adsOverlay.style.display = 'none';

    // Crea messaggio di errore
    const errorDiv = document.createElement('div');
    errorDiv.className = 'adhub-playlist-error';
    errorDiv.style.cssText = `
      width: 100%;
      height: 100%;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: center;
      background: #1a1a1a;
      color: #fff;
      padding: 20px;
      text-align: center;
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
    `;

    errorDiv.innerHTML = `
      <div style="font-size: 48px; margin-bottom: 15px;">⚠️</div>
      <div style="font-size: 16px; font-weight: 500; margin-bottom: 10px;">${message}</div>
      <div style="font-size: 12px; opacity: 0.7; margin-bottom: 20px;">
        Tentativi falliti: ${playlist.errorCount}/${playlist.maxErrors}
      </div>
      <button class="adhub-playlist-error-retry" style="
        background: rgba(255,255,255,0.2);
        border: 1px solid rgba(255,255,255,0.3);
        color: #fff;
        padding: 10px 20px;
        border-radius: 6px;
        cursor: pointer;
        font-size: 14px;
        font-weight: 500;
        transition: background 0.2s;
      ">
        Chiudi
      </button>
    `;

    // Aggiungi al container
    playlist.container.appendChild(errorDiv);

    // Handler bottone chiudi
    const retryBtn = errorDiv.querySelector('.adhub-playlist-error-retry');
    retryBtn.addEventListener('click', () => {
      closePlaylist(playlist.playerId);
    });

    retryBtn.addEventListener('mouseenter', () => {
      retryBtn.style.background = 'rgba(255,255,255,0.3)';
    });

    retryBtn.addEventListener('mouseleave', () => {
      retryBtn.style.background = 'rgba(255,255,255,0.2)';
    });
  }

  /**
   * Update playlist UI (titolo, progress)
   */
  function updatePlaylistUI(playlist) {
    const video = playlist.videos[playlist.currentIndex];

    // Update title
    const titleEl = playlist.uiOverlay.querySelector('.adhub-playlist-title');
    if (titleEl && video) {
      titleEl.textContent = video.name;
    }

    // Update progress
    const currentEl = playlist.uiOverlay.querySelector('.adhub-playlist-current');
    const totalEl = playlist.uiOverlay.querySelector('.adhub-playlist-total');

    if (currentEl) {
      currentEl.textContent = String(playlist.currentIndex + 1);
    }

    if (totalEl) {
      totalEl.textContent = String(playlist.videos.length);
    }
  }

  /**
   * Fire playlist event
   */
  function firePlaylistEvent(playerId, eventType, data = {}) {
    log(`Event: ${eventType}`, data);

    window.dispatchEvent(new CustomEvent('adhub:playlist:' + eventType, {
      detail: {
        playerId,
        eventType,
        timestamp: Date.now(),
        ...data
      }
    }));
  }

  /**
   * Chiudi playlist
   */
  function closePlaylist(playerId) {
    const playlist = state.playlists.get(playerId);
    if (!playlist || playlist.isClosed) {
      return;
    }

    log('Chiusura playlist:', playerId);

    playlist.isClosed = true;

    // CLEANUP EVENT LISTENERS (fix memory leak)
    if (playlist.eventHandlers) {
      const { videoElement } = playlist;

      // Rimuovi video event listeners
      if (playlist.eventHandlers.videoEnded) {
        videoElement.removeEventListener('ended', playlist.eventHandlers.videoEnded);
      }
      if (playlist.eventHandlers.videoError) {
        videoElement.removeEventListener('error', playlist.eventHandlers.videoError);
      }
      if (playlist.eventHandlers.videoPlay) {
        videoElement.removeEventListener('play', playlist.eventHandlers.videoPlay);
      }
      if (playlist.eventHandlers.videoPause) {
        videoElement.removeEventListener('pause', playlist.eventHandlers.videoPause);
      }

      // Rimuovi button event listeners
      if (playlist.nextBtn) {
        if (playlist.eventHandlers.nextBtnClick) {
          playlist.nextBtn.removeEventListener('click', playlist.eventHandlers.nextBtnClick);
        }
        if (playlist.eventHandlers.nextBtnMouseenter) {
          playlist.nextBtn.removeEventListener('mouseenter', playlist.eventHandlers.nextBtnMouseenter);
        }
        if (playlist.eventHandlers.nextBtnMouseleave) {
          playlist.nextBtn.removeEventListener('mouseleave', playlist.eventHandlers.nextBtnMouseleave);
        }
      }
      if (playlist.muteBtn) {
        if (playlist.eventHandlers.muteBtnClick) {
          playlist.muteBtn.removeEventListener('click', playlist.eventHandlers.muteBtnClick);
        }
        if (playlist.eventHandlers.muteBtnMouseenter) {
          playlist.muteBtn.removeEventListener('mouseenter', playlist.eventHandlers.muteBtnMouseenter);
        }
        if (playlist.eventHandlers.muteBtnMouseleave) {
          playlist.muteBtn.removeEventListener('mouseleave', playlist.eventHandlers.muteBtnMouseleave);
        }
      }

      // Cleanup riferimenti
      playlist.eventHandlers = null;
    }

    // Cleanup close button event listeners
    if (playlist.closeButton && playlist.closeButton._handlers) {
      if (playlist.closeButton._handlers.mouseenter) {
        playlist.closeButton.removeEventListener('mouseenter', playlist.closeButton._handlers.mouseenter);
      }
      if (playlist.closeButton._handlers.mouseleave) {
        playlist.closeButton.removeEventListener('mouseleave', playlist.closeButton._handlers.mouseleave);
      }
      if (playlist.closeButton._handlers.click) {
        playlist.closeButton.removeEventListener('click', playlist.closeButton._handlers.click);
      }
      playlist.closeButton._handlers = null;
    }

    // Stop video
    playlist.videoElement.pause();
    playlist.videoElement.src = '';

    // Animazione uscita
    playlist.container.style.transition = 'all 300ms ease-in';
    playlist.container.style.opacity = '0';
    playlist.container.style.transform = playlist.position.startsWith('sticky-')
      ? 'translateY(20px)'
      : 'scale(0.95)';

    setTimeout(() => {
      playlist.container.remove();
      state.playlists.delete(playerId);

      firePlaylistEvent(playerId, 'closed');

      log('Playlist rimossa:', playerId);
    }, 300);
  }

  /**
   * Chiudi tutte le playlist
   */
  function closeAllPlaylists() {
    log('Chiusura di tutte le playlist');
    state.playlists.forEach((playlist, playerId) => {
      closePlaylist(playerId);
    });
  }

  // ============================================================================
  // INITIALIZATION
  // ============================================================================

  /**
   * Auto-init playlist dai placeholder HTML
   * Cerca div con attributo data-adhub-playlist o playlist, o ID adhub-player
   */
  function autoInitFromDOM() {
    log('Auto-init: Cerca placeholder playlist nel DOM');

    // Cerca elementi con data-adhub-playlist o playlist attribute
    const placeholders = document.querySelectorAll('[data-adhub-playlist], [playlist]');

    // Cerca anche elemento con ID adhub-player (default)
    const defaultPlayer = document.getElementById('adhub-player');

    // Crea lista elementi da processare
    const elementsToProcess = new Set();

    placeholders.forEach(el => elementsToProcess.add(el));

    if (defaultPlayer && !elementsToProcess.has(defaultPlayer)) {
      elementsToProcess.add(defaultPlayer);
    }

    elementsToProcess.forEach((element) => {
      const playlistCode = element.getAttribute('data-adhub-playlist') ||
                          element.getAttribute('playlist') ||
                          state.config.defaultPlaylist;

      const playerId = element.id || `playlist-auto-${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;

      // Set ID se non presente
      if (!element.id) {
        element.id = playerId;
      }

      // Leggi altri attributi opzionali
      const position = element.getAttribute('data-position') || 'in-content';
      const enableAds = element.getAttribute('data-enable-ads') !== 'false';
      const sizePreset = element.getAttribute('data-size-preset') || 'standard';
      const autoPlay = element.getAttribute('data-autoplay') !== 'false';
      const videoUrl = element.getAttribute('data-video-url') || null; // Nuovo: URL video diretto

      // Audio strategy attributes (nuovi)
      const preferUnmuted = element.getAttribute('data-prefer-unmuted-ads');
      const fallbackMuted = element.getAttribute('data-fallback-muted-ads');
      const startMuted = element.getAttribute('data-start-muted');

      if (videoUrl) {
        log(`Auto-init playlist: ${playerId}, video diretto: ${videoUrl}, position: ${position}`);
      } else {
        log(`Auto-init playlist: ${playerId}, playlist: ${playlistCode}, position: ${position}`);
      }

      // Crea config options
      const options = {
        playlist: playlistCode,
        position: position,
        enableAds: enableAds,
        sizePreset: sizePreset,
        autoPlay: autoPlay,
        videoUrl: videoUrl // Nuovo: supporto per URL video diretto
      };

      // Audio strategy config (se specificato)
      if (preferUnmuted !== null) {
        options.preferUnmutedAds = preferUnmuted !== 'false';
      }
      if (fallbackMuted !== null) {
        options.fallbackToMutedAds = fallbackMuted !== 'false';
      }
      if (startMuted !== null) {
        // Può essere: 'auto' | 'true' | 'false'
        if (startMuted === 'true') {
          options.startMuted = true;
        } else if (startMuted === 'false') {
          options.startMuted = false;
        } else {
          options.startMuted = 'auto'; // default
        }
      }

      // Crea playlist
      createPlaylist(playerId, options).catch(err => {
        error(`Errore auto-init playlist ${playerId}:`, err);
      });
    });

    if (elementsToProcess.size === 0) {
      log('Auto-init: Nessun placeholder trovato');
    } else {
      log(`Auto-init: ${elementsToProcess.size} playlist inizializzate`);
    }
  }

  async function init(config = {}) {
    if (state.initialized) {
      log('Già inizializzato');
      return;
    }

    // Merge config
    state.config = {
      ...DEFAULT_CONFIG,
      ...config
    };

    // Debug mode da URL
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('debug') === 'playlist') {
      state.config.debug = true;
    }

    // Carica IMA SDK se ads abilitati
    if (state.config.enableAds) {
      try {
        await loadImaSDK();
      } catch (err) {
        error('Impossibile caricare IMA SDK, ads disabilitati:', err);
        state.config.enableAds = false;
      }
    }

    // Cleanup on page unload
    window.addEventListener('beforeunload', closeAllPlaylists);

    state.initialized = true;

    log('✅ Modulo Playlist inizializzato', state.config);

    // Dispatch event
    window.dispatchEvent(new CustomEvent('adhub:playlist:ready'));

    // Auto-init from DOM se abilitato
    if (state.config.autoInitFromDOM) {
      // Aspetta che il DOM sia pronto
      if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', autoInitFromDOM);
      } else {
        // DOM già pronto, init subito
        setTimeout(autoInitFromDOM, 100);
      }
    }
  }

  // ============================================================================
  // PUBLIC API
  // ============================================================================

  window.AdHubVideoPlaylist = {
    // Initialization
    init,

    // Playlist management
    createPlaylist,
    closePlaylist,
    closeAllPlaylists,

    // Getters
    getPlaylist: (playerId) => state.playlists.get(playerId),
    getAllPlaylists: () => Array.from(state.playlists.values()),
    getConfig: () => ({...state.config}),

    // Setters
    setConfig: (config) => {
      state.config = {...state.config, ...config};
      log('Config aggiornata:', state.config);
    },

    // Control
    playNext: (playerId) => {
      const playlist = state.playlists.get(playerId);
      if (playlist) playNextVideo(playlist);
    },

    playVideoAt: (playerId, index) => {
      const playlist = state.playlists.get(playerId);
      if (playlist) playVideoAtIndex(playlist, index);
    },

    // State
    isInitialized: () => state.initialized,

    // Utils
    isMobile
  };

  // Auto-init
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', () => init());
  } else {
    init();
  }

  console.log('[AdHubVideoPlaylist] ✅ Modulo caricato (versione 1.0.0)');

})();

// ============================================================================
// VIDEO PLAYLIST CONFIGURATION (SITE-SPECIFIC)
// ============================================================================

/**
 * AdHubMedia.com - Video Playlist Configuration
 *
 * Configurazione e helper per video playlist con:
 * - Content video da CloudFront
 * - Ads VAST/VPAID tra i video
 * - Sticky positioning
 * - Playlist: viral, news, gossip, donnemagazine, actualidad
 *
 * @version 1.0.0
 * @date 2024-11-04
 */

(function() {
  'use strict';

  // Protezione contro doppio caricamento
  if (window.__adHubMediaPlaylistConfigLoaded) {
    console.warn('[AdHubMedia Playlist] Config già caricata');
    return;
  }
  window.__adHubMediaPlaylistConfigLoaded = true;

  const SITE_NAME = 'adhubmedia';

  // ============================================================================
  // CONFIGURAZIONE PLAYLIST
  // ============================================================================

  const PLAYLIST_CONFIG = {
    // API endpoint (già configurato in AdHubVideoPlaylist)
    apiEndpoint: 'https://static.4wnetwork.com/asset/api/playlist.php',
    apiKey: 'Y2Q0MjgyYTZhNzgxM2E1NDRlN2MxNTE',

    // Playlist disponibili per il sito
    availablePlaylists: [
      'viral',          // Lifestyle: acne, ansia, capelli, dormire
      'news',           // News: avvocato incidenti, difesa, multe
      'gossip',         // Spettacolo: off camera interviste
      'donnemagazine',  // Donna: chirurgo botox, psicologa
      'actualidad'      // Actualidad: vari temi (ES)
    ],

    defaultPlaylist: 'viral',

    // Ads configuration
    ads: {
      enabled: true,
      preRoll: true,             // Ad prima del primo video
      midRoll: true,             // Ad tra i video
      midRollFrequency: 1,       // Un ad ogni 1 video content (tra ogni video)
      postRoll: false,           // Nessun ad finale

      // Video ad units (da video-config.js)
      adUnitCodes: {
        sticky: 'adhub-video-sticky-left',  // o right
        inContent: 'adhub-video-in-article'
      }
    },

    // Player settings
    player: {
      controls: true,
      autoPlay: true,
      loop: true,                // Riparti dall'inizio
      showTitle: true,
      showProgress: true,
      showNextButton: true,
      closeDelay: 5,             // secondi
      sizePreset: 'standard'     // standard, hd, compact, ecc.
    }
  };

  // ============================================================================
  // HELPER FUNCTIONS
  // ============================================================================

  /**
   * Ottieni video ad unit per posizione
   *
   * @param {string} position - Posizione playlist (sticky-bottom-left, sticky-bottom-right, in-content)
   * @param {string} adUnitCode - Ad unit code da usare (opzionale, altrimenti generato)
   */
  function getVideoAdUnit(position, adUnitCode) {
    const mobile = isMobile();

    // Se non specificato, determina l'ad unit code dalla posizione
    if (!adUnitCode) {
      if (position === 'sticky-bottom-left' || position === 'sticky-bottom-right') {
        adUnitCode = position === 'sticky-bottom-left'
          ? 'adhub-video-sticky-left'
          : 'adhub-video-sticky-right';
      } else {
        adUnitCode = 'adhub-video-in-article';
      }
    }

    // Ottieni size preset
    const sizePreset = PLAYLIST_CONFIG.player.sizePreset;

    return {
      code: adUnitCode,
      mediaTypes: {
        video: {
          context: 'outstream',
          playerSize: getPlayerSize(sizePreset, mobile),
          mimes: ['video/mp4'],
          protocols: [2, 3, 5, 6],
          playbackmethod: [1],
          api: [2],
          linearity: 2,
          minduration: 5,
          maxduration: 30,
          skip: 1,
          skipafter: 5
        }
      },
      bids: generateVideoBids(mobile)
    };
  }

  /**
   * Genera bids per video ads
   */
  function generateVideoBids(mobile) {
    const bids = [];

    // Nexx360 (principale)
    if (window.AdHubVideoConfig &&
        window.AdHubVideoConfig.ssp.nexx360 &&
        window.AdHubVideoConfig.ssp.nexx360.enabled) {

      const nexx360Config = mobile
        ? window.AdHubVideoConfig.ssp.nexx360.mobile
        : window.AdHubVideoConfig.ssp.nexx360.desktop;

      bids.push({
        bidder: 'nexx360',
        params: {
          tagId: nexx360Config.tagId,
          videoTagId: nexx360Config.videoTagId
        }
      });
    }

    return bids;
  }

  /**
   * Ottieni player size
   */
  function getPlayerSize(sizePreset, mobile) {
    if (window.AdHubVideoConfig && window.AdHubVideoConfig.getSizeConfig) {
      const sizeConfig = window.AdHubVideoConfig.getSizeConfig(sizePreset, mobile);
      return sizeConfig.playerSize;
    }

    // Fallback
    return mobile ? [[400, 300]] : [[640, 480]];
  }

  function isMobile() {
    return window.innerWidth < 768;
  }

  // ============================================================================
  // INTEGRAZIONE ADS CON PREBID
  // ============================================================================

  /**
   * Request video ad tramite Prebid
   *
   * Questa funzione viene chiamata automaticamente da adhub-video-playlist.js
   * quando è necessario mostrare un ad nella playlist.
   *
   * @param {string} adUnitCode - Ad unit code per la richiesta Prebid
   * @param {string} position - Posizione playlist per determinare config
   * @returns {Promise} Promise che si risolve con { vastUrl, bid, cpm } o viene rejected
   */
  async function requestVideoAd(adUnitCode, position) {
    console.log('[AdHubMedia Playlist] 📺 Request video ad:', adUnitCode, 'position:', position);

    return new Promise((resolve, reject) => {
      if (typeof pbjs === 'undefined') {
        console.error('[AdHubMedia Playlist] ❌ Prebid non disponibile');
        reject(new Error('Prebid not available'));
        return;
      }

      // Genera ad unit con il code corretto passato dal caller
      const adUnit = getVideoAdUnit(position, adUnitCode);

      console.log('[AdHubMedia Playlist] 🎯 Ad unit generato:', adUnit);

      // Add ad unit a Prebid
      pbjs.que.push(function() {
        // Remove existing ad unit con stesso code (se presente)
        pbjs.removeAdUnit(adUnitCode);

        // Add nuovo ad unit
        pbjs.addAdUnits([adUnit]);

        console.log('[AdHubMedia Playlist] 🔄 Requesting bids per:', adUnitCode);

        // Request bids
        pbjs.requestBids({
          adUnitCodes: [adUnitCode],
          timeout: 2000,
          bidsBackHandler: function(bids) {
            console.log('[AdHubMedia Playlist] 📬 Bids back:', bids);

            // Ottieni VAST URL dal winning bid
            const adUnitBids = pbjs.getBidResponsesForAdUnitCode(adUnitCode);

            if (adUnitBids && adUnitBids.bids && adUnitBids.bids.length > 0) {
              const winningBid = adUnitBids.bids[0];

              console.log('[AdHubMedia Playlist] 🏆 Winning bid:', winningBid);

              // VAST URL può essere in diversi campi a seconda del bidder
              const vastUrl = winningBid.vastUrl || winningBid.vastXml || null;

              if (vastUrl) {
                console.log('[AdHubMedia Playlist] ✅ VAST URL ottenuto:', vastUrl);

                // Track bid won in analytics se disponibile
                if (window.AdHubAnalytics && window.AdHubAnalytics.trackBid) {
                  window.AdHubAnalytics.trackBid({
                    adUnitCode: adUnitCode,
                    bidder: winningBid.bidder,
                    cpm: winningBid.cpm,
                    currency: winningBid.currency || 'EUR',
                    mediaType: 'video',
                    size: winningBid.size || 'playlist',
                    status: 'won',
                    vastUrl: vastUrl
                  });
                }

                resolve({
                  vastUrl,
                  bid: winningBid,
                  cpm: winningBid.cpm
                });
              } else {
                console.warn('[AdHubMedia Playlist] ⚠️ Nessun VAST URL nel bid');
                reject(new Error('No VAST URL in winning bid'));
              }
            } else {
              console.warn('[AdHubMedia Playlist] ⚠️ Nessun bid vinto');
              reject(new Error('No bids'));
            }
          }
        });
      });
    });
  }

  // ============================================================================
  // PUBLIC API
  // ============================================================================

  window.AdHubMediaPlaylist = {

    /**
     * Mostra playlist sticky (left o right)
     *
     * @param {string} position - 'left' o 'right'
     * @param {object} options - Opzioni { playlist, videoUrl, sizePreset, enableAds }
     */
    showStickyPlaylist: async function(position, options = {}) {
      options = options || {};

      let playlistCode = options.playlist || PLAYLIST_CONFIG.defaultPlaylist;

      // Validazione playlist code
      if (PLAYLIST_CONFIG.availablePlaylists.indexOf(playlistCode) === -1) {
        console.warn('[AdHubMedia Playlist] Playlist "' + playlistCode + '" non disponibile. Uso default: ' + PLAYLIST_CONFIG.defaultPlaylist);
        playlistCode = PLAYLIST_CONFIG.defaultPlaylist;
      }

      const playerId = `playlist-sticky-${position}`;
      const stickyPosition = position === 'left'
        ? 'sticky-bottom-left'
        : 'sticky-bottom-right';

      console.log('[AdHubMedia Playlist] Creazione sticky playlist:', position, playlistCode, 'videoUrl:', options.videoUrl);

      // Verifica che AdHubVideoPlaylist sia disponibile
      if (!window.AdHubVideoPlaylist) {
        console.error('[AdHubMedia Playlist] AdHubVideoPlaylist non caricato');
        return null;
      }

      // Crea playlist con config
      const playlist = await window.AdHubVideoPlaylist.createPlaylist(playerId, {
        playlist: playlistCode,
        position: stickyPosition,
        enableAds: options.enableAds !== false ? PLAYLIST_CONFIG.ads.enabled : false,
        preRoll: PLAYLIST_CONFIG.ads.preRoll,
        midRoll: PLAYLIST_CONFIG.ads.midRoll,
        midRollFrequency: PLAYLIST_CONFIG.ads.midRollFrequency,
        postRoll: PLAYLIST_CONFIG.ads.postRoll,
        adRequestCallback: requestVideoAd, // <-- INJECT DEPENDENCY
        ...PLAYLIST_CONFIG.player,
        ...options
      });

      // Track playlist created
      if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
        window.AdHubAnalytics.trackEvent('video_playlist_created', {
          category: 'video_playlist',
          label: playlistCode,
          playerId: playerId,
          position: stickyPosition,
          adsEnabled: options.enableAds !== false
        });
      }

      return playlist;
    },

    /**
     * Mostra playlist in-content
     *
     * @param {string} elementId - ID elemento DOM
     * @param {object} options - Opzioni { playlist, videoUrl, sizePreset, enableAds }
     */
    showInContentPlaylist: async function(elementId, options = {}) {
      options = options || {};

      let playlistCode = options.playlist || PLAYLIST_CONFIG.defaultPlaylist;

      // Validazione playlist code
      if (PLAYLIST_CONFIG.availablePlaylists.indexOf(playlistCode) === -1) {
        console.warn('[AdHubMedia Playlist] Playlist "' + playlistCode + '" non disponibile. Uso default: ' + PLAYLIST_CONFIG.defaultPlaylist);
        playlistCode = PLAYLIST_CONFIG.defaultPlaylist;
      }

      const playerId = elementId;

      console.log('[AdHubMedia Playlist] Creazione in-content playlist:', playlistCode, 'videoUrl:', options.videoUrl);

      // Verifica che AdHubVideoPlaylist sia disponibile
      if (!window.AdHubVideoPlaylist) {
        console.error('[AdHubMedia Playlist] AdHubVideoPlaylist non caricato');
        return null;
      }

      // Crea playlist normale
      const playlist = await window.AdHubVideoPlaylist.createPlaylist(playerId, {
        playlist: playlistCode,
        position: 'in-content',
        enableAds: options.enableAds !== false ? PLAYLIST_CONFIG.ads.enabled : false,
        preRoll: PLAYLIST_CONFIG.ads.preRoll,
        midRoll: PLAYLIST_CONFIG.ads.midRoll,
        midRollFrequency: PLAYLIST_CONFIG.ads.midRollFrequency,
        postRoll: PLAYLIST_CONFIG.ads.postRoll,
        adRequestCallback: requestVideoAd, // <-- INJECT DEPENDENCY
        ...PLAYLIST_CONFIG.player,
        ...options
      });

      // Track playlist created
      if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
        window.AdHubAnalytics.trackEvent('video_playlist_created', {
          category: 'video_playlist',
          label: playlistCode,
          playerId: playerId,
          position: 'in-content',
          adsEnabled: options.enableAds !== false
        });
      }

      return playlist;
    },

    /**
     * Request video ad (per uso interno)
     */
    requestVideoAd,

    /**
     * Chiudi playlist
     */
    closePlaylist: function(playerId) {
      if (window.AdHubVideoPlaylist) {
        window.AdHubVideoPlaylist.closePlaylist(playerId);
      }
    },

    /**
     * Chiudi tutte le playlist
     */
    closeAllPlaylists: function() {
      if (window.AdHubVideoPlaylist) {
        window.AdHubVideoPlaylist.closeAllPlaylists();
      }
    },

    /**
     * Ottieni config
     */
    getConfig: function() {
      return {
        site: SITE_NAME,
        config: PLAYLIST_CONFIG,
        availablePlaylists: PLAYLIST_CONFIG.availablePlaylists
      };
    },

    /**
     * Lista playlist disponibili
     */
    listPlaylists: function() {
      console.group('📺 Playlist Disponibili per AdHubMedia');
      PLAYLIST_CONFIG.availablePlaylists.forEach((playlist, index) => {
        const isDefault = playlist === PLAYLIST_CONFIG.defaultPlaylist;
        console.log(`${index + 1}. ${playlist}${isDefault ? ' (default)' : ''}`);
      });
      console.groupEnd();
      console.log('\n💡 Uso:');
      console.log('  AdHubMediaPlaylist.showStickyPlaylist("left", { playlist: "viral" })');
      console.log('  AdHubMediaPlaylist.showInContentPlaylist("my-div", { playlist: "news" })');
    }
  };

  // ============================================================================
  // EVENT LISTENERS
  // ============================================================================

  // Ascolta eventi playlist
  window.addEventListener('adhub:playlist:ready', function(e) {
    console.log('[AdHubMedia Playlist] Playlist ready');

    // Track playlist module loaded
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_ready', {
        category: 'video_playlist',
        label: 'module_ready'
      });
    }
  });

  window.addEventListener('adhub:playlist:video:load', function(e) {
    console.log('[AdHubMedia Playlist] Video caricato:', e.detail);

    // Track content video view
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_video_view', {
        category: 'video_playlist',
        label: e.detail.video?.name || 'unknown',
        playerId: e.detail.playerId,
        videoIndex: e.detail.index
      });
    }
  });

  window.addEventListener('adhub:playlist:ad:request', function(e) {
    console.log('[AdHubMedia Playlist] Ad richiesto:', e.detail);

    // Track ad request
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_ad_request', {
        category: 'video_playlist',
        label: 'ad_requested',
        playerId: e.detail.playerId
      });
    }

    // L'integrazione Prebid è già gestita direttamente in adhub-video-playlist.js
    // quando chiama window.AdHubMediaPlaylist.requestVideoAd()
  });

  // ✨ FIX: Refresh display ads dopo video ad impression
  // Questo evita competitive exclusion tra video e display ads
  window.addEventListener('adhub:playlist:ad:impression', function(e) {
    console.log('[AdHubMedia Playlist] 🎬 Video ad impression:', e.detail);

    // Delay 30s per stabilizzare video ad prima di refresh display
    setTimeout(function() {
      console.log('[AdHubMedia Playlist] 🔄 Triggering display ads refresh (after 30s)');

      // Verifica se GAM è disponibile
      if (typeof googletag !== 'undefined' && googletag.pubads) {
        googletag.cmd.push(function() {
          // Get SOLO slot AdHub (strict isolation)
          const allSlots = googletag.pubads().getSlots();
          const displaySlots = allSlots.filter(function(slot) {
            const slotId = slot.getSlotElementId();
            // Refresh SOLO slot che iniziano con 'adhub-' ed escludono video/playlist
            return slotId.indexOf('adhub-') === 0 &&
                   slotId.indexOf('video') === -1 &&
                   slotId.indexOf('playlist') === -1;
          });

          if (displaySlots.length > 0) {
            console.log('[AdHubMedia Playlist] 📺 Refreshing ' + displaySlots.length + ' AdHub display slots');
            googletag.pubads().refresh(displaySlots);
          } else {
            console.log('[AdHubMedia Playlist] ⚠️ No AdHub display slots to refresh');
          }
        });
      } else {
        console.warn('[AdHubMedia Playlist] ⚠️ GAM not available for display refresh');
      }
    }, 30000); // 30 secondi
  });

  window.addEventListener('adhub:playlist:ad:start', function(e) {
    console.log('[AdHubMedia Playlist] 🎬 Ad started:', e.detail);

    // Track video ad start in analytics se disponibile
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_ad_start', {
        playerId: e.detail.playerId,
        timestamp: e.detail.timestamp
      });
    }
  });

  window.addEventListener('adhub:playlist:ad:complete', function(e) {
    console.log('[AdHubMedia Playlist] ✅ Ad completato:', e.detail);

    // Track video ad completion in analytics se disponibile
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_ad_complete', {
        playerId: e.detail.playerId,
        timestamp: e.detail.timestamp
      });
    }
  });

  window.addEventListener('adhub:playlist:ad:error', function(e) {
    console.error('[AdHubMedia Playlist] ❌ Ad error:', e.detail);

    // Track video ad error in analytics se disponibile
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_ad_error', {
        playerId: e.detail.playerId,
        error: e.detail.error,
        timestamp: e.detail.timestamp
      });
    }
  });

  window.addEventListener('adhub:playlist:ad:skipped', function(e) {
    console.log('[AdHubMedia Playlist] ⏭️ Ad skipped:', e.detail);

    // Track video ad skip in analytics se disponibile
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_ad_skipped', {
        playerId: e.detail.playerId,
        timestamp: e.detail.timestamp
      });
    }
  });

  window.addEventListener('adhub:playlist:closed', function(e) {
    console.log('[AdHubMedia Playlist] Playlist chiusa:', e.detail);

    // Track playlist closed
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_closed', {
        category: 'video_playlist',
        label: 'playlist_closed',
        playerId: e.detail.playerId
      });
    }
  });

  window.addEventListener('adhub:playlist:playlist:complete', function(e) {
    console.log('[AdHubMedia Playlist] Playlist completata:', e.detail);

    // Track playlist completion
    if (window.AdHubAnalytics && window.AdHubAnalytics.trackEvent) {
      window.AdHubAnalytics.trackEvent('video_playlist_complete', {
        category: 'video_playlist',
        label: 'playlist_complete',
        playerId: e.detail.playerId
      });
    }
  });

  console.log('[AdHubMedia Playlist] ✅ Configurazione playlist caricata');

  // Debug helper
  if (window.location.search.indexOf('debug=playlist') !== -1) {
    window.AdHubMediaPlaylist.listPlaylists();
  }

})();
