/**
 * AdHub Legacy SDK - Compatibility Layer for 4wnetwork tags
 * @version 1.0.0
 * @date 2025-11-17
 * @author AdHubMedia
 * @license PROPRIETARY
 *
 * Replaces: https://static.4wnetwork.com/js/sdk.min.js
 * New URL: https://lib.adhubmedia.com/sdk/sdk.min.js
 */

!function(e){"use strict";const t={debug:!1,adhubBundleUrl:"https://lib.adhubmedia.com/dist/legacy_adhubmedia/adhub-legacy_adhubmedia-no-cmp.min.js",bundleVersion:null,defaultSiteCode:"legacy_adhubmedia",autoLoadBundle:!0,addBaseStyles:!0,placeholderBaseStyle:"margin: 10px auto; text-align: center; min-height: 50px;",placeholderPrefix:"adhub-legacy-",globalKeyValues:{tag_old_platform:"true",sdk_version:"legacy-1.0.0"},icMapping:{0:"legacy_publisher",1:"legacy_zone",2:"legacy_placement",3:"legacy_param"},bundleLoadTimeout:1e4,retryBundleLoad:!0,maxRetries:3,retryDelay:2e3,inlineInsertion:!0,preserveOriginalScript:!1,tracking:{enabled:!0,endpoint:null,events:{tagParsed:!0,placeholderCreated:!0,bundleLoaded:!0,adRendered:!1,errors:!0}},errorHandling:{logErrors:!0,showErrorsInPlaceholder:!1,createFallbackPlaceholder:!0},responsive:{autoHide:!0,breakpoints:{mobile:768,tablet:1024,desktop:1280}},lazyLoad:{enabled:!1,threshold:200}},o={display:{defaultStyle:"display: block; margin: 10px auto;",minHeight:"50px",autoResize:!1},native:{defaultStyle:"display: block; width: 100%;",minHeight:"100px",autoResize:!0},video:{defaultStyle:"display: block; margin: 10px auto; background: #000;",minHeight:"200px",autoResize:!1,videoAttributes:{"data-adhub-video":"in-article","data-video-autoplay":"false","data-video-muted":"true"}}},i={loading:"Caricamento annuncio...",error:"Errore caricamento annuncio",noAds:"Nessun annuncio disponibile",blocked:"Annuncio bloccato (AdBlocker rilevato)"};e.AdHubLegacyDefaults={getConfig:function(){return t},getFormatConfig:function(e){return o[e]||o.display},mergeConfig:function(e){const o={};return Object.keys(t).forEach(function(e){"object"!=typeof t[e]||Array.isArray(t[e])?o[e]=t[e]:o[e]=Object.assign({},t[e])}),e&&Object.keys(e).forEach(function(t){"object"!=typeof e[t]||Array.isArray(e[t])?o[t]=e[t]:o[t]=Object.assign(o[t]||{},e[t])}),o},getMessage:function(e){return i[e]||""},getMessages:function(){return i},loadFromWindow:function(){return e.AdHubLegacyConfig?this.mergeConfig(e.AdHubLegacyConfig):t},debug:function(){console.group("⚙️  AdHub Legacy SDK - Configuration"),console.log("Default Config:",t),console.log("Format Configs:",o),console.log("Messages:",i),console.groupEnd()}}}(window),function(e){"use strict";const t={"728x90":{type:"display",category:"leaderboard",placeholder:"adhub-728x90-banner",multiple:!0,description:"Leaderboard (Desktop)"},"970x90":{type:"display",category:"leaderboard",placeholder:"adhub-970x90-banner",multiple:!0,description:"Super Leaderboard (Desktop)"},"970x250":{type:"display",category:"billboard",placeholder:"adhub-billboard",multiple:!0,description:"Billboard (Desktop)"},"300x250":{type:"display",category:"rectangle",placeholder:"adhub-300x250",multiple:!0,description:"Medium Rectangle"},"336x280":{type:"display",category:"rectangle",placeholder:"adhub-336x280",multiple:!0,description:"Large Rectangle"},"160x600":{type:"display",category:"skyscraper",placeholder:"adhub-160x600-sidebar",multiple:!0,description:"Wide Skyscraper"},"120x600":{type:"display",category:"skyscraper",placeholder:"adhub-120x600-sidebar",multiple:!0,description:"Skyscraper"},"300x600":{type:"display",category:"halfpage",placeholder:"adhub-300x600-sidebar",multiple:!0,description:"Half Page"},"468x60":{type:"display",category:"banner",placeholder:"adhub-468x60-banner",multiple:!0,description:"Full Banner (Desktop)"},"234x60":{type:"display",category:"banner",placeholder:"adhub-234x60-banner",multiple:!0,description:"Half Banner"},"320x50":{type:"display",category:"mobile-banner",placeholder:"adhub-mobile-banner",multiple:!0,description:"Mobile Banner"},"320x100":{type:"display",category:"mobile-banner",placeholder:"adhub-mobile-large",multiple:!0,description:"Mobile Large Banner"},"300x50":{type:"display",category:"mobile-banner",placeholder:"adhub-300x50-mobile",multiple:!0,description:"Mobile Banner Small"},"1x1":{type:"native",category:"native-content",placeholder:"adhub-native",multiple:!0,description:"Native Ad (Fluid)"},"0x0":{type:"native",category:"native-content",placeholder:"adhub-native",multiple:!0,description:"Native Ad (Responsive)"},"640x360":{type:"video",category:"video-player",placeholder:"adhub-video-player",multiple:!0,videoType:"instream",description:"Video Player 16:9 (Medium)"},"640x480":{type:"video",category:"video-player",placeholder:"adhub-video-player",multiple:!0,videoType:"instream",description:"Video Player 4:3 (Medium)"},"854x480":{type:"video",category:"video-player",placeholder:"adhub-video-player",multiple:!0,videoType:"instream",description:"Video Player 480p"},"1280x720":{type:"video",category:"video-player",placeholder:"adhub-video-player",multiple:!0,videoType:"instream",description:"Video Player 720p HD"},"1920x1080":{type:"video",category:"video-player",placeholder:"adhub-video-player",multiple:!0,videoType:"instream",description:"Video Player 1080p Full HD"},"300x169":{type:"video",category:"video-small",placeholder:"adhub-video-small",multiple:!0,videoType:"outstream",description:"Video Small (Outstream)"},"400x300":{type:"video",category:"video-player",placeholder:"adhub-video-player",multiple:!0,videoType:"outstream",description:"Video Medium (Outstream)"}},o={type:"display",category:"custom",placeholder:"adhub-custom",multiple:!0,description:"Custom Size"},i={leaderboard:{name:"Leaderboard",devices:["desktop","tablet"]},billboard:{name:"Billboard",devices:["desktop"]},rectangle:{name:"Rectangle",devices:["desktop","tablet","mobile"]},skyscraper:{name:"Skyscraper",devices:["desktop"]},halfpage:{name:"Half Page",devices:["desktop"]},banner:{name:"Banner",devices:["desktop","tablet"]},"mobile-banner":{name:"Mobile Banner",devices:["mobile"]},"native-content":{name:"Native Content",devices:["all"]},"video-player":{name:"Video Player",devices:["all"]},"video-small":{name:"Video Small",devices:["all"]}};e.AdHubLegacyDimensions={getConfig:function(e){const i=this.normalizeDimension(e);return t[i]||o},normalizeDimension:function(e){if("string"==typeof e)return e.toLowerCase().replace(/[^0-9x]/g,"");if("object"==typeof e){return String(e.width||e.w||"0").replace(/[^0-9]/g,"")+"x"+String(e.height||e.h||"0").replace(/[^0-9]/g,"")}return"0x0"},isSupported:function(e){const o=this.normalizeDimension(e);return!!t[o]},getAll:function(){return t},getByType:function(e){return Object.keys(t).filter(function(o){return t[o].type===e}).map(function(e){return{dimension:e,config:t[e]}})},getByCategory:function(e){return Object.keys(t).filter(function(o){return t[o].category===e}).map(function(e){return{dimension:e,config:t[e]}})},getCategoryInfo:function(e){return i[e]||null},debug:function(){console.group("📐 AdHub Legacy Dimensions Map"),console.log("Total mappings:",Object.keys(t).length),console.group("Display Ads"),this.getByType("display").forEach(function(e){console.log(e.dimension,"→",e.config.placeholder,"-",e.config.description)}),console.groupEnd(),console.group("Native Ads"),this.getByType("native").forEach(function(e){console.log(e.dimension,"→",e.config.placeholder,"-",e.config.description)}),console.groupEnd(),console.group("Video Ads"),this.getByType("video").forEach(function(e){console.log(e.dimension,"→",e.config.placeholder,"-",e.config.description)}),console.groupEnd(),console.groupEnd()}}}(window),function(e){"use strict";const t={total:0,successful:0,failed:0,tags:[]},AdHubLegacyParser={init:function(t){this.config=t||e.AdHubLegacyDefaults.getConfig(),this.log("🔍 Parser inizializzato")},processAll:function(){if(this.log("📋 Processamento tag obj_4w..."),!e.obj_4w||!Array.isArray(e.obj_4w))return this.log("⚠️  Nessun tag obj_4w trovato"),[];const o=[],i=e.obj_4w.slice();return this.log("📦 Trovati "+i.length+" tag in coda"),i.forEach(function(e,i){t.total++;try{const n=this.parseTag(e,i);n?(o.push(n),t.successful++,t.tags.push(n)):t.failed++}catch(o){this.log("❌ Errore parsing tag #"+i+":",o),t.failed++,this.config.tracking.enabled&&this.config.tracking.events.errors&&this.trackEvent("parsing_error",{index:i,error:o.message,tagData:e})}}.bind(this)),this.log("✅ Parsing completato: "+t.successful+" successi, "+t.failed+" falliti"),o},parseTag:function(t,o){if(!t||"object"!=typeof t)return this.log("⚠️  Tag #"+o+" non valido (non è un oggetto)"),null;this.log("🔍 Parsing tag #"+o+":",t);const i=t.cid||t.clientId||null,n=t.ic||t.codes||null,a=t.dim||t.dimensions||t.size||null;if(!i)return this.log("⚠️  Tag #"+o+' mancante campo "cid"'),null;if(!a)return this.log("⚠️  Tag #"+o+' mancante campo "dim"'),null;const r=this.parseDimensions(a);if(!r)return this.log("⚠️  Tag #"+o+" dimensioni non valide:",a),null;const l=this.parseIC(n),s=e.AdHubLegacyDimensions.getConfig(r),c=this.findScriptElement(i),d={index:o,cid:i,dimensions:r,dimensionConfig:s,targeting:l,type:s.type,category:s.category,placeholderId:this.generatePlaceholderId(i,s,o),scriptElement:c,timestamp:Date.now(),userAgent:navigator.userAgent,raw:t};return this.log("✅ Tag #"+o+" processato:",d),this.config.tracking.enabled&&this.config.tracking.events.tagParsed&&this.trackEvent("tag_parsed",{cid:i,type:d.type,dimensions:r}),d},parseDimensions:function(e){if(!e)return null;if("string"==typeof e){const t=e.match(/(\d+)\s*x\s*(\d+)/i);if(t)return t[1]+"x"+t[2]}if("object"==typeof e){let t=e.width||e.w,o=e.height||e.h;if(t&&o&&(t=String(t).replace(/[^0-9]/g,""),o=String(o).replace(/[^0-9]/g,""),t&&o))return t+"x"+o}return null},parseIC:function(e){const t=Object.assign({},this.config.globalKeyValues);if(!e)return t;const o=String(e).split(";"),i=this.config.icMapping;return o.forEach(function(e,o){const n=i[o]||"legacy_code_"+o,a=e.trim();a&&(t[n]=a)}),t},generatePlaceholderId:function(e,t,o){return t.multiple?t.placeholder+"-"+o:t.placeholder},findScriptElement:function(e){if(!e)return null;const t=document.getElementById(e);if(t&&"SCRIPT"===t.tagName)return t;const o=document.querySelectorAll("script[id]");for(let t=0;t<o.length;t++)if(o[t].id===e)return o[t];return null},getStats:function(){return{total:t.total,successful:t.successful,failed:t.failed,successRate:t.total>0?(t.successful/t.total*100).toFixed(2)+"%":"0%",tags:t.tags}},resetStats:function(){t.total=0,t.successful=0,t.failed=0,t.tags=[]},trackEvent:function(e,t){if(!this.config.tracking.enabled)return;const o={name:e,timestamp:Date.now(),data:t};this.config.tracking.endpoint,this.log("📊 Track:",o)},log:function(){if(this.config&&this.config.debug){const e=Array.prototype.slice.call(arguments);console.log.apply(console,["[AdHub Legacy Parser]"].concat(e))}},debug:function(){console.group("🔍 AdHub Legacy Parser - Debug"),console.log("Config:",this.config),console.log("Stats:",this.getStats()),console.log("obj_4w queue:",e.obj_4w),console.groupEnd()}};e.AdHubLegacyParser=AdHubLegacyParser}(window),function(e){"use strict";const t={created:0,inserted:0,failed:0,placeholders:[]},AdHubLegacyPlaceholder={init:function(t){this.config=t||e.AdHubLegacyDefaults.getConfig(),this.log("📦 Placeholder Generator inizializzato")},createAll:function(e){this.log("🏗️  Creazione placeholder per "+e.length+" tag...");const o=[];return e.forEach(function(e){try{const i=this.create(e);i?(o.push(i),t.created++,t.placeholders.push(i)):t.failed++}catch(o){this.log("❌ Errore creazione placeholder per tag:",e.cid,o),t.failed++}}.bind(this)),this.log("✅ Creati "+t.created+" placeholder, "+t.failed+" falliti"),o},create:function(e){if(!e||!e.placeholderId)return this.log("⚠️  Tag non valido per creazione placeholder"),null;if(this.log("🏗️  Creazione placeholder:",e.placeholderId),document.getElementById(e.placeholderId))return this.log("⚠️  Placeholder già esistente:",e.placeholderId),null;const o=document.createElement("div");o.id=e.placeholderId,o.setAttribute("data-adhub-legacy","true"),o.setAttribute("data-legacy-cid",e.cid),o.setAttribute("data-legacy-type",e.type),o.setAttribute("data-legacy-dimensions",e.dimensions),e.targeting&&Object.keys(e.targeting).forEach(function(t){o.setAttribute("data-targeting-"+t,e.targeting[t])}),this.applyStyles(o,e),o.className="adhub-legacy-placeholder adhub-type-"+e.type;const i={id:e.placeholderId,element:o,tag:e,inserted:!1,timestamp:Date.now()};return this.insert(i)&&(i.inserted=!0,t.inserted++,this.config.tracking.enabled&&this.config.tracking.events.placeholderCreated&&this.trackEvent("placeholder_created",{id:i.id,type:e.type,dimensions:e.dimensions})),i},applyStyles:function(t,o){this.config.addBaseStyles&&t.setAttribute("style",this.config.placeholderBaseStyle);const i=e.AdHubLegacyDefaults.getFormatConfig(o.type);if(i&&i.defaultStyle){const e=t.getAttribute("style")||"";t.setAttribute("style",e+" "+i.defaultStyle)}if(i&&i.minHeight){const e=t.getAttribute("style")||"";t.setAttribute("style",e+" min-height: "+i.minHeight+";")}if("video"===o.type&&i.videoAttributes&&Object.keys(i.videoAttributes).forEach(function(e){t.setAttribute(e,i.videoAttributes[e])}),this.config.responsive.autoHide){const e=this.getDeviceType(o.dimensionConfig);e&&t.setAttribute("data-device",e)}},insert:function(e){const t=e.tag,o=e.element;if(this.config.inlineInsertion&&t.scriptElement){this.log("📍 Inserimento inline placeholder:",e.id);try{return t.scriptElement.nextSibling?t.scriptElement.parentNode.insertBefore(o,t.scriptElement.nextSibling):t.scriptElement.parentNode.appendChild(o),this.config.preserveOriginalScript||(t.scriptElement.style.display="none"),this.log("✅ Placeholder inserito inline:",e.id),!0}catch(e){this.log("❌ Errore inserimento inline:",e)}}this.log("📍 Inserimento placeholder nel body:",e.id);try{return document.body.appendChild(o),this.log("✅ Placeholder inserito nel body:",e.id),!0}catch(e){return this.log("❌ Errore inserimento nel body:",e),!1}},getDeviceType:function(t){if(!t||!t.category)return null;const o=e.AdHubLegacyDimensions.getCategoryInfo(t.category);if(!o||!o.devices)return null;const i=o.devices;return i.includes("all")?null:i.join(",")},remove:function(e){const t=document.getElementById(e);return!(!t||!t.parentNode)&&(t.parentNode.removeChild(t),this.log("🗑️  Placeholder rimosso:",e),!0)},removeAll:function(){const e=document.querySelectorAll('[data-adhub-legacy="true"]');let t=0;return e.forEach(function(e){e.parentNode&&(e.parentNode.removeChild(e),t++)}),this.log("🗑️  Rimossi "+t+" placeholder legacy"),t},exists:function(e){return!!document.getElementById(e)},getElement:function(e){return document.getElementById(e)},getAll:function(){return document.querySelectorAll('[data-adhub-legacy="true"]')},getStats:function(){return{created:t.created,inserted:t.inserted,failed:t.failed,successRate:t.created>0?(t.inserted/t.created*100).toFixed(2)+"%":"0%",placeholders:t.placeholders}},resetStats:function(){t.created=0,t.inserted=0,t.failed=0,t.placeholders=[]},trackEvent:function(e,t){if(!this.config.tracking.enabled)return;const o={name:e,timestamp:Date.now(),data:t};this.log("📊 Track:",o)},log:function(){if(this.config&&this.config.debug){const e=Array.prototype.slice.call(arguments);console.log.apply(console,["[AdHub Legacy Placeholder]"].concat(e))}},debug:function(){console.group("📦 AdHub Legacy Placeholder - Debug"),console.log("Config:",this.config),console.log("Stats:",this.getStats()),console.log("Placeholders in DOM:",this.getAll()),console.groupEnd()}};e.AdHubLegacyPlaceholder=AdHubLegacyPlaceholder}(window),function(e){"use strict";const t={loaded:!1,loading:!1,failed:!1,attempts:0,scriptElement:null,loadTime:null,error:null},AdHubLegacyLoader={init:function(t){this.config=t||e.AdHubLegacyDefaults.getConfig(),this.log("📡 Bundle Loader inizializzato")},load:function(e){if(t.loaded)return this.log("✅ Bundle già caricato"),e&&e(null,!0),Promise.resolve(!0);if(t.loading)return this.log("⏳ Bundle già in caricamento, attesa..."),this.waitForLoad(e);this.log("📡 Caricamento bundle AdHub..."),t.loading=!0,t.attempts++;const o=Date.now();return new Promise(function(i,n){const a=document.createElement("script");a.type="text/javascript",a.async=!0;let r=this.config.adhubBundleUrl;if(this.config.bundleVersion){const e=r.indexOf("?")>-1?"&":"?";r+=e+"v="+this.config.bundleVersion}a.src=r;const l=setTimeout(function(){this.log("⏱️  Timeout caricamento bundle"),this.handleLoadError(new Error("Timeout"),e,n)}.bind(this),this.config.bundleLoadTimeout);a.onload=function(){clearTimeout(l),t.loaded=!0,t.loading=!1,t.loadTime=Date.now()-o,this.log("✅ Bundle caricato con successo in "+t.loadTime+"ms"),this.config.tracking.enabled&&this.config.tracking.events.bundleLoaded&&this.trackEvent("bundle_loaded",{url:this.config.adhubBundleUrl,loadTime:t.loadTime,attempts:t.attempts}),this.waitForAdHub(function(){e&&e(null,!0),i(!0)})}.bind(this),a.onerror=function(){clearTimeout(l),this.log("❌ Errore caricamento bundle"),this.handleLoadError(new Error("Load failed"),e,n)}.bind(this),t.scriptElement=a,document.head.appendChild(a),this.log("📡 Script bundle aggiunto al DOM:",r)}.bind(this))},handleLoadError:function(e,o,i){if(t.loading=!1,t.error=e,this.config.retryBundleLoad&&t.attempts<this.config.maxRetries)return this.log("🔄 Retry caricamento bundle (tentativo "+(t.attempts+1)+")..."),t.scriptElement&&t.scriptElement.parentNode&&(t.scriptElement.parentNode.removeChild(t.scriptElement),t.scriptElement=null),void setTimeout(function(){this.load(o)}.bind(this),this.config.retryDelay);t.failed=!0,this.log("❌ Caricamento bundle fallito definitivamente dopo "+t.attempts+" tentativi"),this.config.tracking.enabled&&this.config.tracking.events.errors&&this.trackEvent("bundle_load_failed",{error:e.message,attempts:t.attempts,url:this.config.adhubBundleUrl}),o&&o(e,!1),i&&i(e)},waitForLoad:function(e){return new Promise(function(o,i){const n=this.config.bundleLoadTimeout;let a=0;const r=function(){if(t.loaded)return e&&e(null,!0),void o(!0);if(t.failed){const o=t.error||new Error("Load failed");return e&&e(o,!1),void i(o)}if(a+=100,a>=n){const t=new Error("Wait timeout");return e&&e(t,!1),void i(t)}setTimeout(r,100)}.bind(this);r()}.bind(this))},waitForAdHub:function(t){this.log("⏳ Attesa inizializzazione AdHub...");let o=0;const i=function(){return e.AdHubGAM&&e.AdHubAutoInit&&"undefined"!=typeof pbjs?(this.log("✅ AdHub pronto"),void(t&&t())):(o+=100,o>=5e3?(this.log("⚠️  Timeout attesa AdHub, procedo comunque"),void(t&&t())):void setTimeout(i,100))}.bind(this);i()},isLoaded:function(){return t.loaded},isLoading:function(){return t.loading},hasFailed:function(){return t.failed},getState:function(){return{loaded:t.loaded,loading:t.loading,failed:t.failed,attempts:t.attempts,loadTime:t.loadTime,error:t.error?t.error.message:null}},reset:function(){t.loaded=!1,t.loading=!1,t.failed=!1,t.attempts=0,t.scriptElement=null,t.loadTime=null,t.error=null,this.log("🔄 Stato loader resettato")},trackEvent:function(e,t){if(!this.config.tracking.enabled)return;const o={name:e,timestamp:Date.now(),data:t};this.log("📊 Track:",o)},log:function(){if(this.config&&this.config.debug){const e=Array.prototype.slice.call(arguments);console.log.apply(console,["[AdHub Legacy Loader]"].concat(e))}},debug:function(){console.group("📡 AdHub Legacy Loader - Debug"),console.log("Config:",this.config),console.log("State:",this.getState()),console.log("Bundle URL:",this.config.adhubBundleUrl),console.groupEnd()}};e.AdHubLegacyLoader=AdHubLegacyLoader}(window),function(e,t){"use strict";if(e.__AdHubLegacySDKLoaded)return void console.warn("[AdHub Legacy SDK] SDK già caricato - Skip duplicato");e.__AdHubLegacySDKLoaded=!0;const AdHubLegacySDK={version:"1.0.0",initialized:!1,config:null,parser:null,placeholder:null,loader:null,results:{tags:[],placeholders:[],errors:[]},init:function(e){this.initialized?console.warn("[AdHub Legacy SDK] SDK già inizializzato"):(console.log("[AdHub Legacy SDK] 🚀 Inizializzazione v"+this.version+"..."),this.loadConfig(e),this.checkDebugMode(),this.initComponents(),this.processTags(),this.loadAdHubBundle(),this.initialized=!0,console.log("[AdHub Legacy SDK] ✅ Inizializzazione completata"))},loadConfig:function(t){const o=e.AdHubLegacyDefaults.loadFromWindow();this.config=t?e.AdHubLegacyDefaults.mergeConfig(Object.assign({},o,t)):o,this.log("⚙️  Configurazione caricata:",this.config)},checkDebugMode:function(){const t=new URLSearchParams(e.location.search);"1"!==t.get("legacy_debug")&&"legacy"!==t.get("debug")||(this.config.debug=!0,console.log("[AdHub Legacy SDK] 🐛 Debug mode attivato da URL")),!0===e.AdHubLegacyDebug&&(this.config.debug=!0,console.log("[AdHub Legacy SDK] 🐛 Debug mode attivato da window.AdHubLegacyDebug"))},initComponents:function(){this.log("🔧 Inizializzazione componenti..."),e.AdHubLegacyParser?(this.parser=e.AdHubLegacyParser,this.parser.init(this.config),this.log("✅ Parser inizializzato")):console.error("[AdHub Legacy SDK] ❌ Parser non trovato!"),e.AdHubLegacyPlaceholder?(this.placeholder=e.AdHubLegacyPlaceholder,this.placeholder.init(this.config),this.log("✅ Placeholder generator inizializzato")):console.error("[AdHub Legacy SDK] ❌ Placeholder generator non trovato!"),e.AdHubLegacyLoader?(this.loader=e.AdHubLegacyLoader,this.loader.init(this.config),this.log("✅ Loader inizializzato")):console.error("[AdHub Legacy SDK] ❌ Loader non trovato!")},processTags:function(){if(this.log("📋 Processamento tag..."),!this.parser)return void console.error("[AdHub Legacy SDK] ❌ Parser non disponibile");const e=this.parser.processAll();this.results.tags=e,this.log("📊 Tag processati: "+e.length),0!==e.length?this.createPlaceholders(e):this.log("⚠️  Nessun tag da processare")},createPlaceholders:function(e){if(this.log("🏗️  Creazione placeholder..."),!this.placeholder)return void console.error("[AdHub Legacy SDK] ❌ Placeholder generator non disponibile");const t=this.placeholder.createAll(e);this.results.placeholders=t,this.log("📊 Placeholder creati: "+t.length),this.configureTargeting(t)},configureTargeting:function(t){this.log("🎯 Configurazione targeting..."),e.AdHubGAM?t.forEach(function(e){const t=e.tag;t.targeting&&this.log("🎯 Targeting per "+e.id+":",t.targeting)}.bind(this)):this.log("⏳ AdHub non ancora caricato, targeting configurato dopo load")},loadAdHubBundle:function(){this.config.autoLoadBundle?this.loader?(this.log("📡 Caricamento bundle AdHub..."),this.loader.load(function(e,t){if(e)return console.error("[AdHub Legacy SDK] ❌ Errore caricamento bundle:",e),void this.results.errors.push({type:"bundle_load",error:e.message});this.log("✅ Bundle AdHub caricato con successo"),this.configureTargeting(this.results.placeholders),this.dispatchReadyEvent()}.bind(this))):console.error("[AdHub Legacy SDK] ❌ Loader non disponibile"):this.log("⏭️  Auto-load bundle disabilitato")},dispatchReadyEvent:function(){this.log("📢 Dispatch evento adhub:legacy:ready");const t=new CustomEvent("adhub:legacy:ready",{detail:{version:this.version,tags:this.results.tags.length,placeholders:this.results.placeholders.length,stats:this.getStats()}});e.dispatchEvent(t)},getStats:function(){return{sdk:{version:this.version,initialized:this.initialized},parser:this.parser?this.parser.getStats():null,placeholder:this.placeholder?this.placeholder.getStats():null,loader:this.loader?this.loader.getState():null,results:{tags:this.results.tags.length,placeholders:this.results.placeholders.length,errors:this.results.errors.length}}},getConfig:function(){return this.config},getResults:function(){return this.results},log:function(){if(this.config&&this.config.debug){const e=Array.prototype.slice.call(arguments);console.log.apply(console,["[AdHub Legacy SDK]"].concat(e))}},debug:function(){console.group("🔍 AdHub Legacy SDK - Complete Debug"),console.log("Version:",this.version),console.log("Initialized:",this.initialized),console.log("Config:",this.config),console.log("Stats:",this.getStats()),console.log("Results:",this.results),this.parser&&(console.group("Parser"),this.parser.debug(),console.groupEnd()),this.placeholder&&(console.group("Placeholder"),this.placeholder.debug(),console.groupEnd()),this.loader&&(console.group("Loader"),this.loader.debug(),console.groupEnd()),e.AdHubLegacyDimensions&&(console.group("Dimensions"),e.AdHubLegacyDimensions.debug(),console.groupEnd()),console.groupEnd()}};e.AdHubLegacySDK=AdHubLegacySDK,"loading"===t.readyState?t.addEventListener("DOMContentLoaded",function(){AdHubLegacySDK.init()}):AdHubLegacySDK.init(),console.log("[AdHub Legacy SDK] ✅ SDK caricato v"+AdHubLegacySDK.version)}(window,document);